package lsedit;

import java.applet.*;

import java.awt.*;



public class LsButtonMenu extends LsPopupMenu {



	public LsButtonMenu() {

	}



	public void set(MenuButton b, Applet ls, 

				String[] menuEntries, int[] menuKeys, boolean[] grayStates)

	{

		// We want real popup menus, but AWT doesn't yet have them,

		// and Netscape/Appletviewer are generally uncooperative

		// at displaying frameless windows. So, for now, we will 

		// draw the menus directly.



		Graphics g = ls.getGraphics(); 

		applet = ls; 



		g.setFont(font);

		FontMetrics fm = g.getFontMetrics();



		fontHeight = Util.fontHeight(font);	 // Util.fontHeight(fm);



		Rectangle rect = b.bounds();



		int x = 0; 

		int y = MARGIN;



		setupMaxWidthCalc();



		for (int i=0; i<menuEntries.length; i++) {

			calcMaxWidth(menuEntries[i], fm); 

		} 



		LsPopupMenuItem item = null; 



		int width = getMaxWidth(); 

		int height = fontHeight + Y_OFFSET*2; 



		for (int i=0; i<menuEntries.length; i++) {

			int h = (menuEntries[i].equals("-") ? MARGIN : height);



			LsPopupMenuItem nitem;



			if (menuKeys[i] != 0) {

				nitem = new LsPopupMenuItem(menuEntries[i], 

								String.valueOf(menuKeys[i]),

								grayStates[i], x, y, width, h); 

			}

			else {

				nitem = new LsPopupMenuItem(menuEntries[i], "", false, 

												x, y, width, h); 

			}



			if (i == 0)

				firstItem = nitem;

			else  

				item.next = nitem;

			item = nitem; 



			y += h; 

		}



		Rectangle r = b.bounds();



		height = y + MARGIN; 



		popup(width, height, 

				r.x + 10, r.y + r.height + 5); 



		g.dispose();

	}



	public int getKey(Event ev, int x, int y) {

		mouseUp(ev, x, y);



		// Return menu key integer value 



		LsPopupMenuItem item = overItem(x, y);



		if (item == null)

			return 0;



		return Integer.parseInt(item.link); 

	}

}





