package lsedit;

import java.applet.*;
import java.awt.*;
import java.util.*; 

public class LsViewMenu extends LsLinkMenu {

	public LsViewMenu() {
		hide();
	}

	public void set(String label, CommandList cl, Attribute views, Rectangle slyt, LandscapeViewerCore ls, int xpos, int ypos)
	{
		// We want real popup menus, but AWT doesn't yet have them,
		// So, for now, we will use a canvas control.

		Graphics g = ls.getGraphics();

		String[] commands = cl.commandStrings;
		int[] keys = cl.commandKeys;

		applet = ls; 

		g.setFont(font);
		FontMetrics fm = g.getFontMetrics();

		fontHeight = Util.fontHeight(font);
		int height = fontHeight + Y_OFFSET;

		int x = 0; 
		int y = MARGIN;

		setupMaxWidthCalc();
		calcMaxWidth(label, fm); 

		if (views != null && views.avi != null) {
			// Determine maximum width of menu entries and label 
			AttributeValueItem avi = views.avi;
			while (avi != null) {
				calcMaxWidth(avi.value, fm);  // Label is first el of list
				avi = avi.nextList;
			}
		}

		if (commands != null) {
			for (int i = 0; i < commands.length; i++) {
				calcMaxWidth(commands[i], fm);
			}
		}

		int width = getMaxWidth();

		firstItem = new LsPopupMenuItem(label, "", false, x, y, width, height);
		y += height;

		LsPopupMenuItem item = firstItem; 

		if (views != null && views.avi != null) {
			AttributeValueItem avi = views.avi;

			item.next = new LsPopupMenuItem("-", "", false, x, y, width, MARGIN);
			item = item.next;

			y += MARGIN; 

			while (avi != null) {
				label = avi.value;

				String target = avi.next.next.value;
				String link	 = avi.next.value; 

				int h = (label.equals("-") ? MARGIN : height);
				item.next =	  new LsPopupMenuItem(label, link, target, false, x, y, width, h); 
				item = item.next; 
				y += h; 
				avi = avi.nextList;
			}
		}

		if (commands != null) {
			item.next = new LsPopupMenuItem("-", "", false, x, y, width, MARGIN);
			item	  = item.next;

			y += MARGIN; 

			for (int i = 0; i<commands.length; i++) {
				label = commands[i];
				String link = "" + keys[i];

				int h = (label.equals("-") ? MARGIN : height);
				item.next = new LsPopupMenuItem(label, link, LsLink.TARGET_APP_STR, false, x, y, width, h); 
				item = item.next; 
				y += h; 
			}
		}

		height = y + MARGIN; 

		// Adjust position to make sure it is all within the applet

		Rectangle rect = ls.bounds();

		if (ypos + height > rect.y + rect.height) {
			ypos = rect.y + rect.height - height - 5;
		}

		if (xpos + width > slyt.x + slyt.width) {
			xpos = slyt.x + slyt.width - width - 5;
		}

		popup(width, height, xpos, ypos); 

		g.dispose();
	}

	public void set(String label, CommandList cl, Attribute views, EntityInstance root, LandscapeViewerCore ls, int xpos, int ypos)
	{
		Layout		 rootLyt = root.getLayout(); 
		ScreenLayout slyt	 = new ScreenLayout(rootLyt);

		set(label, cl, views, slyt, ls, xpos, ypos);
	}

	public LsLink getLink(Event ev, int x, int y) {

		mouseUp(ev, x, y); 

		// If entry with non-null link is highlighted, return the link.
		LsPopupMenuItem item = overItem(x, y);

		if (item == null || !item.isHighlightable()) {
			if (item == null)
				MsgOut.dprintln("no over item");
			else
				MsgOut.dprintln("not link item");
			return null;
		}

		return new LsLink(item.link, item.target); 
	}
}


