package lsedit;

import java.applet.*;

import java.awt.*;

import java.util.*;



public class MapBox extends TabbedBox {



	protected static final double DIV = 2;



	protected static final double HALF_VGAP = (GAP*3.0)/2.0;



	protected static final Font textFont =

				new Font("Helvetica", Font.PLAIN, 10); 



	protected static final String helpStr =

		"This box shows stylized versions of landscapes representing the path from the top of the containment heirarchy to the current landscape, with green boxes highlighting steps in the path.";



	protected static final int TY_CLEAR	 = 0;

	protected static final int TY_RAISED = 1;

	protected static final int TY_SUNK	 = 2;



	protected int over = -1;

	protected int mouseDown = -1;



	protected Vector maps, entities;



	protected int getIndex(int x, int y) {

		Enumeration en = maps.elements();



		int ind = 0;



		while (en.hasMoreElements()) {

			Rectangle r = (Rectangle) en.nextElement();



			if (x >= r.x && x <= r.x+r.width &&

				y >= r.y && y <= r.y+r.height)

			{

				return ind;

			}

			ind++;

		}



		return -1;

	}

 

	protected void drawOutline(int ind, int type) {

		Rectangle r = (Rectangle) maps.elementAt(ind);



		Graphics g = ls.getGraphics();



		g.setColor(Diagram.boxColour);



		if (type != TY_CLEAR)

			g.draw3DRect(r.x, r.y, r.width, r.height, type == TY_RAISED);

		else

			g.drawRect(r.x, r.y, r.width, r.height);

	}



	protected void drawEntity(Graphics g, EntityInstance e, Layout plyt, 

								double xoff, double yoff,

								double scale, boolean highlight, 

								boolean parent)

	{

		Layout lyt = e.getLayout();



		lyt.x = (lyt.x - plyt.x) * scale + xoff;

		lyt.y = (lyt.y - plyt.y) * scale + yoff;

		lyt.width *= scale;

		lyt.height *= scale;



		ScreenRect sr = new ScreenRect(lyt.x, lyt.y, lyt.width, lyt.height);



		if (highlight) {

			g.setColor(Color.green);

		}

		else if (!parent && !e.isOpen()) {

			g.setColor(e.getObjectColor());

		}

		else {

			if (e.isEnterable()) {

				float v = Diagram.BG - 0.05f;



				Color c = new Color(v, v, v);



				g.setColor(c);

			}

			else {

				g.setColor(Diagram.boxColour);

			}

		}



		g.fillRect(sr.x, sr.y, sr.width, sr.height);

		g.setColor(Color.black);

		g.drawRect(sr.x, sr.y, sr.width, sr.height);

	}



	protected void doDrawLevel(Graphics g, EntityInstance e, 

								EntityInstance re, EntityInstance ne,

								Layout plyt, double scale,

								double xoff, double yoff)

	{

		if (e.getParent() != null)	{

			drawEntity(g, e, plyt, 

						xoff, yoff, scale, (e == ne), (e == re));

		}



		if (e != ne && (e == re || e.isOpen())) {

			Enumeration en = e.getChildren();



			while (en.hasMoreElements()) {

				EntityInstance ce = (EntityInstance) en.nextElement();



				doDrawLevel(g, ce, re, ne, plyt, scale, xoff, yoff);

			}

		}

	}





	protected double drawLevel(Graphics g, 

								EntityInstance pe, EntityInstance ne,

								double yoff)

	{

		Layout plyt = pe.getLayout();



		double w = width;



		double scale = (w-w/DIV)/plyt.width;



		double pw = (plyt.width * scale);

		double ph = (plyt.height * scale);



		double xoff = (width - pw)/2;



		doDrawLevel(g, pe, pe, ne, plyt, scale, xoff, yoff);



		return ph;

	}



	protected boolean drawing = false;



	protected void drawContents(Diagram dg, Graphics g, boolean fullInfo) {

		maps = new Vector();

		entities = new Vector();



		dg.saveLayout();



		dg.rescale();



		Vector drawSet = new Vector();



		EntityInstance e = dg.getRoot();



		while (e != null) {

			if (e.isEnterable())

				drawSet.addElement(e);

			e = e.getParent();

		}



		Rectangle r = bounds();



		int num = drawSet.size();



		double ypos = scrollBar.getValue();

		double iypos = ypos;



		double hf = Util.fontHeight(textFont);

		g.setFont(textFont);



		for (int i = num-1; i >=0 ; i--) {

			int oypos = (int) (ypos + 0.5);



			e = (EntityInstance) drawSet.elementAt(i);



			EntityInstance ne = (i == 0 ? null : 

									(EntityInstance) drawSet.elementAt(i-1));



			g.setColor(Color.black);



			Util.drawStringClipped(g, e.getLabel(), 0, ypos, r.width, hf,

										true, false);



			ypos += (HALF_VGAP + hf);



			double ht = drawLevel(g, e, ne, ypos);



			maps.addElement(

				new Rectangle(r.x + GAP*4, 

				r.y + tabDim.height + oypos + GAP, 

				r.width-GAP*8, (int) (ht+hf+HALF_VGAP*2-4+0.5))

			);



			entities.addElement(e);



			ypos += (ht + HALF_VGAP);



			if (i > 0) {

				ScreenPoint p1 = new ScreenPoint(GAP*2, ypos);

				ScreenPoint p2 = new ScreenPoint(r.width-GAP*2, ypos);



				Util.drawLine(g, p1, p2, Util.LINE_STYLE_INSCRIBED);

			}

			

			ypos += HALF_VGAP;

		}



		int hd = (int) (ypos - iypos);



		dg.restoreLayout();



		setupScrolling(hd);



		over = -1;

	}





	// --------------

	// Public methods 

	// --------------



	public MapBox(LandscapeViewerCore ls) {

		super(ls, "Map", 54);

	}



	public boolean handleEvent(Diagram dg, Graphics gc, Event event) {

		return super.handleEvent(dg, gc, event);

	}



	public void activate() {

		super.activate();

	}



	public void inactivate() {

		super.inactivate();

	}



	public boolean mouseDown(Event ev, int x, int y) {

//		System.out.println("MapBox mousedown\n");

		if (over >= 0) {

			mouseDown = over;

			drawOutline(over, TY_CLEAR);

			drawOutline(over, TY_SUNK);

			return true;

		}



		return false;

	}



	public boolean mouseUp(Event ev, int x, int y) {

		if (mouseDown >= 0) {

			if (over == mouseDown) {

				EntityInstance e = (EntityInstance) entities.elementAt(over);



				drawOutline(over, TY_CLEAR);

				ls.followLink(e, false);

			}

			else {

				/*[irbull]

				 * this will screw us up sometimes 

				 */

/*

				System.out.println("over: " + over);

				drawOutline(over, TY_RAISED);

*/

			}

			mouseDown = -1;

			return true;

		}



		return false;

	}



	public boolean mouseMotion(Event ev, int x, int y) {

		ls.setHelpPopup(helpStr, x, y);



		int ind = getIndex(x, y);



		if (ind == over) {

			return (ind >= 0);

		}



		if (over >= 0)

			drawOutline(over, TY_CLEAR);



		if (ind >= 0)	

			drawOutline(ind, TY_RAISED);



		over = ind;

		return true;

	}



	public boolean mouseDrag(Event ev, int x, int y) {

		if (mouseDown == -1)

			return false;



		int ind = getIndex(x, y);



		if (ind == over)

			return true;



		if (over >= 0)

			drawOutline(over, TY_CLEAR);



		if (ind == mouseDown)

			drawOutline(ind, TY_SUNK);



		over = ind;

		return true;

	}

}

