package lsedit;

import java.applet.*;

import java.awt.*;

import java.util.*;



public class MenuButton extends Canvas {



	protected static final int MARGIN = 4;



	protected String label; 

	protected LandscapeViewerCore ls; 

	protected Font font; 

	protected int fontHeight; 

	protected LsButtonMenu menu; 



	protected String[]	menuEntries;

	protected int[]		menuKeys;

	protected boolean[] grayStates; 



	public MenuButton(String label, LandscapeViewerCore ls, Font font,

				String[] menuEntries, int[] menuKeys, boolean[] grayStates)

	{

		this.label = label;

		this.ls = ls; 

		this.menuEntries = menuEntries;

		this.menuKeys = menuKeys; 

		this.grayStates = grayStates; 

		this.font = font; 



		menu = new LsButtonMenu();

		menu.hide();

		ls.add(menu);



		setFont(font);

		setBackground(Color.lightGray);

		setForeground(Color.black); 



		FontMetrics fm = getFontMetrics(font);



		int width = fm.stringWidth(label) + MARGIN*4;

		fontHeight = Util.fontHeight(font);	 // Util.fontHeight(fm);



		int height = fontHeight + MARGIN*4;



		resize(width, height);

	}



	public void paint(Graphics g) {

		Dimension dim = size();



		g.setColor((menu.isVisible()) ? Color.gray : getBackground());

		g.fillRect(0, 0, dim.width-MARGIN, dim.height-MARGIN);



		g.draw3DRect(0, 0, dim.width-MARGIN, dim.height-MARGIN, true);

		g.draw3DRect(1, 1, dim.width-MARGIN-2, dim.height-MARGIN-2, true);



		g.setFont(font); 

		g.setColor(getForeground()); 

		g.drawString(label, MARGIN+2, MARGIN/2+fontHeight); 

	}

	public int resizeButton() 
	{
		Rectangle rect = bounds();

		fontHeight = Util.fontHeight(font);
		int height = fontHeight + MARGIN*3;

		resize(rect.width, height); 
		return rect.width;
	}



	public boolean mouseDown(Event ev, int x, int y) 
	{
//		System.out.println("MenuButton mousedown\n");
		repaint();
		menu.set(this, ls, menuEntries, menuKeys, grayStates); 
		return true;
	}



	public boolean mouseDrag(Event ev, int x, int y) 
	{
		Point pt = location();
		return menu.mouseDrag(ev, x+pt.x, y+pt.y); 
	}

	public boolean mouseUp(Event ev, int x, int y) 
	{
		Point pt = location();
		int key = menu.getKey(ev, x+pt.x, y+pt.y);	
		menu.hide();
		ls.processMenuSelection(this, key); 
		return true; 
	}
}

