package lsedit;

import java.awt.*;

import java.util.*;



public class MoveModeHandler extends LandscapeModeHandler

{

	protected double dx, dy;

	protected Layout curLayout;



	protected EdgePoint ept;



	protected boolean moveBendStart(Event ev, int x, int y) {

		ls.doFeedback("Bend point at (" + x + ", " + y + ")");



		dg.setDrawEdges(false);

		ls.redrawDg();



		gc.setXORMode(bend.e.getBackground());

		dg.drawEdge(gc, ri);

		return true;

	}



	protected void moveBendMotion(Event ev, int x, int y) {

		ls.doFeedback("Bend point at (" + x + ", " + y + ")");



		dg.drawEdge(gc, ri);

		bend.x = x;

		bend.y = y;

		dg.drawEdge(gc, ri);

	}



	protected void moveBendEnd(Event ev, int x, int y) {

		dg.setDrawEdges(true);

		dg.moveBend(bend, x, y);

		ls.redrawDg();

	}



	// IO points



	protected RealPoint getFactors(int x, int y) {

		// Can only have factors along edges 

		// Find closest edge and calculate new width and height factors



		Layout lyt = ept.getEntity().getLayout();



		double xp = x;

		double yp = y;



		double dl = Math.abs(xp - lyt.x);

		double dr = Math.abs(xp - (lyt.x + lyt.width));

		double dt = Math.abs(yp - lyt.y);

		double db = Math.abs(yp - (lyt.y + lyt.height));



		double wf, hf;



		if (dl < dr) {

			if (dt < db) {

				if (dt < dl) {

					// Top

					wf = (xp - lyt.x)/lyt.width;

					hf = 0.0;

				}

				else {

					// Left

					wf = 0.0;

					hf = (yp - lyt.y)/lyt.height;

				}

			}

			else if (db < dl) {

				// Bottom

				wf = (xp - lyt.x)/lyt.width;

				hf = 1.0;

			}

			else {

				// Left

				wf = 0.0;

				hf = (yp - lyt.y)/lyt.height;

			}

		}

		else {

			if (dt < db) {

				if (dt < dr) {

					// Top

					wf = (xp - lyt.x)/lyt.width;

					hf = 0.0;

				}

				else {

					// Right

					wf = 1.0;

					hf = (yp - lyt.y)/lyt.height;

				}

			}

			else if (db < dr) {

				// Bottom

				wf = (xp - lyt.x)/lyt.width;

				hf = 1.0;

			}

			else {

				// Right

				wf = 1.0;

				hf = (yp - lyt.y)/lyt.height;

			}

		}



		wf = Math.max(0.0, Math.min(1.0, wf));	// Normalize

		hf = Math.max(0.0, Math.min(1.0, hf));



		return new RealPoint(wf, hf);

	}



	protected boolean moveIOStart(Event ev, int x, int y) {

		dg.setDrawEdges(false);

		ls.redrawDg();



		gc.setXORMode(e.getBackground());

		dg.drawEdge(gc, ri);



		RealPoint factors = getFactors(x, y);

		

		ls.doFeedback("I/O point at factors (" + 

						factors.x + ", " + factors.y + ")");

		return true;

	}

	

	protected void moveIOMotion(Event ev, int x, int y) {



		dg.drawEdge(gc, ri);



		RealPoint factors = getFactors(x, y);

		

		ept.wf = factors.x;

		ept.hf = factors.y;



		ls.doFeedback("I/O point at factors (" + 

						factors.x + ", " + factors.y + ")");



		ept.rescale();

		

		dg.drawEdge(gc, ri);

	}



	protected void moveIOEnd(Event ev, int x, int y) {

		// Determine if it has been moved to default location



		ept.isDefault = false;

		

		dg.setDrawEdges(true);

		ls.redrawDg();

	}



	// --------------

	// Public methods

	// --------------



	public MoveModeHandler() {

	}



	public boolean mouseDown(Event ev, int x, int y) {

//		System.out.println("MoveModeHandler mousedown\n");

		e = null;

		ri = null;

		bend = null;

		ept = null;



		e = dg.mouseOverEx(x, y);



		if (e == null)

			return false;



		if (!ls.isViewer()) {

			ept = dg.mouseOverIO(e, x, y);



			if (ept != null) {

				ri = dg.mouseOverAnyEdge(ept.getEntity(), x, y);



				if (ri != null) {

					moveIOStart(ev, x, y);

					return true;

				}



				MsgOut.println("Missing relation");

				return false;

			}



			bend = dg.mouseOverBend(x, y);

		}



		if (bend != null)

			ri = bend.getFirstEdge();



		if (bend != null) {

			moveBendStart(ev, x, y);

			return true;

		}

		

		if (ri != null) {

			dx = x;

			dy = y;

			return true;

		}



		return false;

	}



	public boolean mouseDrag(Event ev, int x, int y) {

		if (ept != null) 

			moveIOMotion(ev, x, y);

		else if (bend != null)

			moveBendMotion(ev, x, y);

		return true;

	}



	public void mouseUp(Event ev, int x, int y) {

		ls.clearFeedback();



		if (ept != null) {

			moveIOEnd(ev, x, y);

		}

		else if (bend != null) {

			moveBendEnd(ev, x, y);

		}

	}



	public void drawOutline() {

		dg.drawEntityOutline(gc, curLayout, e);

	}



	public void setLayout() {

		curLayout = (Layout) e.getLayout().clone();

	}

}

