package lsedit;

import java.awt.*;
import java.applet.*;
import java.util.*;

public class MyComponent extends Object {

	protected int x, y, width, height;

	protected boolean visible = true;
	protected Font font;
	protected Color bgnd;

	// --------------
	// Public Methods
	// --------------

	public MyComponent() {
		x = 0;
		y = 0;
		width = 10;
		height = 10;
	}



	public void move(int x, int y) {
		this.x = x;
		this.y = y;
	}

	public void resize(int width, int height) {
		this.width = width;
		this.height = height;
	}

	public void reshape(int x, int y, int width, int height) {
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}

	public boolean isVisible() {
		return visible;
	}

	public void hide() {
		visible = false;
	}

	public void show() {
		visible = true;
	}

	public Font getFont() {
		return font;
	}

	public void setFont(Font font) {
		this.font = font;
	}

	public Color getBackground() {
		return bgnd;
	}

	public void setBackground(Color c) {
		bgnd = c;
	}

	public Rectangle bounds() {
		return new Rectangle (x, y, width, height);
	}

	public boolean isMouseOver(int x, int y) {
		Rectangle r = bounds();
		return visible && (x >= r.x && x <= r.x + r.width && y >= r.y && y <= r.y + r.height); 
	}

	public boolean mouseMotion(Event ev, int x, int y) {
		return false;
	}

	public boolean mouseDown(Event ev, int x, int y) {

//		System.out.println("MyComponent mousedown\n");

		return false;
	}

	public boolean mouseDrag(Event ev, int x, int y) {
		return false;
	}

	public boolean mouseUp(Event ev, int x, int y) {
		return false;
	}
}

