package lsedit;

import java.awt.*;

import java.util.*;



public class NavigateModeHandler extends LandscapeModeHandler
{
	protected int curTab;
	protected boolean highFlag;		   
	protected boolean middleButton;
	protected boolean ctrlButton;

	protected final static String titleStr = "Navigate mode options";

	protected final static String helpStr = "Left - Enter (in viewer)\nCtrl+Left Exit\nMiddle - Enter (new viewer)";

	protected boolean navigateStart(Event ev, int x, int y) {

		e = dg.mouseOver(x, y);

		if (e == null)

			return false;



		highFlag = true;

		if (e.isClickable()) {

			dg.drawEntityHighlight(gc, e);

			return true;

		}

		return false;

	}



	protected boolean navigateMotion(Event ev, int x, int y) {

		if (highFlag && (dg.mouseOver(x, y) != e)) {

			dg.undrawEntityHighlight(gc, e);

			highFlag = false;

		}

		else if (!highFlag && (dg.mouseOver(x, y) == e)) {

			dg.drawEntityHighlight(gc, e);

			highFlag = true;

		}

		return true;

	}



	protected void navigateEnd(Event ev, int x, int y) {

		EntityInstance over = dg.mouseOver(x, y);



		dg.undrawEntityHighlight(gc, e);



		if (over != e || over == null) {
			return;
		}

		ls.followLink(e, middleButton);

	}



	// --------------

	// Public methods

	// --------------



	public NavigateModeHandler() {

	}



	public boolean mouseDown(Event ev, int x, int y) {

//		System.out.println("NavigateModeHandler mousedown\n");

		middleButton = (ev.modifiers & Event.ALT_MASK) != 0;

		return navigateStart(ev, x, y);

	}



	public boolean mouseDrag(Event ev, int x, int y) {

		if (e != null)

			navigateMotion(ev, x, y);



		return true;

	}



	public void mouseUp(Event ev, int x, int y) {

		if (e != null)

			navigateEnd(ev, x, y);

	}

	

	public void mouseDoubleClick(Event ev, int x, int y) {

		EntityInstance over = dg.mouseOverEx(x, y);

		

		if (over != null) {

			boolean middleButton = (ev.modifiers & Event.ALT_MASK) != 0;

			

			ls.followLink(over, middleButton);

		}

	}



	public void setHelp(TextBox tb) {

		tb.set(titleStr, helpStr);

	}

}

