package lsedit;

import java.awt.*;



public class OkMsgBox extends Dialog {

	protected Button button;

	protected MultiLineLabel label;



	public OkMsgBox(Frame f, String title, String message)

	{

		// Create a dialog 

		super(f, title, true);



		// Create and use a BorderLayout manager with specified margins

		this.setLayout(new BorderLayout(15, 15));

		

		// Create the message component and add it to the window

		label = new MultiLineLabel(message, 20, 20);

		this.add("Center", label);

		

		// Create an Okay button in a Panel; add the Panel to the window

		// Use a FlowLayout to center the button and give it margins.

		button = new Button("OK");

		Panel p = new Panel();

		p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));

		p.add(button);

		this.add("South", p);



		// Resize the window to the preferred size of its components

		this.pack();

	}



	

	// Pop down the window when the button is clicked.

	public boolean action(Event e, Object arg)

	{

		if (e.target == button) {

			this.hide();

			this.dispose();

			return true;

		}

		else return false;

	}



	// When the window gets the keyboard focus, give it to the button.

	// This allows keyboard shortcuts to pop down the dialog.

	public boolean gotFocus(Event e, Object arg) {

		button.requestFocus();

		return true;

	}



	public static void Create(Panel p, String title, String message) {

		Container c = p; 



		do { 

			c = c.getParent(); 

		} while (!(c instanceof Frame)); 

			

		OkMsgBox mb = new OkMsgBox((Frame) c, title, message);

		mb.show();

	}

}

