package lsedit;

import java.applet.*;

import java.awt.*;

import java.util.*;



public class ResultBox extends TabbedBox {



	protected static final Font textFont =

				new Font("Helvetica", Font.PLAIN, 11); 



	protected static final Font titleFont =

				new Font("Helvetica", Font.BOLD, 14);



	protected static final String helpStr =

		"This box shows the results of queries, and groupings";



	protected String text; 

	protected String title;



	protected ClickHandler ch = null;



	private	  String m_link;
	private	  String m_target;


	protected void processLine(Graphics g, String line, int xpos, int ypos, int w, int h) 
	{

		FontMetrics fm = g.getFontMetrics();
		int ht = Util.fontHeight(fm);
		int start, ind, lth;
		String dstr, tagLine;

		start = 0;
		while (start < line.length()) {

			ind = line.indexOf('<', start);

			if (ind != start) {
				if (ind > start) {
					dstr = line.substring(start, ind);			// ie. stuff before <'
				} else {
					dstr = line.substring(start);
				}

				Util.drawStringClipped(g, dstr, xpos, ypos, w, h);
				lth	  = fm.stringWidth(dstr);			

				if (lth == 0) {
					 // Fix Java Bug here "	   " has width 0.
					 lth = fm.charWidth('_') * dstr.length();
				}
				

				xpos += lth;

				if (ind < start) {
					return;
			}	}


			// Now process link tag

			int eind	   = line.indexOf('>', ind);

			if (eind < 0) {
				return;
			}

			tagLine = line.substring(ind+1, eind);				// ie. contents of tag
			start	= eind + 1;

			if (tagLine.equals("/a")) {
				g.setColor(Color.black);
				m_link = null;
				m_target = null;
				continue;
			}

			if (!tagLine.startsWith("a href='")) {
				// Whatever this is it ain't text
				continue;
			}

			ind	 = tagLine.indexOf('\'', 8);
			m_link = tagLine.substring(8, ind);			// ie value of href
			tagLine = tagLine.substring(ind+1);
			ind = tagLine.indexOf("target='");
			tagLine = tagLine.substring(ind+8);					// ie targetvalue ...
			ind = tagLine.indexOf("'");
			m_target = tagLine.substring(0, ind);				// ie value of target
			g.setColor(Color.blue);
		}
	}

	// Protected methods 


	protected void drawContents(Diagram dg, Graphics g, boolean fullInfo) {

/*
		System.out.println("ResultBox.drawContents");	// IJD
		java.lang.Thread.dumpStack();
		System.out.println("-----");
*/

		// Draw title 



		Rectangle r = bounds();



		g.setFont(titleFont);

		g.setColor(titleColor);



		int h = Util.fontHeight(titleFont);

						// Util.fontHeight(g.getFontMetrics());



		int xpos = GAP*2;

		int ypos = GAP;



		Util.drawStringClipped(g, title, xpos, ypos, r.width-GAP*2, h);

		ypos += h + 7;



		// Now lines of text



		g.setColor(Color.black);

		g.setFont(textFont);



		FontMetrics fm = g.getFontMetrics();



		h = Util.fontHeight(textFont) - 2;



		// Output as many lines as we can of the description within the

		// text box provided by parsing the description for words.



		int width = r.width-GAP*2;



		if (scrollBar != null && scrollBar.isVisible())

			width -= (SB_WIDTH+GAP);



		StringLinizer sl = new StringLinizer(text, fm, width);

		m_link	 = null;
		m_target = null;

		int mypos = r.height-h-GAP;

		while (sl.hasMoreLines() && ypos < mypos) {

			String line = sl.nextLine();

//			System.out.println("ResultBox.processLine line=" + line);

			processLine(g, line, xpos, ypos, r.width-GAP*2, h);
			ypos += (h+2);
		} 

	}





	// --------------

	// Public methods 

	// --------------



	public ResultBox(LandscapeViewerCore ls) {

		super(ls, "Results", 140);

	}



	public void set(String title, String text, ClickHandler ch, boolean act) {

		this.ch = ch;

		this.title = title;

		this.text = text; 

		if (act) {
			ls.activateTabBox(this);
		}
		repaint();

	}



	public void set(String title, String text, ClickHandler ch) {

		set(title, text, ch, true);

	}



	public void set(String title, String text) {

		set(title, text, null, true);
	}



	public void clear() {

		ch = null;
		title = "";
		text = "";

		if (active) {
			repaint();
		}

	}


	public boolean mouseMotion(Event ev, int x, int y) {

		ls.setHelpPopup(helpStr, x, y);

		return true;

	}



	public boolean handleEvent(Diagram dg, Graphics gc, Event event) {

		return super.handleEvent(dg, gc, event);

	}

}

