package lsedit;

import java.applet.*;

import java.awt.*;

import java.net.*;

import java.io.*;

import java.util.*;



public class ScrollableDiagram extends Diagram {



	protected static final int SB_WIDTH	 = 12;

	protected static final int SB_HEIGHT = 12;



	protected Scrollbar rightScroll, bottomScroll;



	protected int diffx, diffy;



	protected void posScroll() {

		rightScroll.move(x + width-GAP-SB_WIDTH, y+GAP);

		rightScroll.resize(SB_WIDTH, height-GAP*2-(SB_HEIGHT+1));



		bottomScroll.move(x+GAP, y+height-GAP-SB_HEIGHT); 

		bottomScroll.resize(width-GAP*2-(SB_WIDTH+1), SB_HEIGHT);

	}



	public Layout calcRootLayout() {

		// If the bounding box is entirely within viewport, the 

		// root entity is set to a size equal to the viewport.



		Layout bb = drawRoot.getChildBoundingBox();



		Layout nlyt;



		if (bb != null) {

			double xoff = bb.x - xoffset; 

			double yoff = bb.y - yoffset;



			nlyt = new Layout (0, 0, Math.max(width-GAP*2, xoff + bb.width),  

								  Math.max(height-GAP*2, yoff + bb.height));

		}

		else {

			nlyt = new Layout(0, 0, width-GAP*2, height-GAP*2);

		}



		return nlyt;

	}



	protected void resetScroll() {

/*

		Layout lyt = drawRoot.getLayout();



		int h = height-GAP*2;

		int w = width-GAP*2;



		// Set bottom scrollbar



		if (lyt.width <= (double) w) {

			if (bottomScroll.isVisible()) {

				MsgOut.dprintln("Hide: " + lyt.width + " " + w);

				bottomScroll.hide();

			}

		} 

		else { 

			if (!bottomScroll.isVisible()) {

				bottomScroll.show();

			}

			// Set scrollbar values

			diffx = (int) lyt.width - w;

			bottomScroll.setValues(-xoffset, w, 0, (int) lyt.width); // diffx);

		}



		// Set right scrollbar



		if (lyt.height <= (double) h) {

			if (rightScroll.isVisible()) {

				rightScroll.hide();

			}

		} 

		else { 

			MsgOut.dprintln("Vert: " + lyt.height + " " + ((double) h));

			if (!rightScroll.isVisible()) {

				rightScroll.show();

			}	

			// Set scrollbar values

			diffy = (int) lyt.height - h; 

			rightScroll.setValues(-yoffset, h, 0, (int) lyt.height); // diffy);

		}

*/

	}



	protected Graphics gContext(Graphics gc) {

		int vpwidth, vpheight;



		if (rightScroll.isVisible())

			vpwidth = width-(GAP*3+SB_WIDTH);

		else

			vpwidth = width-GAP*2;



		if (bottomScroll.isVisible())

			vpheight = height-(GAP*3+SB_HEIGHT);

		else

			vpheight = height-GAP*2;



		Graphics g = gc.create(x+GAP, y+GAP, vpwidth, vpheight);



		return g;

	}



	protected void scrollRightBar(Graphics gc, Event ev) {

		switch(ev.id)

		{

		case Event.SCROLL_LINE_UP:

		case Event.SCROLL_PAGE_UP:

			if (yoffset < 0) {

				yoffset = Math.min(yoffset+diffy/5, 0);

				rescale();

				draw(gc);

			} 

			return;



		case Event.SCROLL_LINE_DOWN:

		case Event.SCROLL_PAGE_DOWN:

			if (yoffset > -diffy) {

				yoffset = Math.max(yoffset-diffy/5, -diffy);

				rescale();

				draw(gc);

			}

			return;



		case Event.SCROLL_ABSOLUTE:

			yoffset = -(((Integer) ev.arg).intValue());

			rescale();

			draw(gc);

			return;

		}

	}



	protected void scrollBottomBar(Graphics gc, Event ev) {

		switch(ev.id)

		{

		case Event.SCROLL_LINE_UP:

		case Event.SCROLL_PAGE_UP:

			if (xoffset < 0) {

				xoffset = Math.min(xoffset+diffx/5, 0);

				rescale();

				draw(gc);

			}

			return;



		case Event.SCROLL_LINE_DOWN:

		case Event.SCROLL_PAGE_DOWN:

			if (xoffset > -diffx) {

				xoffset = Math.max(xoffset-diffx/5, -diffx);

				rescale();

				draw(gc);

			}

			return;



		case Event.SCROLL_ABSOLUTE:

			xoffset = -(((Integer) ev.arg).intValue());

			rescale();

			draw(gc);

			return;

		}

	}







	// --------------

	// Public methods

	// --------------



	public ScrollableDiagram(LandscapeViewerCore ls,

				Scrollbar rightScroll, Scrollbar bottomScroll)

	{

		super(ls, true);

		this.rightScroll = rightScroll;

		this.bottomScroll = bottomScroll;



		width = 10;

		height = 10;

		x = 0;

		y = 0;

		xoffset = 0;

		yoffset = 0; 

	}



	public void move(int x, int y) {

		this.x = x;

		this.y = y; 



		posScroll();

	}



	public void resize(int width, int height) {

		this.width = width;

		this.height = height;



		posScroll();

	}



	public void reshape(int x1, int y1, int width1, int height1) {

		this.x = x1;
		this.y = y1; 
		this.width = width1;
		this.height = height1;

		posScroll();

	}



	public Graphics getContext(Graphics gc) {

		int vpwidth, vpheight;



		if (rightScroll.isVisible())

			vpwidth = width-(GAP*3+SB_WIDTH);

		else

			vpwidth = width-GAP*2;



		if (bottomScroll.isVisible())

			vpheight = height-(GAP*3+SB_HEIGHT);

		else

			vpheight = height-GAP*2;



		return gc.create(x+GAP, y+GAP, vpwidth, vpheight);

	}



	// Draw the entities, edges, and labels 



	public void draw(Graphics gc) {

		gc.setColor(Diagram.boxColour);

		gc.fillRect(x, y, width, height);



		gc.draw3DRect(x, y, width, height, true);

		gc.draw3DRect(x+1, y+1, width-2, height-2, true);

		posScroll();



		Graphics g = getContext(gc);



		doDraw(g, drawRoot, (drawRoot != rootInstance)); 


		// drawCache.printStats();



		g.dispose();

	}



	public void draw(Graphics gc, EntityInstance e) {

		Graphics g = getContext(gc);



		super.draw(g, e);



		g.dispose();

	}



	// 

	// Generates global coordinates for current scale factor

	//

	public void rescale() {

		super.rescale();

		resetScroll();

	}



	public int adjustX(int x) {

		return x - (this.x+GAP); 

	}



	public int adjustY(int y) {

		return y - (this.y+GAP); 

	}



	public void scroll(Graphics gc, Event ev) {

		if (ev.target == rightScroll)

			scrollRightBar(gc, ev);

		else

			scrollBottomBar(gc, ev);

	}



	public void navigateTo(EntityInstance e) {

		super.navigateTo(e);

		resetScroll();

	}
}
