package lsedit;

// Layout method using Coffman-Graham Layer Assignment algorithm and the
// Sugiyama algorithm.

// John S. Y. Lee January 2000

import java.util.*;

public class SugiyamaLayout extends LandscapeLayouter {

  public SugiyamaLayout() 
  {
  }

/****************************************************************************/

  public String getMenuLabel() 
  {
	return "Coffman-Graham-Sugiyama method applied";
  } // getMenuLabel

/***************************************************************************/

  // The boxIndex method returns the vector index of a box named ID.

  private int boxIndex(Vector selectedBoxes, String ID) {
	
	int index;
	for (index = 0; index < selectedBoxes.size(); index++) {
	  if (ID.equals(((EntityInstance)selectedBoxes.elementAt(index)).id))
		break;
	} // for
	return index;

  } // boxIndex

/***************************************************************************/

  // The doLayout method executes the Coffman-Graham Layer Assignment
  // algorithm and the Sugiyama algorithm on the boxes selected.
  // Assumption: All boxes selected are in the same container.

	public String doLayout() {

		boolean debug = true;

		// get user's selection of boxes to be laid out

		Vector selectedBoxes = getGroup();
		if (selectedBoxes == null) {
			  beep();
			  return "No group selected";
		}

		int vertexID = 0;
		int groupSize = selectedBoxes.size();

		EntityInstance container = getParent((EntityInstance)selectedBoxes.firstElement());
		Layout containerLayout   = getLayout(container);

		// create graph to store info on selected boxes and their relationships
		Graph graph = new Graph(groupSize, containerLayout.width, containerLayout.height, debug);

		for (Enumeration e = selectedBoxes.elements(); e.hasMoreElements(); ) {
			graph.addVertex(getLayout((EntityInstance)e.nextElement()).width);
		}

		// get (directed) relationships between the boxes

		for (Enumeration e = selectedBoxes.elements(); e.hasMoreElements(); vertexID++) {

			EntityInstance box = (EntityInstance) e.nextElement();

			for (Enumeration edge = box.srcRelList.elements(); edge.hasMoreElements(); ) {

				RelationInstance relation = (RelationInstance) edge.nextElement();
				EntityInstance child = relation.getDst();
			  
				// store relationship only if children is in the same container

				int index = boxIndex(selectedBoxes, child.id);
				if (index < groupSize) {
					graph.addEdge(vertexID, index);
				}
			} // for
		} // for

		if (debug) {
			int index = 0;
		  
			System.out.println("Graph read:");
			for (Enumeration e = selectedBoxes.elements(); e.hasMoreElements(); index++) {
				System.out.println(index + " " + e.nextElement());
			}
			graph.print();
		}

		Vector layers = graph.doCoffmanGrahamSugiyama();

		if (debug) {
			System.out.println("RESULTS");
			int level = 0;
			for (Enumeration e = layers.elements(); e.hasMoreElements(); ) {
				System.out.println("level " + level);
				for (Enumeration f = ((Vector)e.nextElement()).elements(); f.hasMoreElements(); ) {
					System.out.print(f.nextElement() + " ");
				}
				System.out.println();
			}
		} // if

		// Assign coordinates to each box

		int numLayers = layers.size();
		double layerHeight = (double)containerLayout.height / (double)numLayers;

		double curX = 20;
		double curY = containerLayout.height;

		for (Enumeration e = layers.elements(); e.hasMoreElements(); ) {

			Layout curLayout = null;
			Vector row = (Vector)e.nextElement();
			double boxWidth = (double)containerLayout.width / (double)(row.size());

			for (Enumeration f = row.elements(); f.hasMoreElements(); ) {
				int curVertex = ((Integer)f.nextElement()).intValue();

				// Process non-dummy boxes only
				if (curVertex < groupSize) {
					  EntityInstance curBox = (EntityInstance) selectedBoxes.elementAt(curVertex);
					  curLayout = getLayout(curBox);
					  curLayout.x = curX + (boxWidth    - curBox.width()) / (double)2;
					  curLayout.y = curY - (layerHeight - curBox.height())/ (double)2;
					  curX += boxWidth;
					  setLayout(curBox, curLayout);
				} // if
			} // for

			curY -= layerHeight;
			curX  = 20;

		} // for

		return "Graph redrawn with Coffman-Graham-Sugiyama method";

	} // doLayout

} // SugiyamaLayout






