package lsedit;

import java.util.*;



public class SupplierCompareFn extends ClientSupplierCompareFn {

	protected double calcAvg(EntityInstance e) {

		Enumeration en = e.dstRelationAbstractedElements();



		double x = 0.0;

		int n = 0;



		while (en.hasMoreElements()) {

			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance src = ri.getSrc();



			if (root.descendent(src)) {

				if (edgeMode == Diagram.DIRECT_EDGE) {

					EntityInstance vsrc = src.getVisibleEntity();



					Layout lyt = vsrc.getLayout();



					x += (lyt.x + lyt.width/2);

					n++;

				}

				else {

					double f = ri.getRelationClass().getIOfactor();



					Layout lyt = root.getLayout();



					x += (lyt.x + lyt.width*f);

					n++;

				}

			}

		}



		if (n > 0)

			return x/n;



		return -1;

	}

}

