package lsedit;
import java.io.*;

/**
 * A class to turn an TA input stream into a stream of tokens.
 * @version 1.0, 22/07/98
 * @author	Gary Farmaner
 */

public

class TA_StreamTokenizer extends Object {

	private InputStream is;
	private char buf[];
	private int m_peekc = ' ';
	private boolean m_pushedBack;
	private boolean forceLower;

	/** The line number of the last token read */

	private int m_lineno = 1;
	private byte ctype[] = new byte[256];
	private static final byte CT_WHITESPACE = 1;
	private static final byte CT_DELIMIT	= 2;

	/**
	 * The type of the last token returned.	 It's value will either
	 * be one of the following TT_* constants, or a single
	 * character.  For example, if '+' is encountered and is
	 * not a valid word character, ttype will be '+'
	 */

	public int ttype;

	public static final int TT_EOF = -1;				// The End-of-file token.
	public static final int TT_EOL = '\n';				// The End-of-line token.				
	public static final int TT_NUMBER = -2;				// The number token.  This value is in nval.
	public static final int TT_WORD = -3;				// The word token.	This value is in sval.

	/**
	 * The Stream value.
	 */

	public String sval;

	/**
	 * The number value.
	 */

	public double nval;

	public TA_StreamTokenizer (InputStream is) {

		this.is = is;

		buf = new char[20*1024];

		ctype[' ']	= (byte) (CT_WHITESPACE | CT_DELIMIT);
		ctype['\t'] = (byte) (CT_WHITESPACE | CT_DELIMIT);
		ctype['\r'] = (byte) (CT_WHITESPACE | CT_DELIMIT);
		ctype['\n'] = (byte) (CT_WHITESPACE | CT_DELIMIT);
		ctype['=']	= CT_DELIMIT;
		ctype[':']	= CT_DELIMIT;
		ctype['{']	= CT_DELIMIT;
		ctype['}']	= CT_DELIMIT;
		ctype['(']	= CT_DELIMIT;
		ctype[')']	= CT_DELIMIT;
	}

	protected void db() {
		System.out.println(m_lineno + ": " + sval);
	}

	protected static final int IBUF_SIZE = 8 * 1024;
	protected byte[] ibuf = new byte[IBUF_SIZE];
	protected int cnt = 0;
	protected int m_pos = 0;

	protected final int cread() throws IOException {

		if (m_pos == cnt) {
			cnt = is.read(ibuf, 0, IBUF_SIZE);

			if (cnt < 1) {
				m_pos = cnt;
				return TT_EOF;
			}
			m_pos = 0;
		}
		return (int) ibuf[m_pos++];
	}

	protected final int creadNW(int curc) throws IOException {

		int c = curc;
		int pc = 0;

		for (;;) {
			switch(c) {

			case '\r':
				m_lineno++;
				pc = '\r';
				break;

			case '\n':
				if (pc != '\r')
					m_lineno++;
				// Fall through

			case '\t':
			case ' ':
				pc = c;
				break;

			default:
				return (int) c;
			}

			if (m_pos < cnt)  {
				c = ibuf[m_pos++];
			} else {
				int nc = cread();

				if (nc == TT_EOF) {
					return TT_EOF;
				}
				c = (byte) nc;
			}
		}
	}

	protected final int creadNL() throws IOException {

		while(true) {

			int c;

			if (m_pos < cnt) {
				c = ibuf[m_pos++];
			} else {
				int nc = cread();
				if (nc == TT_EOF) {
					return TT_EOF;
				}
				c = (byte) nc;
			}

			if (c == '\n') {
				m_lineno++;
				return cread();
			} else if (c == '\r') {
				m_lineno++;
				c = cread();
				if (c == '\n') {
					c = cread();
				}
				return c;
			}
		}
	}

	



	/**
	 * Parses a token from the input stream.  The return value is
	 * the same as the value of ttype.	Typical clients of this
	 * class first set up the syntax tables and then sit in a loop
	 * calling nextToken to parse successive tokens until TT_EOF
	 * is returned.
	 */

	public final int nextToken() throws IOException {

		if (m_pushedBack) {
			m_pushedBack = false;
			return ttype;
		}


		int c	= m_peekc;
		int pc	= 0;
		int pos = 0;

		sval = null;

		if (c == TT_EOF) {
			sval = "EOF";
			return ttype = TT_EOF;
		}

		c = creadNW(c);

		if (c == TT_EOF) {
			sval = "EOF";
			return ttype = TT_EOF;
		}

		switch(c)
		{
		case '/':
			c = cread();
			if (c == '/') {
				// Toss the remainder of the line
				m_peekc = creadNL();
				return nextToken();
			}

			// Should handle C style comments too

			if ((ctype[c] & CT_DELIMIT) != 0) {
				sval = "/";
				m_peekc = c;
				// db();
				return ttype = TT_WORD;
			}	

			buf[pos++] = '/';
			break;

		case '"':
			do {
				c = cread();
				if (c != TT_EOF && c != '"') {
					if (c == '\r' || (c == '\n' && pc != '\r')) {
						m_lineno++;
					}
					buf[pos++] = (char) c;
					pc = c;
				}
			} while (c != TT_EOF && c != '"');

			m_peekc = cread();
			sval = new String(buf, 0, pos);
			// db();
			return ttype = TT_WORD;
		}

		if (ctype[c] == CT_DELIMIT) {
			sval = String.valueOf((char) c);
			m_peekc = cread();
			// db();
			return ttype = c;
		}

		// Read characters until delimitter

		buf[pos++] = (char) c;

		while(true) {
			c = cread();

			if (c == TT_EOF || (ctype[c] & CT_DELIMIT) != 0) {
				m_peekc = c;
				sval = new String(buf, 0, pos);
				// db();
				return ttype = TT_WORD;
			}

			buf[pos++] = (char) c;
		}
	}

	/** Does an unget of the last token */

	public final void pushBack() {
		m_pushedBack = true;
	} 

	/** Return the current line number. */
	public int lineno() {
		return m_lineno;
	}
}

