package lsedit;

import java.applet.*;
import java.awt.*;
import java.util.*;


abstract public class TabbedBox extends MyComponent implements Sizeable {

	protected static final Color titleColor = Color.red.darker();

	protected static final int SZ_DIM	= 16;
	protected static final int SB_WIDTH = 12;
	protected static final int GAP = 5; 

	protected Scrollbar scrollBar;
	protected int maxScrollPos;

	protected int nitem = 0;
	protected int vitem = 0;
	protected int itemNo = 0;

	protected LandscapeViewerCore ls;

	protected Dimension tabDim;
	protected boolean active = false;

	protected String title;
	protected int tabOffset;

	protected SizingButton sizingButton = null;


	protected void posControls() {

		Rectangle r = bounds(); 



		sizingButton.show();

		sizingButton.move(r.x+r.width-GAP-SZ_DIM-1, r.y+tabDim.height+GAP);

   

		if (scrollBar != null && scrollBar.isVisible()) { 

			if (sizingButton == null) {

				scrollBar.move(r.x+r.width-GAP-SB_WIDTH, r.y+tabDim.height+GAP);

			}

			else {

				scrollBar.move(r.x+r.width-GAP-SB_WIDTH-1, r.y+tabDim.height+SZ_DIM+GAP*2);

			}

		}

	}



	protected void setupScrolling(int hd) {

		if (scrollBar == null)

			return;



		Rectangle r = bounds();



		int h = r.height-tabDim.height-GAP*2; 



		if ((hd > h)) {

			if (!scrollBar.isVisible()) {

				if (sizingButton == null) {

					scrollBar.resize(SB_WIDTH, h); 

				}

				else {

					scrollBar.resize(SB_WIDTH, h - SZ_DIM - GAP); 

				}



				scrollBar.show();



				maxScrollPos = hd-h;



				posControls();

				repaint();

			}

			scrollBar.setValues(scrollBar.getValue(), h, 0, hd);

		}

		else if (scrollBar.isVisible()) {

			scrollBar.setValue(0);

			scrollBar.hide();

			repaint();

		}

	}



	protected void scroll(Diagram dg, Graphics gc, Event event) {

		Object arg = event.arg; 



		int scrollPos = scrollBar.getValue();



		switch(event.id)

		{

		case Event.SCROLL_LINE_UP:

		case Event.SCROLL_PAGE_UP:

			if (scrollPos > 0) {

				scrollPos = Math.max(0, scrollPos-10);

				repaint();

			}

			break;



		case Event.SCROLL_LINE_DOWN:

		case Event.SCROLL_PAGE_DOWN:

			if (scrollPos < maxScrollPos) {

				scrollPos = Math.min(maxScrollPos, scrollPos + 10);

				repaint();

			}

			break;



		case Event.SCROLL_ABSOLUTE:

			repaint();

			return;



		default:

			return;

		}



		scrollBar.setValue(scrollPos);

	}



	abstract protected void drawContents(Diagram dg, Graphics gc, boolean fi);





	// --------------

	// Public methods 

	// --------------



	public TabbedBox(LandscapeViewerCore ls, String title, int tabOffset) {

		this.ls = ls;

		scrollBar = new Scrollbar();

		ls.add(scrollBar);

		scrollBar.hide();



		setBackground(Diagram.boxColour);



		tabDim = Util.getTabDim(ls.getGraphics(), title);



		this.title = "&" + title;

		this.tabOffset = tabOffset;



		sizingButton = new SizingButton(this, SZ_DIM, SizingButton.BTN_UP);

		ls.add(sizingButton);

	}



	public void paint(Graphics gc) {



		Rectangle r = bounds();



		Diagram dg = ls.getDiagram();



		gc.setColor(getBackground());



		if (active) {

			boolean open = (sizingButton.getKind() == SizingButton.BTN_UP);



			gc.fillRect(0, tabDim.height, r.width, r.height-tabDim.height);

			Util.drawTabbedFrame(gc, r, title, titleColor, tabOffset);



			Graphics ngc = gc.create(0, tabDim.height+GAP, 

								r.width, r.height-tabDim.height-GAP*2);



			drawContents(dg, ngc, open);



			ngc.dispose();

		}

		else {

			Util.drawTab(gc, title, titleColor, tabOffset, false);

		}

	}



	public void draw(Graphics gc) {

		// Create another with a clipping region over us



		Rectangle r = bounds();



		Graphics ngc = gc.create(r.x, r.y, r.width, r.height);


		paint(ngc);
		ngc.dispose();
	}



	public void repaint() {

		Graphics gc = ls.getGraphics();



		draw(gc);



		gc.dispose();

	}



	abstract public boolean mouseMotion(Event ev, int x, int y);



	public boolean handleEvent(Diagram dg, Graphics gc, Event event) {

		if (isVisible() && event.target == scrollBar) {

			 scroll(dg, gc, event);

			 return true;

		}

		return false;

	}



	public void show() {

		super.show();

		posControls();

	}



	public void hide() {

		super.hide();

		inactivate();

	}



	public void activate() {

		active = true;

		posControls();


	}



	public void inactivate() {

		if (active) {

			active = false;

			sizingButton.hide();

		}

	}

	public boolean isactive() {

		return(active);
	}

	public void move(int x, int y) {

		super.move(x, y - tabDim.height);

		posControls();

	}



	public void resize(int width, int height) {

		super.move(width, height + tabDim.height);

		posControls();

	}



	public void reshape(int x, int y, int width, int height) {

		super.reshape(x, y - tabDim.height, width, height + tabDim.height);

		posControls();

	}



	public boolean isOverTab(int x, int y) {

		Rectangle r = bounds();



		return (x > r.x + tabOffset && x < r.x + tabOffset + tabDim.width &&

				y > r.y && y < r.y + tabDim.height);

	}



	public void handleSizing() {

		ls.toggleRightBoxes();

	}



	public void setButtonState(boolean isOpen) {

		sizingButton.setKind(isOpen ? SizingButton.BTN_UP : 

										SizingButton.BTN_DOWN); 

	}

}





