package lsedit;

import java.applet.*;

import java.awt.*;

import java.util.*;



public class TextBox extends MyComponent {



	protected static final int GAP = 5; 

	protected static final int SB_WIDTH = 12; 

	protected static final int SZ_DIM	= 16;



	protected static final int NO_LINK	= -1;



	protected static final Color titleColor = Color.red.darker();



	protected static final Font titleFont =

				new Font("Helvetica", Font.BOLD, 14);



	protected static final Font textFont =

				new Font("Helvetica", Font.PLAIN, 11); 



	protected LandscapeViewerCore ls;

	protected ClickHandler ch = null;



	protected String text; 

	protected String title;

	protected int	 lineNo = 0;

	protected int	 numLines;

	protected int	 maxDisplayable;



	protected int normHeight; 



	protected Scrollbar scrollBar; 

	protected boolean sizeable = false;

	protected boolean droppable = false;

	protected boolean isOpen = false;

	protected boolean suppress = false;



	protected boolean preformatted = false;



	protected boolean flagSetup = false;



	protected int activeLink = NO_LINK;

	protected boolean highlightLink = false;

 

	protected void posScroll() {

		Rectangle r = bounds();



		scrollBar.move(r.x+r.width-SB_WIDTH-GAP, r.y+GAP*2+SZ_DIM);

		scrollBar.resize(SB_WIDTH, r.height-GAP*3-SZ_DIM);

	}



	protected void doArrowPaint(Graphics gc, Rectangle r, boolean down) {



		int xp[] = new int[3];

		int yp[] = new int[3];



		if (down) {

			xp[0] = r.x+4;

			yp[0] = r.y+4;

			xp[1] = r.x+r.width-4;

			yp[1] = r.y+4; 

			xp[2] = r.x+r.width/2;

			yp[2] = r.y+r.height-4;

		}

		else {

			xp[0] = r.x+r.width/2;

			yp[0] = r.y+4;

			xp[1] = r.x+4;

			yp[1] = r.y+r.height-4;

			xp[2] = r.x+r.width-4;

			yp[2] = r.y+r.height-4;

		}



		gc.fillPolygon(xp, yp, 3);

	}





	protected void doDrawDrop(Graphics gc) {

		if (droppable) {

			Rectangle r = bounds();



			gc.setColor(Color.black);



			r.x = r.width-SZ_DIM-GAP*2;

			r.y = GAP;

			r.width = SZ_DIM;

			r.height = SZ_DIM;



			gc.drawRoundRect(r.x, r.y, SZ_DIM, SZ_DIM, SZ_DIM/4, SZ_DIM/4);



			doArrowPaint(gc, r, !isOpen());

		}

	}



	// Protected methods 



	protected void drawText(Graphics g, Rectangle r) {



		// Draw title 



		g.setFont(titleFont);

		g.setColor(titleColor);



		int h = Util.fontHeight(titleFont);

						// Util.fontHeight(g.getFontMetrics());



		int xpos = GAP;

		int ypos = GAP;



		Util.drawStringClipped(g, title, xpos, ypos, r.width-GAP*2, h);

		ypos += h + 7;



		// Now lines of text



		g.setColor(Color.black);

		g.setFont(textFont);



		FontMetrics fm = g.getFontMetrics();



		h = Util.fontHeight(textFont) - 2;



		// Output as many lines as we can of the description within the

		// text box provided by parsing the description for words.



		int width = r.width-GAP*2;



		if (scrollBar != null && scrollBar.isVisible())

			width -= (SB_WIDTH+GAP);

		

		StringLinizer sl = new StringLinizer(text, fm, width);



		int ln = 0;



		int mypos = r.height-h-GAP;



		while (sl.hasMoreLines() && ypos < mypos) {

			String line = sl.nextLine();

			 

			if (ln >= lineNo) {

				Util.drawStringClipped(g, line, xpos, ypos, r.width-GAP*2, h);

				ypos += (h+2);

			}



			ln++;

		} 

	}



	protected int countMaxDisplayable(Graphics g, boolean scrollOn) {



		// Draw title 



		g.setFont(titleFont);

		g.setColor(titleColor);



		int h = Util.fontHeight(titleFont);

						// Util.fontHeight(g.getFontMetrics());



		int ypos = GAP + h;



		// Now lines of text



		g.setColor(Color.black);

		g.setFont(textFont);



		FontMetrics fm = g.getFontMetrics();



		h = Util.fontHeight(textFont) - 2;

		ypos += h + 7;



		Rectangle r = bounds();



		int width = r.width-GAP*2;



		if (scrollOn)

			width -= (SB_WIDTH+GAP);

		

		StringLinizer sl = new StringLinizer(text, fm, width);



		int ln = 0;



		int mypos = r.height-h-GAP;



		while (sl.hasMoreLines() && ypos < mypos) {

			String line = sl.nextLine();

			

			ypos += (h+2);

			ln++;

		} 



		return ln;

	}



	protected int countLines(Graphics g, boolean scrollOn) {

		Rectangle r = bounds();



		g.setFont(textFont);



		FontMetrics fm = g.getFontMetrics();



		int width = r.width-GAP*2;



		if (scrollOn) {

			width -= (SB_WIDTH+GAP);
		}
		

		StringLinizer sl = new StringLinizer(text, fm, width);



		int ln = 0;



		while (sl.hasMoreLines()) {

			String line = sl.nextLine();

			

			ln++;

		} 



		return ln;

	}



	protected void scroll(Diagram dg, Graphics gc, Event event) {

		Object arg = event.arg; 



		switch(event.id)

		{

		case Event.SCROLL_LINE_UP:

		case Event.SCROLL_PAGE_UP:

			if (lineNo > 0) {

				lineNo--;

				repaint();

			}

			return;



		case Event.SCROLL_LINE_DOWN:

		case Event.SCROLL_PAGE_DOWN:

			if (lineNo+1 < numLines) {

				lineNo++;

				repaint();

			}

			return;



		case Event.SCROLL_ABSOLUTE:

			lineNo = ((Integer) arg).intValue();

			repaint();

			return;

		}

	}



	protected void setupScrolling(Graphics gc) {

		if (scrollBar == null)

			return; 



		lineNo = 0;

		numLines = countLines(gc, false);

		maxDisplayable = countMaxDisplayable(gc, false);



		if (numLines > maxDisplayable) {

			if (flagSetup)

				droppable = sizeable;	// Semi-permanent

			numLines = countLines(gc, true);

			maxDisplayable = countMaxDisplayable(gc, true);

			posScroll();

			scrollBar.setValues(0, maxDisplayable, 0, numLines);

			scrollBar.show();

		} else {

			if (flagSetup) {
				droppable = false;
			}
			scrollBar.hide();
		}
	}



	protected int overLink(int x, int y) {

		int r = y % 20;



		return (r > 5 && r < 9) ? 0 : NO_LINK;

	}



	protected void newText() {

		if (isOpen) {
			toggleSizing();
		} else {
			repaint();
		}
	}



	// --------------

	// Public methods 

	// --------------



	public TextBox(LandscapeViewerCore ls, boolean sizeable) {

		this.ls = ls;

		this.sizeable = sizeable;

		scrollBar = new Scrollbar(); 

		scrollBar.hide();

		setBackground(Diagram.boxColour);



		resize(5, 5);



		ls.add(scrollBar);

	}



	public TextBox() {

		setBackground(Diagram.boxColour);

	}



	public void paint(Graphics gc) {

		if (flagSetup) {

			if (title != null) {
				setupScrolling(gc);
			}

			flagSetup = false;

			repaint();

			return;

		}


		

		Rectangle r = bounds();



		gc.setColor(getBackground());

		gc.fillRect(0, 0, r.width, r.height);



		Util.drawFrame(gc, r);



		if (title != null) {

			drawText(gc, r);

		}

		doDrawDrop(gc);
	}



	public void draw(Graphics gc) {

		// Create another with a clipping region over us

		Rectangle r = bounds();

		Graphics ngc = gc.create(r.x, r.y, r.width, r.height);

		paint(ngc);

		ngc.dispose();
	}



	public void repaint() {

		if (isVisible()) {

			Graphics gc = ls.getGraphics();



			draw(gc);



			gc.dispose();

		}

	}



	public void set(String title, String text, ClickHandler ch, boolean pf) {

		this.ch = ch;
		this.title = title;
		this.text = text; 
		flagSetup = true;
		suppress = false;
		preformatted = pf;

		newText();
	}



	public void set(String title, String text, ClickHandler ch) {

		set(title, text, ch, false);

	}



	public void set(String title, String text) {

		set(title, text, null);

	}



	public boolean handleEvent(Diagram dg, Graphics gc, Event event) {

		if (event.target == scrollBar) {

			 scroll(dg, gc, event);

			 return true;

		}

		return false;

	}



	public boolean isOpen() {

		return isOpen;

	}



	public void toggleSizing() {

		isOpen = !isOpen;



		ScrollableDiagram dg = ls.getDiagram();



		Rectangle dr = dg.bounds();

		Rectangle r = bounds();



		if (isOpen)

			normHeight = r.height;



		int height = isOpen ? dr.height : normHeight;



		resize(r.width, height);

		setupScrolling(ls.getGraphics());



		if (isOpen)

			repaint();

		else

			ls.repaint();

	}



	public void hide() {

		super.hide();

		scrollBar.hide();

	}



	public void show() {

		super.show();

		flagSetup = true;

		repaint();

	}



	public void move(int x, int y) {

		super.move(x, y);

	}



	public void resize(int w, int h) {

		super.resize(w, h);

	}



	public boolean mouseMotion(Event ev, int x, int y) {

		if (isMouseOver(x, y)) {

			if (ch != null && overLink(x, y) != NO_LINK) {

				ls.setCursor(Frame.HAND_CURSOR);

			}

			else {

				ls.setCursor(Frame.DEFAULT_CURSOR);

			}

			return true;

		}

		return false;

	}



	public boolean mouseDown(Event ev, int x, int y) {

//		System.out.println("TextBox mousedown\n");

		if (isMouseOver(x, y)) {

			int l = overLink(x, y);



			if (ch != null && l != NO_LINK) {

				activeLink = l;

				highlightLink = true;

				repaint();

			}

		}

		return false;

	}



	public boolean mouseDrag(Event ev, int x, int y) {

		if (activeLink != NO_LINK) {

			int l = overLink(x, y);



			if (l == activeLink && !highlightLink) {

				highlightLink = true;

				repaint();

			}

			else if (l != activeLink && highlightLink) {

				highlightLink = false;

				repaint();

			}

			return true;

		}

		return false;

	}



	public boolean mouseUp(Event ev, int x, int y) {

		if (activeLink != NO_LINK) {

			if (overLink(x, y) == activeLink) {

				ch.processClickedText(this, "test");

			}

			activeLink = NO_LINK;

			return true;

		}



		return false;

	}



	public void keyProcess(int key) {

		switch(key)

		{

		case CTRL.PAGE_DOWN:

			suppress = true;

			if (!isOpen() && droppable)

				toggleSizing();

			break;



		case CTRL.PAGE_UP:

			suppress = false;

			if (isOpen())

				toggleSizing();

			break;

		}

	}

}





