package lsedit;

import java.awt.*;

import java.util.*;



abstract public class ToolBarButton extends Canvas

{

	abstract protected void paintIcon(Graphics gc);

	abstract protected String getDesc();



	protected final static double ARROW_L = 5.0;

	protected final static double ARROW_TH = 0.40; 



	protected static final Font font = new Font("Helvetica", Font.PLAIN, 12);

	protected static final Font font1 = new Font("Helvetica", Font.PLAIN, 8);



	protected static final int MARGIN = 2;

	protected static final int HEIGHT = 24;

	protected static final int WIDTH  = 40;



	protected boolean momentary = false;

	protected boolean depressed = false;

	protected boolean mouseIn	= false;

	protected boolean mouseDown = false;

	protected boolean buttonLook = false;



	protected int key = 0;



	protected ToolBarEventHandler teh;



	protected static HelpBox popup = null;



	protected void drawEdge(Graphics gc, int x1, int y1, int x2, int y2) {

		gc.drawLine(x1, y1, x2, y2);



		double dx = x1 - x2;

		double dy = y1 - y2;



		double theta = Math.atan2(dy, dx);



		double len = Math.min(ARROW_L, Math.sqrt(dx*dx + dy*dy));



		double ax = x2 + len*Math.cos(theta-ARROW_TH);

		double ay = y2 + len*Math.sin(theta-ARROW_TH);

		double bx = x2 + len*Math.cos(theta+ARROW_TH);

		double by = y2 + len*Math.sin(theta+ARROW_TH);



		int[] x = new int[3];

		int[] y = new int[3];



		x[0] = (int) Math.round(x2);

		y[0] = (int) Math.round(y2);

		x[1] = (int) Math.round(ax);

		y[1] = (int) Math.round(ay);

		x[2] = (int) Math.round(bx);

		y[2] = (int) Math.round(by);



		gc.fillPolygon(x, y, 3);

	}

 



	public ToolBarButton(ToolBarEventHandler teh) {

		this.teh = teh;



		resize(WIDTH, HEIGHT);

	}



	public void paint(Graphics gc) {

		// Paint button base and character



		Dimension dim = size();



		gc.setColor(getBackground());

		gc.fillRect(0, 0, dim.width, dim.height);



		gc.setColor(getBackground());



		if (depressed) {

			gc.draw3DRect(0, 0, dim.width-1, dim.height-1, true);

		}

		else if (mouseIn || buttonLook) {

			gc.draw3DRect(0, 0, dim.width-1, dim.height-1, !mouseDown);

		}



		gc.setColor(Color.black);



		String str = null;

		int dw = 0;



		if (key >= 32 && key < 256) {

			str = "" + ((char) key);

			dw = 0;

		}

		else if (key > 0 && key < 27) {

			str = "^" + ((char) (key+64));

			dw = 2;

		}



		if (str != null) {

			gc.setFont(font);

			FontMetrics fm = gc.getFontMetrics();



			int w = fm.stringWidth(str);

			int h = Util.fontHeight(font);



			gc.drawString(str, dim.width - w + dw - MARGIN*2, 

						  dim.height - (dim.height - h) / 2 - MARGIN);

		}

		

		paintIcon(gc);

	}



	public void setState(boolean state) {

		depressed = state; 

		repaint();

	}



	public boolean mouseDown(Event ev, int x, int y) {

		mouseDown = true;		

		repaint();

		return true;

	}



	public boolean mouseDrag(Event ev, int x, int y) {

		return true;

	}



	public boolean mouseUp(Event ev, int x, int y) {

		if (mouseDown) {

			teh.processKeyEvent(key, 0);
		}


		mouseDown = false;

		repaint();



		return true;

	}



	public boolean mouseEnter(Event ev, int x, int y) {

		teh.showInfo(getDesc());



		Point pt = location();



		teh.setHelpPopup(getDesc(), pt.x + x, pt.y + y);

		mouseIn = true;

		repaint();

		return true;

	}





	public boolean mouseExit(Event ev, int x, int y) {

		teh.clearHelpPopup();

		mouseIn = false;

		repaint();

		return true;

	}



	public boolean mouseMove(Event ev, int x, int y) {

		return true;	// Prevent event going to parent

	}

}





