package lsedit;

// Needs to be parent class of EditModeHandler

import java.awt.*;
import java.util.*;

public class ViewModeHandler extends LandscapeModeHandler 
{

	protected final static int MENU_BASE				= 2000;

	protected final static int EDGE_OPEN_LOW			= MENU_BASE + 0;
	protected final static int EDGE_OPEN_DST			= MENU_BASE + 1;
	protected final static int EDGE_OPEN_SRC			= MENU_BASE + 2;
	protected final static int EDGE_CLOSE_LOW			= MENU_BASE + 3;
	protected final static int EDGE_CLOSE_DST			= MENU_BASE + 4;
	protected final static int EDGE_CLOSE_SRC			= MENU_BASE + 5;
	protected final static int EDGE_NAVIGATE_SRC		= MENU_BASE + 6;
	protected final static int EDGE_NAVIGATE_DST		= MENU_BASE + 7;

	protected final static double SMALL_SCALE_UP		= 1.1; 
	protected final static double SMALL_SCALE_DOWN		= 0.9; 
	protected final static String SMALL_SCALE_STRING	= "10%";

	// Supported modes

	protected MoveModeHandler	  moveHandler;
	protected ResizeModeHandler	  resizeHandler;
	protected NavigateModeHandler navHandler;
	protected GroupModeHandler	  groupingHandler;

	protected LandscapeModeHandler handler = null;

	protected LsViewMenu popup = null;

	protected EdgePoint ept;

	protected Vector edges = null;

	protected String genLink(EntityInstance e) {
		 return "<a href='test' target='trg'>" + 
				Util.quoted(e.getLabel()) +
				"</a>";
	}

	protected int[] resizeCursor =
		{ 
			Frame.NW_RESIZE_CURSOR, Frame.N_RESIZE_CURSOR, 
			Frame.NE_RESIZE_CURSOR, Frame.E_RESIZE_CURSOR, 
			Frame.SE_RESIZE_CURSOR, Frame.S_RESIZE_CURSOR,
			Frame.SW_RESIZE_CURSOR, Frame.W_RESIZE_CURSOR, 
		};

	protected static final String[] entityMenu =
		{ "Forward query (f)", // "Forward query w/closure (F)", 
		  "Backtrace query (b)", // "Backtrace query w/closure (B)", 
		  "Contents query (C)",
		  "-",
		  "Hide/show user edge (u)", 
		  "Hide/show user inside edges (U)",
		  "Hide/show supplier edge (s)", 
		  "Hide/show supplier inside edges (S)",
		  "Hide/show internal edges (I)",
		  "Hide/show contents (c)", 
		  "-",
		  "Select all entities (^A)",
		  "-",
		  "Scale smaller in X dim (x)",
		  "Scale larger in X dim (X)",
		  "Scale smaller in Y dim (y)",
		  "Scale larger in Y dim (Y)",
		  "Scale smaller (z)",
		  "Scale larger (Z)"
		};

	protected static final int[] entityKeys =
		{ 'f', 'b', 'C', 0,
		  'u', 'U', 's', 'S', 
		  'I', 'c', 0,
		  CTRL.A, 0, 
		  'x', 'X', 'y', 'Y', 'z', 'Z'
		};

	protected static final String[] edgeMenu = 
		{ "Open to lowest level (l)",
		  "Open edge destination (f)", 
		  "Open edge source (s)",
		  "Close to top level (t)",
		  "Close edge destination (F)",
		  "Close edge source (B)",
		  "Navigate to destination",
		  "Navigate to source"
		};

	protected static final int[] edgeKeys = 
		{ EDGE_OPEN_LOW,
		  EDGE_OPEN_DST, 
		  EDGE_OPEN_SRC,
		  EDGE_CLOSE_LOW,
		  EDGE_CLOSE_DST,
		  EDGE_CLOSE_SRC,
		  EDGE_NAVIGATE_DST,
		  EDGE_NAVIGATE_SRC
		};

	protected int curX, curY;


	// -----------------
	// Protected methods
	// -----------------

	public void reset() {
		edges = null;
	}

	protected boolean addPair(Vector pairs, 
								EntityInstance src, EntityInstance dst)
	{
		Enumeration en = pairs.elements();

		while (en.hasMoreElements()) {
			EntityInstancePair eip = (EntityInstancePair) en.nextElement();

			if (eip.equals(src, dst))
				return false;
		}

		pairs.addElement(new EntityInstancePair(src, dst));

		return true;
	}

	public void processSelectList(boolean activateBox) {
		dg.clearCache();		// Insures getVisibleEntity is accurate

		Enumeration en = edges.elements();

		StringBuffer sb = new StringBuffer();

		Vector pairs = new Vector();

		EntityInstance root = dg.getRoot();

		while (en.hasMoreElements()) {
			RelationInstance edge = (RelationInstance) en.nextElement();

			EntityInstance src = edge.getSrc().getVisibleEntity();
			EntityInstance dst = edge.getDst().getVisibleEntity();

			if (addPair(pairs, src, dst)) {
				sb.append(genLink(src) + "	" +
						  edge.getRelationClass().getLabel() + "  " +
						  genLink(dst) + "\n");
			}
		}

		ResultBox tb = ls.getListBox();

		tb.set("SELECTED RELATIONS:", new String(sb), null, activateBox);

		dg.selectEdges(edges);
	}

	public void selectEdge(int x, int y) {
		dg.clearFlags();
		edges = dg.mouseOverAllEdges(x, y);
		processSelectList(false);
		ls.repaintDg();
	}

	protected void selectEntity(EntityInstance e) {
		if (e.getGroupFlag()) {
			// Already a member of a group

			if (e != dg.getKeyEntity()) {
				dg.setKeyEntity(e);
			}
		}
		else {
			EntityInstance old_ke = dg.getKeyEntity();

			if (old_ke != null) {
				dg.clearGroupFlags();
			}
			dg.setKeyEntity(e);
		}
	}

	protected void doHandleElision(int key) {
		Vector grp = dg.getGroup();

		Enumeration en = grp.elements();

		while (en.hasMoreElements()) {
			EntityInstance ge = (EntityInstance) en.nextElement();

			switch(key)
			{
			case 'c':
				// Toggle contain elision
				dg.toggleContainElision(ge);
				break;

			case 'u':
				dg.toggleInElision(ge);
				break;

			case 's':
				dg.toggleOutElision(ge);
				break;

			case 'U':
				if (ge.isOpen()) {
					dg.toggleClientElision(ge);
				}
				break;

			case 'S':
				if (ge.isOpen()) {
					dg.toggleSupplierElision(ge);
				}
				break;
			
			case 'I':
				if (ge.isOpen()) {
					dg.toggleInternalElision(ge);
				}
				break;
			}
		}
	}

	protected void handleElision(int key) {
		Vector grp = dg.getGroup();

		if (grp == null) {
			e = dg.mouseOverEx(ls.getMousePos());
			if (e == null)
				return;

			selectEntity(e);
		}

		String em = "";

		switch(key)
		{
		case 'c':
			 // Toggle contain elision
			 em = "Containment";
			 doHandleElision(key);
			 break;

		case 'u':
			em = "Destination edges";
			doHandleElision(key);
			break;

		case 's':
			em = "Source edges"; 
			doHandleElision(key);
			break;

		case 'U':
			em = "Use inside edges";
			doHandleElision(key);
			break; 

		case 'S':
			em = "Use outside edges";
			doHandleElision(key);
			break;

		case 'I':
			em = "Internal edges";
			doHandleElision(key);
			break;
		}

		ls.doFeedback(em + " elision toggled for group");
	}

	protected boolean edgeOpenSrc(Vector edges) {
		Enumeration en = edges.elements();

		boolean didOpen = false;

		while (en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance src = ri.getSrc();
			EntityInstance vsrc = src.getVisibleEntity();
		
			if (src != vsrc) {
				vsrc.setTempOpenFlag(EntityInstance.OPEN);
				didOpen = true;
			}
		}

		return didOpen;
	}

	protected boolean edgeOpenDst(Vector edges) {
		Enumeration en = edges.elements();

		boolean didOpen = false;

		while (en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance dst = ri.getDst();
			EntityInstance vdst = dst.getVisibleEntity();

			if (dst != vdst) {
				vdst.setTempOpenFlag(EntityInstance.OPEN);
				didOpen = true;
			}
		}

		return didOpen;
	}

	protected boolean edgeCloseSrc(Vector edges) {
		EntityInstance root = dg.getRoot();

		Enumeration en = edges.elements();

		boolean didClose = false;

		while (en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance src = ri.getSrc().getVisibleEntity().getParent();
			EntityInstance cc = ri.getDst().common(src);

			if (src != cc) {
				src.setTempOpenFlag(EntityInstance.CLOSED);
				didClose = true;
			}
		}

		return didClose;
	}

	protected boolean edgeCloseDst(Vector edges) {
		EntityInstance root = dg.getRoot();

		Enumeration en = edges.elements();

		boolean didClose = false;

		while (en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance dst = ri.getDst().getVisibleEntity().getParent();
			EntityInstance cc  = ri.getSrc().common(dst);

			if (dst != cc) {
				dst.setTempOpenFlag(EntityInstance.CLOSED);
				didClose = true;
			}
		}

		return didClose;
	}

	protected void edgeNavigateSrc(Vector edges) {
	}

	protected void edgeNavigateDst(Vector edges) {
	}

	protected void handleEdgeExpansion(int key) {

		dg.clearCache();

		if (edges == null) {
			ls.error("An edge hasn't been selected");
			return;
		}

		int n = 0;

		String msg = "";

		boolean expand;

		switch(key)
		{
		case EDGE_OPEN_LOW:
		case EDGE_OPEN_SRC:
		case EDGE_OPEN_DST:
			expand = true;
			break;
		
		default:
			expand = false;
			break;
		}

		boolean did = false;

		switch(key)
		{
		case EDGE_OPEN_LOW:
			{
			boolean didOpen;

			do {
				dg.clearCache();

				didOpen = edgeOpenSrc(edges);

				did |= didOpen;

			} while (didOpen);

			do {
				dg.clearCache();

				didOpen = edgeOpenDst(edges);

				did |= didOpen;

			} while (didOpen);

			msg = "Opened to lowest level.";
			}
			break;

		case EDGE_CLOSE_LOW:
			{
			boolean didClose;

			do {
				dg.clearCache();

				didClose = edgeCloseSrc(edges);

				did |= didClose;

			} while (didClose);

			do {
				dg.clearCache();

				didClose = edgeCloseDst(edges);

				did |= didClose;
			} while (didClose);

			msg = "Closed to top level.";
			}
			break;

		case EDGE_OPEN_SRC:
			did = edgeOpenSrc(edges);
			msg = "Opened source edge.";
			break;

		case EDGE_OPEN_DST:
			did = edgeOpenDst(edges);
			msg = "Opened destination edge.";
			break;

		case EDGE_CLOSE_SRC:
			did = edgeCloseSrc(edges);
			msg = "Closed source edge.";
			break;

		case EDGE_CLOSE_DST:
			did = edgeCloseDst(edges);
			msg = "Closed destination edge.";
			break;

		case EDGE_NAVIGATE_SRC:
			edgeNavigateSrc(edges);
			return;

		case EDGE_NAVIGATE_DST:
			edgeNavigateDst(edges);
			return;
		}

		if (did) {
			processSelectList(true);
			ls.doFeedback(msg);
		}
		else {
			if (expand)
				ls.error("No further expansion is possible");
			else
				ls.error("No further contraction is possible");
		}
	}


	// -------
	// Queries
	// -------

	protected boolean goodQueryEdge(EntityInstance src, EntityInstance dst,
									EntityInstance root)
	{
		if (src.descendent(dst) || dst.descendent(src))
			return false;

		if (dg.isClientOrSupplier(src)) 
			return root.descendent(dst);

		return true;
	}

	protected int addToForwardEntityList(EntityInstance te, EntityInstance e,
								 RelationClass rc, Vector list)
	{
		Enumeration en = e.srcRelationElements();

		EntityInstance root = dg.getRoot();

		int num = 0;

		while(en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			if (ri.getRelationClass() == rc) {
				EntityInstance dst = ri.getDst();
				EntityInstance vdst = dst.getVisibleEntity();

				if (vdst != null && goodQueryEdge(te, dst, root)) {

					String label = genLink(vdst);
					int ind = list.indexOf(label);

					ri.setHighlightFlag();
					dst.setHighlightFlag();

					if (ind < 0) {
						vdst.setHighlightFlag();
						if (ls.getGroupQueryFlag())
							vdst.setGroupFlag();
						list.addElement(label);
						num++;
					}	
				}
			}
		}

		en = e.getChildren();

		while (en.hasMoreElements()) {
			EntityInstance ne = (EntityInstance) en.nextElement();

			num += addToForwardEntityList(te, ne, rc, list);
		}

		return num;
	}

	protected int addForwardRelation(EntityInstance e,
								 RelationClass rc, StringBuffer sb,
								 boolean alwaysShowReln)
	{
		Vector list = new Vector();

		int num = addToForwardEntityList(e, e, rc, list);

		if (num > 0 || alwaysShowReln)
			sb.append(genLink(e) + "  " + rc.getLabel() + " ?\n");

		if (num > 0) {
			Enumeration en = list.elements();

			while (en.hasMoreElements()) {
				String s = (String) en.nextElement();

				sb.append("\t" + s + "\n");
			}
		}

		return num;
	}


	protected int showForwardEdges(EntityInstance e, StringBuffer sb) {
		if (dg.isSupplier(e))
			return 0;

		int num = 0;

		Enumeration en = dg.enumRelations();

		while (en.hasMoreElements()) {
			RelationClass rc = (RelationClass) en.nextElement();

			if (rc.isActive()) {
				int n = addForwardRelation(e, rc, sb, false);

				num += n;

				if (n > 0)
					sb.append("\n");
			}
		}

		return num;
	}


	protected void getSrcRelationWithClosure(EntityInstance e, Vector list)
	{
		Enumeration en = e.srcRelationElements();

		EntityInstance root = dg.getRoot();

		while(en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance dst = ri.getDst();

			// Using highlight flag to mark visitation

			boolean visited = dst.getHighlightFlag();

			ri.setHighlightFlag();

			if (list.indexOf(ri) < 0) 
				list.addElement(ri);

			if (!visited) {
				dst.setHighlightFlag();
				if (ls.getGroupQueryFlag())
					dst.setGroupFlag();
		
				getSrcRelationWithClosure(dst, list);
			}
		}
	}

	protected int addRelations(EntityInstance e, RelationClass rc,
						Vector list, StringBuffer sb, boolean src)
	{
		int num = 0;

		if (list.size() > 0) {
			StringBuffer nsb = new StringBuffer();

			Enumeration en = list.elements();

			while (en.hasMoreElements()) {
				RelationInstance ri = (RelationInstance) en.nextElement();

				if (ri.getRelationClass() == rc) {
					ri.setHighlightFlag();

					nsb.append("\t" + ri.getSrc().getLabel() + " " +
							  ri.getDst().getLabel() + "\n");

					num++;
				}
			}

			if (num > 0) {
				if (src) {
					sb.append(e.getLabel() + " " + rc.getLabel() + 
								" *\n");
				}
				else {
					sb.append("\t* " + rc.getLabel() + " " + e.getLabel() +
								"\n");
				}
				sb.append(nsb);
			}
		}

		return num;
	}


	protected int
	showSrcEdgesWithClosure(EntityInstance e, StringBuffer sb) {

		Enumeration enum1 = e.srcRelationElements();

		Vector list = new Vector();

		int num = 0;

		dg.clearQueryFlags();
		getSrcRelationWithClosure(e, list);
		dg.clearQueryFlags();

		Enumeration en = dg.enumRelations();

		while (en.hasMoreElements()) {
			RelationClass rc = (RelationClass) en.nextElement();

			if (rc.isActive()) {
				int n = addRelations(e, rc, list, sb, true);

				num += n;

				if (n > 0)
					sb.append("\n");
			}
		}

		return num;
	}


	// Backtrace

	public int addToBackEntityList(EntityInstance te, EntityInstance e,
								RelationClass rc, Vector list)
	{
		Enumeration en = e.dstRelationElements();

		int num = 0;

		EntityInstance root = dg.getRoot();

		while(en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			if (ri.getRelationClass() == rc) {
				EntityInstance src = ri.getSrc();
				EntityInstance vsrc = src.getVisibleEntity();

				if (vsrc != null && goodQueryEdge(src, te, root)) {
					String label = genLink(vsrc);
					int ind = list.indexOf(label);

					ri.setHighlightFlag();
					src.setHighlightFlag();

					if (ind < 0) {
						vsrc.setHighlightFlag();
						if (ls.getGroupQueryFlag())
							vsrc.setGroupFlag();
		
						list.addElement(label);
						num++;
					}
				}
			}
		}

		en = e.getChildren();

		while (en.hasMoreElements()) {
			EntityInstance ne = (EntityInstance) en.nextElement();

			num += addToBackEntityList(te, ne, rc, list);
		}

		return num;
	}


	public int addDstRelation(EntityInstance e,
								RelationClass rc, StringBuffer sb,
								boolean alwaysShowReln)
	{
		Vector list = new Vector();

		int num = addToBackEntityList(e, e, rc, list);

		if (num > 0 || alwaysShowReln)
			sb.append("? " + rc.getLabel() + "	" + genLink(e) + "\n");

		if (num > 0) {
			Enumeration en = list.elements();

			while (en.hasMoreElements()) {
				String s = (String) en.nextElement();

				sb.append("\t" + s + "\n");
			}
		}

		return num;
	}

	public int showDstEdges(EntityInstance e, StringBuffer sb) {

		int num = 0;

		if (!dg.isClient(e)) {

			Enumeration en = dg.enumRelations();

			while (en.hasMoreElements()) {
				RelationClass rc = (RelationClass) en.nextElement();

				if (rc.isActive()) {
					int n = addDstRelation(e, rc, sb, false);

					num += n;

					if (n > 0) {
						sb.append("\n");
		}	}	}	}

		return num;
	}


	protected void getDstRelationWithClosure(EntityInstance e, Vector list)
	{
		Enumeration en = e.dstRelationElements();

		EntityInstance root = dg.getRoot();

		while(en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance src = ri.getSrc();

			boolean visited = src.getHighlightFlag();

			ri.setHighlightFlag();

			if (list.indexOf(ri) < 0) 
				list.addElement(ri);

			if (!visited) {
				src.setHighlightFlag();
				if (ls.getGroupQueryFlag())
					src.setGroupFlag();
	 
				getDstRelationWithClosure(src, list);
			}
		}
	}

	protected int
	showDstEdgesWithClosure(EntityInstance e, StringBuffer sb) {
		Enumeration enum1 = e.srcRelationElements();

		Vector list = new Vector();

		int num = 0;

		dg.clearQueryFlags();
		getDstRelationWithClosure(e, list);
		dg.clearQueryFlags();

		Enumeration en = dg.enumRelations();

		while (en.hasMoreElements()) {
			RelationClass rc = (RelationClass) en.nextElement();

			if (rc.isActive()) {
				int n = addRelations(e, rc, list, sb, false);

				num += n;

				if (n > 0)
					sb.append("\n");
			}
		}

		return num;
	}

	protected int
	showContents(EntityInstance e, StringBuffer sb) {
		Enumeration en = e.getChildren();
		Vector v = new Vector();

		int n = 0;

		while(en.hasMoreElements()) {
			EntityInstance ce = (EntityInstance) en.nextElement();

			v.addElement(Util.quoted(ce.getLabel()) + 
								" (" + ce.getEntityClass().getLabel() + ")");
			n++;
		}

		sb.append(e.getLabel() + "\n contains (" + n + " items):\n\n");

		if (n > 0) {
			Util.sortVector(v);

			en = v.elements();

			while(en.hasMoreElements()) {
				String str = (String) en.nextElement();

				sb.append(str + "\n");
			}
		}

		return n;
	}

	protected int
	doQueryEntity(EntityInstance ge, int query, StringBuffer sb) {
		switch(query)
		{
		case 'f':
		case 'q':
			return showForwardEdges(ge, sb);

		case 'F':
			return showSrcEdgesWithClosure(ge, sb);

		case 'b':
			return showDstEdges(ge, sb);

		case 'B':
			return showDstEdgesWithClosure(ge, sb);

		case 'C':
			return showContents(ge, sb);

		default:
			return 0;
		}
	}

	protected void queryEntity(int query) {
		ResultBox tb = ls.getListBox();

		Vector grp = dg.getGroup();

		StringBuffer sb = new StringBuffer();

		if (!dg.getQueryPersistance())
			dg.clearQueryFlags();

		if (grp == null) {
			if (query == 'C') {
				doQueryEntity(dg.getRoot(), query, sb);
				tb.set("CONTENTS", new String(sb));
				return;
			}
			else {
				e = dg.mouseOverEx(ls.getMousePos());
				if (e != null) {
					selectEntity(e);
					grp = dg.getGroup();
				}
				else {
					ls.error("No entity or group is selected");
					return;
				}
			}
		}

		int num = 0;

		Enumeration en = grp.elements();

		while (en.hasMoreElements()) {
			EntityInstance ge = (EntityInstance) en.nextElement();

			int n = doQueryEntity(ge, query, sb);

			if (n > 0)
				sb.append("\n");		

			num += n;
		}

		String title = "";

		if (num == 0) 
			sb.append("NO ENTITIES");

		switch(query) 
		{
		case 'f':
		case 'q':
			title = "FORWARD QUERY";
			break;

		case 'F':
			title = "FORWARD QUERY (closure)";
			break;

		case 'b':
			title = "BACKTRACE QUERY";
			break;

		case 'B':
			title = "BACKTRACE QUERY (closure)";
			break;

		case 'C':
			title = "CONTENTS";
			tb.set(title, new String(sb));
			return;
		}

		tb.set(title, new String(sb));
		dg.setForHighlightEdges();
	}

	protected void doScaleEntity(EntityInstance ge, 
								int scale, boolean incFlag) {
		switch(scale)
		{
		case 'x':
			ge.scaleX(SMALL_SCALE_DOWN, incFlag);
			break; 

		case 'X':
			ge.scaleX(SMALL_SCALE_UP, incFlag);
			break; 

		case 'y':
			ge.scaleY(SMALL_SCALE_DOWN, incFlag);
			break; 

		case 'Y':
			ge.scaleY(SMALL_SCALE_UP, incFlag);
			break; 

		case 'z':
			ge.scale(SMALL_SCALE_DOWN, incFlag);
			break;

		case 'Z':
			ge.scale(SMALL_SCALE_UP, incFlag);
			break;
		}
	}

	protected void scaleEntity(int scale, boolean incFlag) {
		Vector grp = dg.getGroup();

		if (grp != null) {
			Enumeration en = grp.elements();

			while (en.hasMoreElements()) {
				EntityInstance ge = (EntityInstance) en.nextElement();

				doScaleEntity(ge, scale, incFlag);
			}
		}
		else {
			// Do it to root

			switch (scale)
			{
			case 'Z':
				// Zoom in
				if (dg.zoomIn(SMALL_SCALE_UP)) {
					ls.doFeedback( "Zoomed in (" + SMALL_SCALE_STRING + ")");
				}
				return;

			case 'z':
				// Zoom out
				if (dg.zoomOut(SMALL_SCALE_DOWN)) {
					ls.doFeedback( "Zoomed out (" + SMALL_SCALE_STRING + ")");
				}
				return;

			case 'X':
				if (dg.scaleX(SMALL_SCALE_UP)) {
					ls.doFeedback("Scaled X direction (" + 
								SMALL_SCALE_STRING + ")");
				}
				return;

			case 'x':
				if (dg.scaleX(SMALL_SCALE_DOWN)) {
					ls.doFeedback("Scaled X direction (-" + 
								SMALL_SCALE_STRING + ")");
				}
				return;

			case 'Y':
				if (dg.scaleY(SMALL_SCALE_UP)) {
					ls.doFeedback("Scaled Y direction (" + 
										SMALL_SCALE_STRING + ")");
				}
				return;

			case 'y':
				if (dg.scaleY(SMALL_SCALE_DOWN)) {
					ls.doFeedback("Scaled Y direction (-" + 
										SMALL_SCALE_STRING + ")");
				}
				return;
			}
		}
	}

	protected boolean handleRelnCommands(int key, int modifiers) {
		switch(key)
		{
		case 'a':
			break;

		case 'F':
			return handleRelnCommands(EDGE_CLOSE_DST, 0);

		case 'f':
			return handleRelnCommands(EDGE_OPEN_DST, 0);

		case 'B':
			return handleRelnCommands(EDGE_CLOSE_SRC, 0);

		case 'b':
			return handleRelnCommands(EDGE_OPEN_SRC, 0);

		case 'l':
			return handleRelnCommands(EDGE_OPEN_LOW, 0);

		case 'L':
		case 't':
			return handleRelnCommands(EDGE_CLOSE_LOW, 0);

		
		case EDGE_OPEN_LOW:
		case EDGE_OPEN_SRC:
		case EDGE_OPEN_DST:
		case EDGE_CLOSE_LOW:
		case EDGE_CLOSE_SRC:
		case EDGE_CLOSE_DST:
		case EDGE_NAVIGATE_SRC:
		case EDGE_NAVIGATE_DST:
			handleEdgeExpansion(key);
			ls.redrawDg();
			return true;

		default:
			return false;
		}

		e = null;
		ri = null;
		bend = null;

		dg.setDrawEdges(true);
		ls.redrawDg();
		return true;
	}

	protected boolean exclusiveEntityCommand(int key) {
		switch(key)
		{
		case CTRL.ENTER:
		case CTRL.UP:
		case CTRL.DOWN:
		case CTRL.LEFT:
		case CTRL.RIGHT:
			return true;
		}

		return false;
	}

	protected void navigateTo(EntityInstance e) {
		ls.followLink(e, false);
	}

	protected boolean handleEntityCommands(int key, int modifiers) {
		boolean incFlag = !mouseIsDown;

		boolean shift = ((modifiers & Event.SHIFT_MASK) != 0);
		boolean middleButton = ((modifiers & Event.ALT_MASK) != 0);

		if (e == null) {
			e = dg.getKeyEntity();
			if (e == null) {
				e = dg.getRoot();
			}
		}

		switch(key)
		{
		case 'q':
		case 'f':
		case 'F':
		case 'b':
		case 'B':		
		case 'C':
			queryEntity(key);
			break;

		case 'c':
		case 'u':
		case 'U':
		case 's':
		case 'S':
		case 'I':
			handleElision(key);
			break;

		case 'x':
		case 'X':
		case 'y':
		case 'Y':
		case 'z':
		case 'Z':
			scaleEntity(key, incFlag);
			break;

		case CTRL.A:
			groupingHandler.groupAll();
			e = null;
			break;

		case CTRL.UP:
		case CTRL.DOWN:
		case CTRL.LEFT:
		case CTRL.RIGHT:
			groupingHandler.moveGroup(key);
			break;

		case 'l':
			edges = dg.getHighlightedEdges();
			if (edges != null)
				return handleRelnCommands(EDGE_OPEN_LOW, 0);

			ls.error("No edges highlighted");
			return true;

		case CTRL.ENTER:
			if (shift) {
				e = dg.getRoot().getEnterableParent();

				if (e == null) {
					ls.error("At topmost landscape");
				}
				else {
					// Going up
					navigateTo(e);
				}
			}
			else {
				e = dg.mouseOverEx(ls.getMousePos());

				if (e != null) {
					EntityInstance root = dg.getRoot();

					if (e == root) {
						ls.error("Already in: " + e.getLabel());
					}
					else if (e == root.getParent()) {
						// Going up
						navigateTo(e);
					}
					else if (dg.isClientOrSupplier(e)) {
						if (e.hasChildren())
							navigateTo(e);
						else
							navigateTo(e.getEnterableParent());
					}
					else {
						// Going down

						while (e.getParent() != root && 
							   e.getParent().isEnterable()) 
						{
							e = e.getParent();
						}

						if (e.isEnterable()) {
							navigateTo(e);
						} else {
							ls.error("Can't navigate into: " + e.getLabel());
						}
					}
				}
			}
			e = null;
			break;

		default:
			e = null;
			ri = null;
			bend = null;
			return false;
		}

		ri = null;
		bend = null;

		if (e != null)
			ls.redrawDg();

		e = null;

		return true;
	}

	protected void handleMenuCommand(Event ev, int x, int y) {
		LsLink link = popup.getLink(ev, ev.x, ev.y);

		if (link != null && link.url != null) {
			// First act as if this entity had been clicked on
			// to select it.

			if (ri == null)
				selectEntity(e);

			// Process command

			if (link.target == LsLink.TARGET_APP) {
				processKey(Util.parseInt(link.url), 0);
			}
			else {
				String linkStr;

				if (ri == null)
					linkStr = LsLink.expand(link.url, e, ls);
				else
					linkStr = LsLink.expand(link.url, ri, ls);

				if (linkStr != null)
					ls.followLink(linkStr, link.target);
			}
		}
	}

	protected void popupMenu(Event ev, int x, int y) {
		e = dg.mouseOverEx(x, y);
		ri = dg.mouseOverEdge(e, x, y);
		if (ri != null) {
			popup.set("Entity options", 
						new CommandList(edgeMenu, edgeKeys),
						null, dg.getRoot(), ls, ev.x, ev.y);
		}
		else {
			popup.set("Entity options", 
						new CommandList(entityMenu, entityKeys),
						null, dg.getRoot(), ls, ev.x, ev.y);
		}
	}

	// --------------
	// Public methods
	// --------------

	public ViewModeHandler() {
		moveHandler = new MoveModeHandler();
		resizeHandler = new ResizeModeHandler();
		navHandler = new NavigateModeHandler();
		groupingHandler = new GroupModeHandler(this);
	}

	public void init(LandscapeViewerCore ls) {
		super.init(ls);

		moveHandler.init(ls);
		resizeHandler.init(ls);
		navHandler.init(ls);
		groupingHandler.init(ls);
	}
	
	public void select(ScrollableDiagram dg) {
		super.select(dg);

		moveHandler.select(dg);
		resizeHandler.select(dg);
		navHandler.select(dg);
		groupingHandler.select(dg);
	}

	public void start() {
		super.start();

		moveHandler.start();
		resizeHandler.start();
		navHandler.start();
		groupingHandler.start();
	}

	public void cleanup() {
		super.cleanup();

		moveHandler.cleanup();
		resizeHandler.cleanup();
		navHandler.cleanup();
		groupingHandler.cleanup();
	}
	
	public void mouseDoubleClick(Event ev, int x, int y) {
		handleEntityCommands(CTRL.ENTER, 0);
		// navHandler.mouseDoubleClick(ev, x, y);
	}

	public boolean mouseDown(Event ev, int x, int y) {

//		System.out.println("ViewModeHandler mousedown\n");

		mouseIsDown = true;

		e = dg.mouseOverEx(x, y);
		if (e == null) {
			return false;
		}

		if (dg.mouseOverEnterExit(e, x, y)) {
			handler = null;
			return true;
		}

		ri = dg.mouseOverEdge(e, x, y);

		if (ri != null) {
			selectEdge(x, y);
			return true;
		}
		else if (edges != null) {
			edges = null;
			dg.clearFlags();
		}

		curX = x;
		curY = y;

		boolean isRoot = (e == dg.getRoot());
		boolean shift = ((ev.modifiers & Event.SHIFT_MASK) != 0);
		boolean ctrl = ((ev.modifiers & Event.CTRL_MASK) != 0);
		boolean middleButton = ((ev.modifiers & Event.ALT_MASK) != 0);
		boolean rightButton = ((ev.modifiers & Event.META_MASK) != 0);

		if (isRoot && !rightButton) {
			dg.clearFlags();
		}

		LandscapeModeHandler newHandler = null;

		if (ctrl) {
			if (navHandler.mouseDown(ev, x, y)) {
				newHandler = navHandler;
			}
		}
		else if (shift) {
			if (groupingHandler.mouseDown(ev, x, y)) {
				newHandler = groupingHandler;
			}
		}
		else if (rightButton) {

			if (popup != null) {
				popup.hide();
				ls.remove(popup);
				popup = null;
			}

			ls.setCursor(Frame.DEFAULT_CURSOR); 
			popup = new LsViewMenu();
			ls.add(popup);
			popupMenu(ev, x, y);
			return true;
		}
		else {
			// Determine if bend/IO move, resize, or group move/activate

			if (moveHandler.mouseDown(ev, x, y)) {
				newHandler = moveHandler;
			}
			else if (resizeHandler.mouseDown(ev, x, y)) {
				newHandler = resizeHandler;
			}
			else if (groupingHandler.mouseDown(ev, x, y)) {
				newHandler = groupingHandler;
			}
		}

		if (newHandler != null) {
			handler = newHandler;
		}

		return true;
	}

	public void mouseMotion(EntityInstance e, int x, int y) {
		if (dg.mouseOverEnterExit(e, x, y) ||
			dg.mouseOverEdge(e, x, y) != null)
		{
			ls.setCursor(Frame.HAND_CURSOR);
			return;
		}
		else if (e != null && e != dg.getRoot()) {
			if (e.getGroupKeyFlag()) {
				int zn = e.overResizeTab(x, y);

				if (zn != EntityInstance.RSZ_NONE) {
					ls.setCursor(resizeCursor[zn]);
					return;
				}
			}
/*
			if (!e.isOpen() && dg.isOverLabel(e, x, y)) {
				ls.setCursor(Frame.HAND_CURSOR);
				return;
			}
*/
		}
		ls.setCursor(Frame.DEFAULT_CURSOR); 
	}

	public boolean mouseDrag(Event ev, int x, int y) {
		if (popup != null) {
			popup.mouseDrag(ev, ev.x, ev.y);
			return true;
		}
		else if (handler != null) {
			return handler.mouseDrag(ev, x, y);
		}

		return false;
	}

	public void mouseUp(Event ev, int x, int y) {
		if (popup != null) {
			popup.hide();
			handleMenuCommand(ev, x, y);
			ls.remove(popup);
			popup = null;
		}
		else if (handler != null) {
			handler.mouseUp(ev, x, y);
		}
		else if (dg.mouseOverEnterExit(e, x, y)) {
			int mod = (e == dg.getRoot().getParent() ? Event.SHIFT_MASK : 0);

			handleEntityCommands(CTRL.ENTER, mod);
		}

		mouseIsDown = false;
	}

	public boolean processKey(int key, int modifiers) {

		if (!exclusiveEntityCommand(key) && edges != null) {
			return handleRelnCommands(key, modifiers);
		}

		return handleEntityCommands(key, modifiers);
	}

	public void setHelp(TextBox tb) {
	}

	public void processClickedText(TextBox tb, String text) {
		ls.doFeedback("Clicked: " + text);
	}
}
