package lsedit;

import java.util.*;

public class Bend extends Object {

	public static final int SIZE = 6;

	private double m_xRelLocal, m_yRelLocal;	// Relative location to parent of centre of bend
	public  double x, y;						// Absolute location of centre of bend

	public EntityInstance e;

	protected Vector edges = new Vector();

	public Bend(EntityInstance e, RelationInstance ri, double x, double y)
	{
		this.e = e;
		edges.addElement(ri);

		setxRelLocal(x);
		setyRelLocal(y);
	}

	public void delete() 
	{
		Enumeration en;

		e.deleteBend(this);

		for (en = edges.elements(); en.hasMoreElements(); ) {
			RelationInstance ri = (RelationInstance) en.nextElement();
			ri.deleteBend(this);
		}
	}

	public void addRelation(RelationInstance ri) 
	{
		edges.addElement(ri);
	}

	public boolean hasRelation(RelationInstance ri) 
	{
		return edges.contains(ri);
	}

	public RelationInstance getFirstEdge() 
	{
		return (RelationInstance) edges.firstElement();
	}

	public void move(double x, double y) 
	{
		double	width1, height1;

		this.x = x;
		this.y = y;

		width1  = e.width();
		height1 = e.height();
	
		if (width1 <= 0.0) {
			setxRelLocal(0.0);
		} else {
			setxRelLocal((x-e.x())/width1);
		}

		if (height1 <= 0.0) {
			setyRelLocal(0.0);
		} else {
			setyRelLocal((y-e.y())/height1);
		}
	}

	public void move(int x, int y) 
	{
		move((double) x, (double) y);
	}

	public boolean isOver(double x, double y) 
	{
		return (x >= (this.x - SIZE/2) && x < (this.x + SIZE/2) &&
				y >= (this.y - SIZE/2) && y < (this.y + SIZE/2));
	}



	public boolean isOver(int x, int y) 
	{
		return isOver((double) x, (double) y);
	}

	public void translate(double dx, double dy) 
	{
		x += dx;
		y += dy;
	}

	public double xRelLocal() 
	{
		return(m_xRelLocal);
	}

	public double yRelLocal()
	{
		return(m_yRelLocal);
	}

	public void setxRelLocal(double xRelLocal)
	{
		m_xRelLocal = xRelLocal;
	}

	public void setyRelLocal(double yRelLocal)
	{
		m_yRelLocal = yRelLocal;
	}
}

