package lsedit;

import java.util.*;



public class ClientCompareFn extends ClientSupplierCompareFn {



	protected double calcAvg(EntityInstance e) {

		Enumeration en = e.srcRelationAbstractedElements();



		double x = 0.0;

		int n = 0;



		while (en.hasMoreElements()) {

			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance dst = ri.getDst();



			if (root.descendent(dst)) {

				if (edgeMode == Diagram.DIRECT_EDGE) {

					EntityInstance vdst = dst.getVisibleEntity();



					Layout lyt = vdst.getLayout();



					x += (lyt.x + lyt.width/2);

					n++;

				}

				else {

					double f = ri.getRelationClass().getIOfactor();



					Layout lyt = root.getLayout();



					x += (lyt.x + lyt.width*f);

					n++;

				}

			}

		}



		if (n > 0)

			return x/n;



		return -1;

	}

}

