package lsedit;

import java.util.*;



abstract public class ClientSupplierCompareFn extends Object 

										implements CompareFn

{

	protected EntityInstance root;

	protected int edgeMode;



	abstract protected double calcAvg(EntityInstance e);



	public int compare(Object o1, Object o2) {

		if (o1 == o2) {

			return 0;

		}



		EntityInstance e1 = (EntityInstance) o1;

		EntityInstance e2 = (EntityInstance) o2;



		double x1 = calcAvg(e1);

		double x2 = calcAvg(e2);



		if (x1 == -1) {

			System.out.println("Compared failed for " + e1);

			return -1;

		}



		if (x2 == -1) {

			System.out.println("Compare failed for " + e2);

			return 1;

		}



		if (x1 > x2)

			return 1;



		else if (x1 < x2)

			return -1;



		else

			return 0;

	}



	public void setRoot(EntityInstance root) {

		this.root = root;

	}



	public void setEdgeMode(int mode) {

		edgeMode = mode;

	}

}

