package lsedit;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.FlowLayout;
import java.awt.Container;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.colorchooser.*;

/* This class augments JColorChooser to allow optionally the
 * inclusion of a null color and an alpha associated with a color
 */

public class ColorChooser extends JDialog implements ActionListener {

	/* Pain that these must be static but seen in a static context */
	/* m_tcc is static so preserves chosen colours */

	private static JColorChooser m_tcc = null;
	private JSlider m_slider;
	private JButton m_okButton, m_canButton, m_nullButton;
	private Color	m_color;
	int				alpha;

	private ColorChooser(JFrame frame, String title, Color oldColor, boolean include_alpha, boolean allow_null) 
	{
		super(frame, title, true /* modal */);

		Container	contentPane;

		m_slider = null;
		m_color  = oldColor;
		contentPane = getContentPane();

		//Set up color chooser for setting text color
		if (m_tcc == null) {
			m_tcc	 = new JColorChooser();
		}
		m_tcc.setColor(((oldColor == null) ? Color.gray : oldColor));

		contentPane.add("North", m_tcc);

		// Create an Okay button in a Panel; add the Panel to the window

		// Use a FlowLayout to center the button and give it margins.

		JPanel p = new JPanel();

		p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));

		if (include_alpha) {
			JPanel p1 = new JPanel();

			m_slider = new JSlider(1, 255, 255);
			m_slider.setMajorTickSpacing(50);
			m_slider.setPaintLabels(true);
			m_slider.setPaintTicks(true);

			if (oldColor == null) {
				alpha = 255;
			} else {
				alpha = oldColor.getAlpha();
			}
			m_slider.setValue(alpha);
			p1.add("Top", m_slider);
			p1.add("Bottom", new JLabel("Alpha", JLabel.CENTER));

			contentPane.add("Center", p1);
		}
		m_okButton = new JButton("OK");
		m_okButton.addActionListener(this);
		p.add(m_okButton);

		if (!allow_null) {
			m_nullButton = null;
		} else {
			m_nullButton = new JButton("Null");
			m_nullButton.addActionListener(this);
			p.add(m_nullButton);
		}

		m_canButton = new JButton("Cancel");
		m_canButton.addActionListener(this);

		p.add(m_canButton);

		contentPane.add("South", p);

		// Resize the window to the preferred size of its components
		
		pack();
	}

	// Pop down the window when the button is clicked.

	public void actionPerformed(ActionEvent e)
	{
		Object source = e.getSource();

		if (source != m_canButton) {
			if (source == m_okButton) {
				m_color = m_tcc.getColor();
				if (m_slider != null) {
					int alpha;

					alpha = m_slider.getValue();
					if (alpha != 255) {
						m_color = new Color(m_color.getRed(), m_color.getGreen(), m_color.getBlue(), alpha);
				}	}
			} else if (source != null && source == m_nullButton) {
				m_color = null; 
			} else {
				return;
		}	}
		hide();
	}

	public Color getColor()
	{
		return(m_color);
	}

	public static Color create(JFrame frame, String title, Color oldColor, boolean include_alpha, boolean allow_null) 
	{

		Color	color;

		ColorChooser mb = new ColorChooser(frame, title, oldColor, include_alpha, allow_null);

		mb.move(20, 20);
		mb.show();
		color = mb.getColor();
		mb.dispose();
		return(color);
	}
}
