package lsedit;

import java.util.*;



public class DagGridLayout extends Object {

	int numLevels  = 0;

	int maxBreadth = 0;



	EntityInstance[][] grid = new EntityInstance[100][100];



	protected boolean 

		atLevel(EntityInstance e, Vector grp, int ln, RelationClass rc)

	{

		boolean noPar = true;

		boolean hasEdge = false;



		Enumeration en = e.srcRelationElements();



		while (en.hasMoreElements()) {

			RelationInstance ri = (RelationInstance) en.nextElement();



			if (ri.getRelationClass() == rc) {

				EntityInstance dst = ri.getDst();



				hasEdge = true;

				noPar = noPar && (!grp.contains(dst));

			}

		}



		return (hasEdge && noPar);

	}



	protected Vector findLevel(Vector grp, int ln, RelationClass rc) {

		Vector lvl = new Vector();



		Enumeration en = grp.elements();



		while (en.hasMoreElements()) {

			EntityInstance e = (EntityInstance) en.nextElement();



			if (atLevel(e, grp, ln, rc)) {

				lvl.addElement(e);

			}

		}



		return lvl;

	}



	public DagGridLayout(Vector ogrp, RelationClass rc) {

		Vector grp = new Vector();



		for (int i=0; i<ogrp.size(); i++)

		   grp.addElement(ogrp.elementAt(i));



		while (grp.size() > 0) {

			Vector v = findLevel(grp, numLevels, rc);



			int sz = v.size();



			if (sz == 0) {

				numLevels = 0;

				return;

			}



			if (sz > maxBreadth) 

				maxBreadth = sz;



			for (int i=0; i<sz; i++) {

				EntityInstance te = (EntityInstance) v.elementAt(i);



				grid[numLevels][i] = te;



				grp.removeElement(te);

			}



			numLevels++;

		}

	}



	public int numLevels() {

		return numLevels;

	}



	public int maxBreadth() {

		return maxBreadth;

	}



	public EntityInstance getGrid(int level, int pos) {

		return grid[level][pos];

	}

}

