package lsedit;
import java.applet.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.util.*;


public class Diagram extends Object implements Runnable {

	public DrawCache drawCache;

	public static final float BG = 0.75f;
	public static final String BG_STR = "0.75";
	public static final Color boxColour = Color.lightGray;

	protected static final int EXIT_FLAG_DIM = 8;
	protected static final int GAP = 5;
	protected static final int MARGIN = GAP*2;

	public static final String INSTANCE_ID				= "$INSTANCE";	
	public static final String INHERIT_RELN				= "$INHERIT";
	public static final String ALL_RELN					= "All";


	public static final String CONTAIN_ID				= "contain"; 
	public static final String EDGEMODE_ID				= "edgemode"; 
	public static final String TOPCLIENTS_ID			= "topclients"; 
	public static final String WANTCLIENTS_ID			= "wantclients"; 
	public static final String WANTSUPPLIERS_ID			= "wantsuppliers"; 
	public static final String WANTCARDINALS_ID			= "wantcardinals"; 
	public static final String SCALE_ID					= "scale";
	public static final String RELN_HIDDEN_ID			= "reln_hidden";
	public static final String NAVLINK_ID				= "navlink";

	public static final String RAW_HEADER				= "#TA_RAW#";

	public static final int STUMP_DST   = 1;
	public static final int BEST_EDGE	= 0;			// BEST_EDGE			
	public static final int TB_EDGE		= 1;			// TOP BOTTOM EDGE
	public static final int DIRECT_EDGE = 2; 

	public static final int UPDATE_FREQ = 250; 

	public static final int DEF_CAP = 2000; 
	public static final float DEF_LOAD = 0.5f;

	public static final int DEF_REL_CAP = 10000; 

	protected final static int CLIENT = 1;
	protected final static int SUPPLIER = 2;


	protected final static String ROOT_ID = "$ROOT";
	protected final static double MIN_REL_SCALE = 0.1;
	protected final static double MAX_REL_SCALE = 10.0;

	protected final static int MOVE_ZONE_MAX	= 20;

	protected final static int CLIENT_SUPPLIER_HEIGHT = 50;

	protected final static String EDGE_SUFFIX = "$EDGESUFFIX$";

	protected int	m_xoffset;		//	The position of the viewport over the diagram
	protected int	m_yoffset;		

	private int		m_x;									// Position of diagram in pixels
	private int		m_y;									// Position of diagram in pixels
	private	int		m_width;								// Width    of diagram in pixels
	private	int		m_height;								// Height   of diagram in pixels

	protected EntityInstance	m_rootInstance;				// The root instance of the graph
	protected EntityInstance	m_drawRoot;					// The current entity being drawn

	protected Hashtable entityClasses	= new Hashtable(10);
	protected Hashtable relationClasses = new Hashtable(5);
	protected Hashtable entityInstances = new Hashtable(DEF_CAP, DEF_LOAD);
	protected Hashtable attrNames		= new Hashtable(20);
	protected Hashtable edges			= new Hashtable(DEF_REL_CAP, DEF_LOAD);

	protected Vector	numToRel		= new Vector(10);

	protected ClientCompareFn clientCompareFn = new ClientCompareFn();
	protected SupplierCompareFn supplierCompareFn = new SupplierCompareFn();

	protected RelationClass		relationBaseClass; 
	protected EntityClass		entityBaseClass;

	protected int				numRelationClasses = 0;
	protected int				numVisibleRelationClasses = 0;

	protected EntityClass		defaultEntityClass = null;
	protected int				numEntityClasses = 0; 

	protected boolean			persistentQuery = false;
	protected boolean			universalScheme = false;
	protected boolean			allowRecursion = true;
	protected boolean			readOnly = false;

	protected LandscapeViewerCore ls;

	protected Object			context;

	protected int mode; 

	protected int gridPixels = 1;


	protected double topXscale, topYscale;

	protected Attribute			 relVisibilityAttr; 

	protected boolean visibleEdges = true;
	protected boolean drawEdges = true;
	protected boolean drawBends = false;
	protected Color	  xorMode	= null;

	protected int newCnt = 0;					// Used to id new entities	
	protected Diagram undoDg; 
	protected boolean undoValid = false;

	protected int timeStamp = 0;
	protected Vector sourceList;
	protected Vector sectionList;

	protected Vector globalBends = new Vector();

	protected EntityInstance keyEntity;

	protected boolean changedFlag = false;

	protected Vector clients, suppliers;
	protected Vector dClients, dSuppliers;

	protected boolean clientsSorted = false;
	protected boolean suppliersSorted = false;

	protected boolean allClients = true;
	protected boolean allSuppliers = true;

	/* Must detect use of legacy coordinates and convert after diagram loaded
	 * since attributes may not be in tree order so won't know parent dimensions
	 * necessarily when doing conversion from legacy coordinates to relative ones
	 */

	boolean	  m_uses_local_coordinates;

	// -----------------
	// Protected methods
	// -----------------



	protected boolean isTopClients() {

		return ls.getOption(LandscapeViewerCore.TOP_CLIENTS);

	}


	// If ignore is CLIENT/SUPPLIER we can ignore these things

	protected double calcWidth(Graphics g, Vector v, int ignore) 
	{
		Enumeration en;

		double tw = 0.0;

		for (en = v.elements(); en.hasMoreElements(); ) {

			EntityInstance e = (EntityInstance) en.nextElement();
			if ((e.getMark() & ignore) == 0) {
				Layout lyt = e.getLayout();

				Dimension dim = e.getFitDim(g, EntityInstance.SMALL_FONT, true);

				tw += (dim.width + GAP);
			}
		}
		return (tw - GAP);
	}



	protected EntityInstance mostFrequentParent(Vector v, int ignore) 
	{
		Vector p = new Vector();

		int[] cnt = new int[v.size()];
		Enumeration en = v.elements();

		while (en.hasMoreElements()) {
			EntityInstance e = (EntityInstance) en.nextElement();
			if ((e.getMark() & ignore) == 0) {
				EntityInstance pe = e.getEnterableParent();

				if (pe.descendent(m_drawRoot)) {
					continue;
				}

				int ind = p.indexOf(pe);

				if (ind < 0) {
					cnt[p.size()] = 1;
					p.addElement(pe);
				} else {
					cnt[ind]++;
				}
			}
		}

		int mVal = 0;
		int mInd = -1;

		for (int i=0; i<p.size(); i++) {
			if (cnt[i] > mVal) {
				mVal = cnt[i];
				mInd = i;
			}
		}

		if (mInd < 0) {
			return(null);
		}
		return (EntityInstance) p.elementAt(mInd);
	}



	protected void markEntities() {

		Enumeration en = clients.elements();



		while (en.hasMoreElements()) {

			EntityInstance ce = (EntityInstance) en.nextElement();



			ce.setMark(ce.getMark() | CLIENT);

		}



		en = suppliers.elements();



		while (en.hasMoreElements()) {

			EntityInstance se = (EntityInstance) en.nextElement();



			se.setMark(se.getMark() | SUPPLIER);

		}

	}



	protected void elimDescendents(Vector l, EntityInstance pe) {

		Vector el = new Vector();



		Enumeration en = l.elements();



		while (en.hasMoreElements()) {

			EntityInstance e = (EntityInstance) en.nextElement();

		

			if (pe.descendent(e)) 

				el.addElement(e);

		}



		en = el.elements();



		while (en.hasMoreElements()) {

			EntityInstance e = (EntityInstance) en.nextElement();

		

			l.removeElement(e);

		}

	}





	protected void elimAmbiguities() {

		markEntities();



		Enumeration en = clients.elements();



		Vector elc = new Vector();

		Vector els = new Vector();

		Vector ac = new Vector();

		Vector as = new Vector();



		while (en.hasMoreElements()) {

			EntityInstance ce = (EntityInstance) en.nextElement();



			Enumeration en2 = suppliers.elements();



			while (en2.hasMoreElements()) {

				EntityInstance se = (EntityInstance) en2.nextElement();



				if (se != ce && se.descendent(ce)) {

					elc.addElement(ce);

					if (!ac.contains(se)) {

						ac.addElement(se);

					}

				}

				else if (se != ce && ce.descendent(se)) {

					els.addElement(ce);

					if (!as.contains(ce))

						as.addElement(ce);

				}

			}

		}



		en = elc.elements();



		while (en.hasMoreElements()) {

			EntityInstance e = (EntityInstance) en.nextElement();



			clients.removeElement(e);

		}



		en = ac.elements();



		while (en.hasMoreElements()) {

			EntityInstance e = (EntityInstance) en.nextElement();



			elimDescendents(clients, e);

			clients.addElement(e);

		}



		en = els.elements();



		while (en.hasMoreElements()) {

			EntityInstance e = (EntityInstance) en.nextElement();



			suppliers.removeElement(e);

		}



		en = as.elements();



		while (en.hasMoreElements()) {

			EntityInstance e = (EntityInstance) en.nextElement();



			elimDescendents(suppliers, e);

			suppliers.addElement(e);

		}



		markEntities();

	}



	protected Vector getDisplaySet(Vector el, int ignore) {

		if (el == null)

			return null;



		Vector vl = new Vector();



		Enumeration en = el.elements();



		while (en.hasMoreElements()) {

			EntityInstance e = (EntityInstance) en.nextElement();



			if ((e.getMark() & ignore) == 0) {

				vl.addElement(e);

			}

		}



		return vl;

	}



	// ignore indicates those things in a v to be ignored

	protected boolean reduceClientSuppliers(Graphics g, Vector v, int ignore) 
	{

		// While the set of clients/supplier are too wide to be displayed
		// replace the lower level entities with their parent.  Keep doing
		// this while there are choices for parents

		EntityInstance pe;


		boolean allKept = true;
		for (;;) {

			double tw = calcWidth(g, v, ignore);

			if (tw <= (m_width - GAP*4)) {
				break;
			}
			pe = mostFrequentParent(v, ignore);

			if (pe == null) {
				break;
			}

			elimDescendents(v, pe);
			v.addElement(pe);
		}
		return(allKept);

	}



	protected void output(String head, Vector l) {

		System.out.println(head);

		Enumeration en = l.elements();

		while (en.hasMoreElements()) {
			EntityInstance e = (EntityInstance) en.nextElement();
			System.out.println(" " + e);
		}
	}



	protected void findClientsAndSuppliers() 
	{
		clients = new Vector();
		suppliers = new Vector();

		if (ls.getOption(LandscapeViewerCore.SHOW_CLIENTS)) {
			m_drawRoot.getClients(clients, m_drawRoot);
		}

		if (ls.getOption(LandscapeViewerCore.SHOW_SUPPLIERS)) {
			m_drawRoot.getSuppliers(suppliers, m_drawRoot);
		}

		Graphics g = ls.getGraphics();

		m_rootInstance.clearMarks();

		allSuppliers = reduceClientSuppliers(g, suppliers, 0);

		markEntities();


		allClients = reduceClientSuppliers(g, clients, SUPPLIER);

		markEntities();



		elimAmbiguities();

		markEntities();

		dClients = getDisplaySet(clients, SUPPLIER);

		dSuppliers = getDisplaySet(suppliers, 0);

	}



	protected double getClientSupplierPos(double topPos, double botPos) 
	{
		return (isTopClients() ? topPos : botPos);
	}



	protected int progressCount;



	protected void updateProgress() 
	{
		progressCount++;

		StringBuffer sb = new StringBuffer("Loading: ");
		for (int i=0; i<progressCount; i++) {
			sb.append('*');
		}
		ls.doFeedback(new String(sb));
	}

	protected void setVisibilityFlags() 
	{
		Enumeration en = enumRelations();

		numVisibleRelationClasses = 0;

		while(en.hasMoreElements()) {
			RelationClass rc = (RelationClass) en.nextElement();
			if (!excludeReln(rc)) {
				if (rc.isVisible()) {
					rc.setOrdinal(numVisibleRelationClasses++);
				}
			}
		}
		visibleEdges = (numVisibleRelationClasses > 0);
	}

	protected void registerAttrName(String id) 
	{
		if (attrNames.get(id) == null) {
			attrNames.put(id, id);
		}
	}



	protected void registerAttrNames(Attribute attr) {

		while(attr != null) {
			registerAttrName(attr.id);
			attr = attr.next;
		}

	}



	protected RelationClass addRelationClass(String id) {

		RelationClass rc = (RelationClass) relationClasses.get(id);		// Lookup in the hash table

		if (rc == null) {
			rc = new RelationClass(id, numRelationClasses, relationBaseClass, this);
			relationClasses.put(id, rc);
			numToRel.addElement(rc);
			numRelationClasses++;
		}
		return rc;
	}



	protected EntityClass addEntityClass(String id) {

		EntityClass ec = (EntityClass) entityClasses.get(id); 

		if (ec == null) {

			ec = new EntityClass(id, numEntityClasses++, entityBaseClass /* parent class */, this);

			entityClasses.put(id, ec);

			if (defaultEntityClass == null) {

				defaultEntityClass = ec;

			}
		}

		return ec;
	}



	protected EntityInstance addEntity(EntityClass ec, String eid) {

		EntityInstance e = ec.newEntity(eid, this);

		e.setNid(entityInstances.size());

		entityInstances.put(eid, e);			// Add it to entity set

		// For now make it contained by root

		m_rootInstance.addContainment(e);



		return e;

	}



	protected void removeEntity(EntityInstance e) {

		e.getParent().removeContainment(e);

		entityInstances.remove(e.getId());

	}



	protected boolean containsEntity(EntityInstance e) {

		return entityInstances.contains(e.getId());

	}

		

	// Setup for universal scheme
	// This is employed if there are no SCHEME TUPLES



	protected void setupUniversalScheme() {

		relationBaseClass.addRelation(entityBaseClass, entityBaseClass);
		universalScheme = true;
	}



	// Section processing methods



	protected void 
	processSchemeTuples(LandscapeTokenStream ts) throws IOException {

		for (;;) {

			Tuple tuple = ts.nextTuple();

			if (tuple == null) {
				return;
			}

//			System.out.println("Schema Tuples: " + tuple);

			RelationClass rc = null;

			boolean inheritance = tuple.token1.equals(INHERIT_RELN);			// $INHERIT

			if (inheritance) {
				if (tuple.token2.equals(EntityClass.ENTITY_BASE_CLASS_ID)) {	// $ENTITY
					ts.errorNS("Improper use of $ENTITY with $INHERIT");
					return;
				}
			} else { 
				rc = addRelationClass(tuple.token1);
			}

			EntityClass ec1 = addEntityClass(tuple.token2); 
			EntityClass ec2 = addEntityClass(tuple.token3);

			if (inheritance) {

				String msg = ec1.addParentClass(ec2);
				if (msg != null)
					ts.errorNS(msg);
			} else {
				rc.addRelation(ec1, ec2);		// If not already present
			}
		}
	}



	protected void processSchemeAttributes(LandscapeTokenStream ts) throws IOException 
	{

		for (;;) {

			AttributeRecord ar = ts.nextRecord();
			if (ar == null) {
				return;
			}

//			System.out.println("Schema Attributes: " + ar);

			if (ar.id.startsWith("(")) {
				StringTokenizer st = new StringTokenizer(ar.id, "() ");
				String rel = st.nextToken();

				RelationClass rc = (RelationClass) relationClasses.get(rel);

				if (rc != null) {
					Attribute attr = ar.attributes;
					while(attr != null) { 
						rc.addAttribute(attr);
						attr = attr.next;
					}
					registerAttrNames(ar.attributes);
				} else {
					ts.errorNS("Can't process record. Missing relation class '" + rel + "'");
				}
			} else {

				if (ar.id.equals(ROOT_ID)) {
					Attribute attr = ar.attributes;

					while(attr != null) {
						m_rootInstance.addAttribute(attr);
						attr = attr.next;
					}
					registerAttrNames(ar.attributes);
				} else { 

					EntityClass ec = (EntityClass) entityClasses.get(ar.id);

					if (ec != null) {
						Attribute attr = ar.attributes;
						while(attr != null) {
							ec.addAttribute(attr);
							attr = attr.next;
						}
						registerAttrNames(ar.attributes);
					} else {
						ts.errorNS("Can't process record. Missing entity class '" + ar.id + "'");
					}
				}
			}
		}
	}

	protected void processFactTuples(LandscapeTokenStream ts) throws IOException 
	{
		int ne = 0;
		int nr = 0;

		MsgOut.vprint("\nFACT TUPLE : ");

		for (;;) {
			Tuple tuple = ts.nextTuple();

			if (tuple == null) {
				return;
			}	

//			System.out.println("Fact Tuple: " + tuple);

			if (tuple.token1.equals(INSTANCE_ID)) {

				// 
				// $INSTANCE instanceId classId
				//

				ne++;
		
				if ((ne % UPDATE_FREQ) == 0) {
					MsgOut.vprint(".");
					updateProgress();
					ls.showInfo("Entities: " + ne);
				}		


				EntityInstance e = (EntityInstance) entityInstances.get(tuple.token2);

				if (e == null) {

					// New $INSTANCE

					EntityClass ec = (EntityClass) entityClasses.get(tuple.token3);


					if (ec != null) {

						e = ec.newEntity(tuple.token2, this);
						e.setNid(entityInstances.size());		// Add it to entity set

						entityInstances.put(tuple.token2, e);

						// For now make it contained by root

						m_rootInstance.addContainment(e);

					}  else {
						ts.errorNS("EntityClass '" + tuple.token3 + "' has not been declared");
					}
				} else {

					EntityClass ec = e.getEntityClass();

					if (ec.hasId(tuple.token3)) {
						ts.warning("Redeclaration of " + e.toString());
					} else {

						ts.errorNS("Attempt to declare " + e.getId() + " as instanceof " + tuple.token3 + ". Currently declared as instanceof " + ec.getId());
					}
				}
			} else {

				// Relation tuple definition
				//
				// relationClass entityInstance entityInstance
				//

				nr++;

				if ((nr % UPDATE_FREQ) == 0) {

					MsgOut.vprint(".");
					updateProgress();
					ls.showInfo("Relations: " + nr);
				}		



				RelationClass rc  = (RelationClass)	 relationClasses.get(tuple.token1);
				EntityInstance e1 = (EntityInstance) entityInstances.get(tuple.token2);
				EntityInstance e2 = (EntityInstance) entityInstances.get(tuple.token3);

				if (universalScheme) {

					// Implicit declaration upon use

					if (rc == null) {
						rc = relationBaseClass;
					}

					if (e1 == null) {
						e1 = entityBaseClass.newEntity(tuple.token2, this);
						e1.setNid(entityInstances.size());
						entityInstances.put(tuple.token2, e1); 
						m_rootInstance.addContainment(e1);
					}



					if (e2 == null) {
						e2 = entityBaseClass.newEntity(tuple.token3, this);
						e2.setNid(entityInstances.size());
						entityInstances.put(tuple.token3, e2);
						m_rootInstance.addContainment(e2);
					}
				}



				if (rc == null) {
					ts.errorNS("Can't process: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token1 + "'");
				} else if (e1 == null) {
					ts.errorNS("Can't process: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token2 + "'");
				} else if (e2 == null) {
					ts.errorNS("Can't process: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token3 + "'");
				} else if (!allowRecursion && e1 == e2) {

					ts.warning("Ignoring recursive relation: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ")");
				} else if (e1.isContainedBy(e2)) {
					ts.errorNS("Relation from child to containing parent: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ")");
				} else {

					EntityClass ec1 = e1.getEntityClass();
					EntityClass ec2 = e2.getEntityClass();

					if (rc.isValidRelation(ec1, ec2)) {
						if (tuple.token1.equals(CONTAIN_ID)) {
							// Right now it is contained by root, so
							// remove from root's containment, and
							// make it contained by another e1.

							if (m_rootInstance.removeContainment(e2)) {
								e1.addContainment(e2);
							}
						} else {
							addEdge(e1, e2, rc);
						}
					} else {
						ts.errorNS("Invalid use of relation " + tuple.token1);
					}
				}
			}
		}
	}



	protected void 
	processFactAttributes(LandscapeTokenStream ts) throws IOException 

	{
		int n = 0;

		MsgOut.vprint("\nFACT ATTRIBUTE : ");
		for (;;) {
			AttributeRecord ar = ts.nextRecord();
			if (ar == null) {
				break;
			}

//			System.out.println("Fact Attribute: " + ar);
				
			n++; 

			if ((n % UPDATE_FREQ) == 0) {
				MsgOut.vprint(".");
				updateProgress();
				ls.showInfo("Attr Records: " + n);
			}

			MsgOut.vprintln("Processing record: " + ar.id);

			if (ar.id.startsWith("(")) {
				// Attributes assigned to a relation tuple (rare)

				Tuple tuple = new Tuple(ar.id);

				RelationClass  rc  = (RelationClass)	relationClasses.get(tuple.token1);
				EntityInstance src = (EntityInstance)	entityInstances.get(tuple.token2);
				EntityInstance dst = (EntityInstance)	entityInstances.get(tuple.token3);

				if (rc == null) {
					ts.errorNS("Can't process record for " + ar.id + ". " + "Missing relation '" + tuple.token1 + "'");
				} else if (src == null) {
					ts.errorNS("Can't process record for " + ar.id + ". " + "Missing entity '" + tuple.token2 + "'");
				} else if (dst == null) {
					ts.errorNS("Can't process record for " + ar.id + ". " + "Missing entity '" + tuple.token3 + "'");
				} else {
					RelationInstance ri = src.getRelation(rc, dst);

					if (ri == null) {
						ts.errorNS("Can't process record. " + "Missing relation " + ar.id);
					} else {
						ri.assignAttributes(ar.attributes, entityInstances);
						registerAttrNames(ar.attributes);
					}
				}
			}  else {

				EntityInstance e;

				if (ar.id.equals(ROOT_ID)) {
					e = m_rootInstance;
				} else {
					e = (EntityInstance) entityInstances.get(ar.id);
				}
				if (e != null) {
					e.assignAttributes(ar.attributes);
					registerAttrNames(ar.attributes);
				} else if (universalScheme) {

					// Create it

					e = entityBaseClass.newEntity(ar.id, this);
					e.setNid(entityInstances.size());
					entityInstances.put(ar.id, e);

					m_rootInstance.addContainment(e);

					e.assignAttributes(ar.attributes);

					registerAttrNames(ar.attributes);

				} else {

					ts.errorNS("Can't process record. " + "Missing entity '" + ar.id + "'");
				}
			}
		}
	}



	// *** And now for output ***



	protected void writeRawPairs(DataOutputStream dos, Vector v) 

		throws IOException 

	{

		dos.writeInt(v.size());



		Enumeration en = v.elements();



		while (en.hasMoreElements()) {

			Integer[] pair = (Integer[]) en.nextElement();



			dos.writeInt(pair[0].intValue());

			dos.writeInt(pair[1].intValue());

		}

	}



	protected void writeRawTriples(DataOutputStream dos, Vector v) 

		throws IOException

	{

		dos.writeInt(v.size());



		Enumeration en = v.elements();



		while (en.hasMoreElements()) {

			Integer[] triple = (Integer[]) en.nextElement();



			dos.writeInt(triple[0].intValue());

			dos.writeInt(triple[1].intValue());

			dos.writeInt(triple[2].intValue());

		}

	}



	protected void writeRawAttributes(DataOutputStream dos, Vector v)

		throws IOException

	{

		dos.writeInt(v.size());



		Enumeration en = v.elements();



		while(en.hasMoreElements()) {

			Object[] obj = (Object []) en.nextElement();



			dos.writeInt(((Integer) obj[0]).intValue());



			Vector lv = (Vector) obj[1];



			dos.writeInt(lv.size());



			Enumeration en1 = lv.elements();



			while (en1.hasMoreElements()) {

				Object[] attr = (Object []) en1.nextElement();



				dos.writeInt(((Integer) attr[0]).intValue());



				int type = ((Integer) attr[1]).intValue();



				dos.writeInt(type);



				switch(type) 

				{

				case Attribute.NULL_TYPE:

					break;



				case Attribute.INT_TYPE:

					dos.writeInt(((Integer) attr[2]).intValue());

					break;

				

				case Attribute.DOUBLE_TYPE:

					dos.writeDouble(((Double) attr[2]).doubleValue());

					break;

				

				case Attribute.STRING_TYPE:

					dos.writeUTF((String) attr[2]);

					break;



				case Attribute.INT_LIST_TYPE:

					{

					int[] il = (int[]) attr[2];

					int num = il.length;



					dos.writeInt(num);

				

					for (int i=0; i<num; i++) {

						dos.writeInt(il[i]);

					}

					}

					break;



				case Attribute.DOUBLE_LIST_TYPE:

					{

					double[] dl = (double[]) attr[2];

					int num = dl.length;



					dos.writeInt(num);

				

					for (int i=0; i<num; i++) {

						dos.writeDouble(dl[i]);

					}

					}

					break; 



				case Attribute.STRING_LIST_TYPE:

					{

					String[] sl = (String[]) attr[2];

					int num = sl.length;



					dos.writeInt(num);

				

					for (int i=0; i<num; i++) {

						dos.writeUTF(sl[i]);

					}

					}

					break;

				}

			}

		}

	}



	protected void writeSchemeTuples(PrintStream ps) throws IOException {

		ps.print("// Landscape TA file\n\n");

		ps.print("SCHEME TUPLE :\n\n// The ERD\n\n"); 



		Enumeration enum1 = enumEntityClasses();



		while(enum1.hasMoreElements()) {

			EntityClass ec = (EntityClass) enum1.nextElement();



			if (ec != entityBaseClass) {

				Enumeration en = ec.getParentElements();



				while (en.hasMoreElements()) {

					EntityClass parent = (EntityClass) en.nextElement();



					if (parent != entityBaseClass) {

						ps.print(INHERIT_RELN + " " + ec.getId() + " " + 

								parent.getId() + "\n");

					}

				}

			}

		}



		ps.print("\n");



		enum1 = enumRelations(); // Output in same order as input



		while(enum1.hasMoreElements()) {

			RelationClass rc = (RelationClass) enum1.nextElement();



			rc.writeRelations(ps); 

		}

	}



	protected void 

		writeSchemeTuplesRaw(DataOutputStream dos, Hashtable stringTable) 

				throws IOException

	{

		dos.writeUTF("#1#");



		Vector v = new Vector();



		Enumeration en = enumEntityClasses();



		while(en.hasMoreElements()) {

			EntityClass ec = (EntityClass) en.nextElement();



			if (ec != entityBaseClass) {

				Enumeration en1 = ec.getParentElements();



				while (en1.hasMoreElements()) {

					EntityClass parent = (EntityClass) en1.nextElement();



					if (parent != entityBaseClass) {

						Integer[] pair = new Integer[2];



						pair[0] = (Integer) stringTable.get(ec.getId());

						pair[1] = (Integer) stringTable.get(parent.getId());



						v.addElement(pair);

					}

				}

			}

		}



		writeRawPairs(dos, v);



		v = new Vector();



		en = enumRelations(); // Output in same order as input



		while(en.hasMoreElements()) {

			RelationClass rc = (RelationClass) en.nextElement();



			rc.getRelationsRaw(v, stringTable);

		}



		writeRawTriples(dos, v);

	}



	protected void writeFactTuples(PrintStream ps) throws IOException 
	{
		ps.print("\n\nFACT TUPLE :\n\n"); 
		ps.print("// Instances of entity classes\n\n");
		m_rootInstance.writeInstances(ps);
		m_rootInstance.writeRelations(ps); 
	}



	protected void
	writeFactTuplesRaw(DataOutputStream dos, Hashtable stringTable)	throws IOException
	{
		dos.writeUTF("#3#");
		Vector v = new Vector();
		m_rootInstance.getInstancesRaw(v, stringTable);
		writeRawPairs(dos, v);
		v = new Vector();
		m_rootInstance.getRelationsRaw(v, stringTable, (Integer) stringTable.get(CONTAIN_ID)); 
		writeRawTriples(dos, v);
	}



	protected void 

	writeSchemeAttributes(PrintStream ps) throws IOException {

		ps.print("\n\nSCHEME ATTRIBUTE :\n\n");



		ps.print("// EntityClass attributes\n\n");



		// Write attributes for entity classes 



		Enumeration en = entityClasses.elements();



		while (en.hasMoreElements()) {

			EntityClass ec = (EntityClass) en.nextElement(); 



			ec.writeAttributes(ps);

		}



		// Write attributes for relation classes 



		en = relationClasses.elements(); 



		while (en.hasMoreElements()) {

			RelationClass rc = (RelationClass) en.nextElement();



			rc.writeAttributes(ps);

		}

	}



	protected void

		writeSchemeAttributesRaw(DataOutputStream dos, Hashtable stringTable)

			throws IOException

	{

		// Write attributes for entity classes 



		dos.writeUTF("#2#");



		Vector v = new Vector();



		Enumeration en = entityClasses.elements();



		while (en.hasMoreElements()) {

			EntityClass ec = (EntityClass) en.nextElement(); 



			ec.getAttributesRaw(v, stringTable);

		}



		writeRawAttributes(dos, v);



		// Write attributes for relation classes 



		v = new Vector();



		en = relationClasses.elements(); 



		while (en.hasMoreElements()) {

			RelationClass rc = (RelationClass) en.nextElement();



			rc.getAttributesRaw(v, stringTable);

		}



		writeRawAttributes(dos, v);

	}





	protected void writeFactAttributes(PrintStream ps) throws IOException
	{
		ps.print("\n\nFACT ATTRIBUTE :\n\n"); 
		m_rootInstance.writeAttributes(ps, true); 
	}



	protected void
	writeFactAttributesRaw(DataOutputStream dos, Hashtable stringTable)	throws IOException
	{
		dos.writeUTF("#4#");
		Vector v = new Vector();
		m_rootInstance.getAttributesRaw(v, stringTable);
		writeRawAttributes(dos, v);
	}



	/*

	protected int regSrcInfo(String src, int section) {

		int ind = sourceList.indexOf(src);



		if (ind < 0) {

			sourceList.addElement(src);

			sectionList.addElement(new Integer(section));

			return sourceList.size();

		}

		else

			return ind;

	}

	*/



	private boolean schemeSetup = false;



	private String resString = null;



	protected Vector readStringTable(DataInputStream dis) throws IOException {

		Vector st = new Vector();



		int num = dis.readInt();



		for (int i=0; i<num; i++) {

			st.addElement(dis.readUTF());

		}



/*

		Enumeration en = st.elements();



		while(en.hasMoreElements()) {

			String str = (String) en.nextElement();

			System.out.println(str);

		}

*/



		return st;

	}



	protected void processRawSchemeTuples(DataInputStream dis,

												Vector st) throws IOException 

	{

		// Read inherits



		int num = dis.readInt();



		for (int i=0; i<num; i++) {

			String child = (String) st.elementAt(dis.readInt());

			String parent = (String) st.elementAt(dis.readInt());



			EntityClass ec1 = addEntityClass(child);

			EntityClass ec2 = addEntityClass(parent);



			ec1.addParentClass(ec2);

		}



		num = dis.readInt();



		for (int i=0; i<num; i++) {

			String rcid	 = (String) st.elementAt(dis.readInt());

			String ecid1 = (String) st.elementAt(dis.readInt());

			String ecid2 = (String) st.elementAt(dis.readInt());



			RelationClass rc = addRelationClass(rcid);

			EntityClass ec1	 = addEntityClass(ecid1);

			EntityClass ec2	 = addEntityClass(ecid2);



			rc.addRelation(ec1, ec2);

		}

	}



	protected void processRawAttributes(LandscapeObject lo, 

						DataInputStream dis, Vector st) throws IOException

	{

		int na = dis.readInt();



		for (int i=0; i<na; i++) {

			String aid = (String) st.elementAt(dis.readInt());

			int type = dis.readInt();



			registerAttrName(aid);



			boolean rc;



			switch(type)

			{

			case Attribute.NULL_TYPE:

				rc = lo.addRawAttribute(aid);

				break;



			case Attribute.INT_TYPE:

				rc = lo.addRawAttribute(aid, dis.readInt());

				break;



			case Attribute.DOUBLE_TYPE:

				rc = lo.addRawAttribute(aid, dis.readDouble());

				break;

				

			case Attribute.STRING_TYPE:

				rc = lo.addRawAttribute(aid, dis.readUTF());

				break;



			case Attribute.INT_LIST_TYPE:

				{

				int num = dis.readInt();

				

				int[] il = new int[num];



				for (int j=0; j<num; j++) {

					il[j] = dis.readInt();

				}



				rc = lo.addRawAttribute(aid, il);

				}

				break;



			case Attribute.DOUBLE_LIST_TYPE:

				{

				int num = dis.readInt();

				

				double[] dl = new double[num];



				for (int j=0; j<num; j++) {

					dl[j] = dis.readDouble();

				}



				rc = lo.addRawAttribute(aid, dl);

				}

				break;

		

			case Attribute.STRING_LIST_TYPE:

				{

				int num = dis.readInt();

				

				String[] sl = new String[num];



				for (int j=0; j<num; j++) {

					sl[j] = dis.readUTF();

				}



				rc = lo.addRawAttribute(aid, sl);

				}

				break;



			default:

				rc = false;

				MsgOut.println("Unknown attribute type: " + type);

				break;

			}



			if (!rc) {

				MsgOut.println("Unhandled attribute: " + aid + 

								" - type: " + type);

			}

		}

	}



	protected void processRawSchemeAttributes(DataInputStream dis,

												Vector st) throws IOException 

	{

		int num = dis.readInt();



		for (int i=0; i<num; i++) {

			String ecid = (String) st.elementAt(dis.readInt());



			EntityClass ec = (EntityClass) entityClasses.get(ecid);



			processRawAttributes(ec, dis, st);

		}



		num = dis.readInt();



		for (int i=0; i<num; i++) {

			String rcid = (String) st.elementAt(dis.readInt());



			RelationClass rc = (RelationClass) relationClasses.get(rcid);



			processRawAttributes(rc, dis, st);

		}

	}



	protected void processRawFactTuples(DataInputStream dis,

												Vector st) throws IOException 

	{

		// Read instances



		int num = dis.readInt();



		EntityClass ec	 = null;

		int			lind = -1;



		for (int i=0; i<num; i++) {

			String eid = (String) st.elementAt(dis.readInt());



			int ind = dis.readInt();



			if (ind != lind) {

				String ecid = (String) st.elementAt(ind);



				ec = (EntityClass) entityClasses.get(ecid);

				lind = ind;

			}



			addEntity(ec, eid);



			if ((i % UPDATE_FREQ) == 0) {

				MsgOut.vprint(".");

				updateProgress();

				ls.showInfo("Entities: " + i);

			}	

		}



		// Read edge tuples



		num = dis.readInt();



		RelationClass crc = (RelationClass) relationClasses.get(CONTAIN_ID);



		RelationClass	rc	   = null;

		int				lrcind = -1;

		

		EntityInstance	e1	   = null;

		int				leind  = -1;	



		for (int i=0; i<num; i++) {

			int rcind = dis.readInt();

			int eind  = dis.readInt();



			if (rcind != lrcind) {

				String rcid = (String) st.elementAt(rcind);



				rc = (RelationClass) relationClasses.get(rcid);

				lrcind = rcind;

			}



			if (eind != leind) {		

				String eid1 = (String) st.elementAt(eind);



				e1 = (EntityInstance) entityInstances.get(eid1);



				leind = eind;

			}

				

			String eid2 = (String) st.elementAt(dis.readInt());



			EntityInstance e2 = (EntityInstance) entityInstances.get(eid2);



			if (rc == crc) {

				// Right now it is contained by root, so

				// remove from root's containment, and

				// make it contained by e1.



				if (m_rootInstance.removeContainment(e2)) {

					e1.addContainment(e2);

				}

			}

			else {

				addEdge(e1, e2, rc);

			}



			if ((i % UPDATE_FREQ) == 0) {

				MsgOut.vprint(".");

				updateProgress();

				ls.showInfo("Relations: " + i);

			}

		}

	}



	protected void processRawFactAttributes(DataInputStream dis,

												Vector st) throws IOException 

	{

		int num = dis.readInt();



		for (int i=0; i<num; i++) {

			String eid = (String) st.elementAt(dis.readInt());



			EntityInstance e = (EntityInstance) entityInstances.get(eid);



			processRawAttributes(e, dis, st);



			if ((i % UPDATE_FREQ) == 0) {

				MsgOut.vprint(".");

				updateProgress();

				ls.showInfo("Attr records: " + i);

			}

		}

	}



	protected void parseRawStream(DataInputStream dis, String src, URL context)

	{

		try {

			String hdr = dis.readUTF();



			if (hdr.equals(RAW_HEADER)) {

				Vector stringTable = readStringTable(dis);



				for (;;) {

					String sec = dis.readUTF();



					if (sec.equals("#END#"))

						break;



					if (sec.equals("#1#")) 

						processRawSchemeTuples(dis, stringTable);

					else if (sec.equals("#2#"))

						processRawSchemeAttributes(dis, stringTable);

					else if (sec.equals("#3#"))

						processRawFactTuples(dis, stringTable);

					else if (sec.equals("#4#"))

						processRawFactAttributes(dis, stringTable);

					else  

						MsgOut.println(src + "- Bad section: " + sec);

				}

			}	

			else {

				resString = "Not a raw TA file";

			}

		}

		catch (Exception e) {

			System.out.println(e);

			resString = e.toString();

		}

	}





	protected boolean isRaw(BufferedInputStream bis) throws IOException {

		bis.mark(100);



		bis.read();

		bis.read();



		for (int i = 0; i<RAW_HEADER.length(); i++) {

			int c = bis.read();



			if (c != RAW_HEADER.charAt(i)) {

				bis.reset();

				return false;

			}

		}



		bis.reset();

		return true;

	}

	protected void computeRelCoordinates()
	{
		if (m_rootInstance != null) {
			m_rootInstance.computeRelCoordinates(m_rootInstance.xRelLocal(), m_rootInstance.yRelLocal(), m_rootInstance.widthRelLocal(), m_rootInstance.heightRelLocal() );
	}	}

	protected void parseStream(InputStream is, String src, URL context) {

		MsgOut.vprintln("Parse TA file: " + src);

		m_uses_local_coordinates = false;

		try {
			BufferedInputStream bis = new BufferedInputStream(is);

			if (isRaw(bis)) {
				DataInputStream dis = new DataInputStream(bis);
				parseRawStream(dis, src, context);
				dis.close();
				bis.close();
				is.close();
				return;
			}

			LandscapeTokenStream ts = new LandscapeTokenStream(bis, src);

			for (;;) {
				int sec = ts.nextSection();

				if (sec == LandscapeTokenStream.EOF) {
					MsgOut.vprintln("");
					break;
				}
				try { 
					switch(sec) {

					case LandscapeTokenStream.SCHEME_TUPLE:

						// regSrcInfo(src, sec);

						schemeSetup = true;
						universalScheme = false;

						processSchemeTuples(ts);
						updateProgress();
						break;



					case LandscapeTokenStream.SCHEME_ATTRIBUTE:

						// regSrcInfo(src, sec);

						if (!schemeSetup) {
							schemeSetup = true;
							setupUniversalScheme();
						}
						processSchemeAttributes(ts);
						updateProgress();
						break;



					case LandscapeTokenStream.FACT_TUPLE:

						// regSrcInfo(src, sec);

						if (!schemeSetup) {
							schemeSetup = true;
							setupUniversalScheme();
						}

						processFactTuples(ts);
						break;



					case LandscapeTokenStream.FACT_ATTRIBUTE:

						// int srcIndex = regSrcInfo(src, sec);

						processFactAttributes(ts);
						break;


					case LandscapeTokenStream.INCLUDE_FILE:

						if (context == null) {
							parseFile(ts.getIncludeFile(), null);
						} else {
							parseURL(ts.getIncludeFile(), context);
						}
						MsgOut.vprintln("Back to TA file: " + src);
						break; 
					}

				}

				catch (IOException e) {

					MsgOut.println("IO error reading landscape"); 
					resString = e.toString();
					break; 
				}
			}

			bis.close(); 
			is.close();

			if (m_uses_local_coordinates) {
				computeRelCoordinates();
			}
		}

		catch (Exception e) {
			resString = e.toString();
		}


	} // end parseStream() 



	protected URL parseURL(String taURL, URL context) {

		progressCount = 0;

		updateProgress();

		try {

			URL lsURL;

			if (context == null) {
				lsURL = new URL(taURL);

			} else {
				lsURL = new URL(context, taURL);
			}

			MsgOut.dprintln("Opening URL: " + taURL);
			InputStream is = lsURL.openStream();
			MsgOut.dprintln("opened");
			parseStream(is, taURL, lsURL);
			return lsURL; 
		}
		catch(Exception e) {
			resString = e.toString();
			return null;
		}
	}


	// Called from diagram.loadDiagram to parse a file or an include within a file

	protected File parseFile(String taFile, File context) {

		progressCount = 0;

		updateProgress();

		try {
			File file;

			if (context == null)
				file = new File(taFile);
			else {
				String dir = getDir(context);

				file = new File(dir, taFile);
			}

			FileInputStream fis = new FileInputStream(file);

			parseStream(fis, taFile, null);
			return file;

		} catch (Exception e) {
			resString = e.toString();
			return null;
		}
	}



	protected void processInternalBuffer(String taFile) {

		InternalBufferStream iis = ls.getInternalBufferStream();



		if (iis == null) {

			resString = "Internal landscape not available";

			return;

		}



		parseRawStream(iis, taFile, null);

		readOnly = true;

	}



	// Non-first order attributes of $ROOT



	protected static final String rootAttributes[] =
		{ SCALE_ID, 
		  RELN_HIDDEN_ID, 
		  EDGEMODE_ID, 
		  NAVLINK_ID, 
		  TOPCLIENTS_ID,
		  WANTCLIENTS_ID,
		  WANTSUPPLIERS_ID,
		  WANTCARDINALS_ID
		};

	private void setRootInstance(EntityInstance rootInstance)
	{
		m_rootInstance = rootInstance;
	}


	// --------------

	// Public methods

	// --------------



	public Diagram() 
	{
		m_xoffset = 0;
		m_yoffset = 0; 
	}


	public Diagram(LandscapeViewerCore ls, boolean makeBackup) 
	{
		m_xoffset = 0;
		m_yoffset = 0; 

		clients	  = new Vector();
		suppliers = new Vector();

		this.ls = ls;

		// Create Diagram for undo storage

		undoDg = new Diagram();

		// Create root entity

		setRootInstance(new BaseEntity(null, ROOT_ID, this));																				// $ROOT
		m_drawRoot	   = m_rootInstance;

		clientCompareFn.setRoot(m_drawRoot);
		supplierCompareFn.setRoot(m_drawRoot);

		entityInstances.put(ROOT_ID, m_rootInstance);

		for (int i = 0; i < rootAttributes.length; i++) {
			m_rootInstance.addAttribute( new Attribute(rootAttributes[i], null));
		}

		AttributeValueItem av = new AttributeValueItem(BG_STR);																			// 0.75

		av.next = new AttributeValueItem(BG_STR);

		av.next.next = new AttributeValueItem(BG_STR);

		m_rootInstance.addAttribute(new Attribute("color", av));																			// $ROOT (0.75 0.75 0.75)

		// Need a navlink attribute on rootInstance

		entityBaseClass = new EntityClass(EntityClass.ENTITY_BASE_CLASS_ID, numEntityClasses++, null, this);							// $ENTITY
		entityClasses.put(EntityClass.ENTITY_BASE_CLASS_ID, entityBaseClass);

		relationBaseClass =	 new RelationClass(RelationClass.RELATION_BASE_CLASS_ID, numRelationClasses++, null /* parent */, this);	// $RELATION
		relationClasses.put(RelationClass.RELATION_BASE_CLASS_ID, relationBaseClass);													// Add to hash table
		numToRel.addElement(relationBaseClass);

		RelationClass rc = new RelationClass(CONTAIN_ID, numRelationClasses++, relationBaseClass, this);								// contain
		relationClasses.put(CONTAIN_ID, rc);																							// Add to hash table
		numToRel.addElement(rc);
	}


	protected Vector bgpaths;


	public void run() {

		Object ncontext;

		Enumeration en = bgpaths.elements();

		while (en.hasMoreElements()) {
			String path = (String) en.nextElement();

			if (Util.isHTTP(path)) {
				ncontext = parseURL(path, (URL) context);
			} else {
				ncontext = parseFile(path, (File) context);
			}
		}
	}


	protected String backgroundLoad(Vector paths) {

		if (paths != null && paths.size() > 0) {
			bgpaths = paths;
			Thread thread = new Thread(this);
			thread.start();
		}
		return null;
	}



	protected void setupOption(int opt, String aname, boolean defState)
	{
		Attribute attr = m_rootInstance.getAttribute(aname);

		if (attr.avi == null) {
			// Use default
			attr.avi = new AttributeValueItem(String.valueOf(defState));
		}
		ls.setGlobalOption(opt, attr.parseBoolean());
	}

	// This logic attempts to assign a layout to any component which lacks layout information

	// Called from landscapeEditorCore.attach()
	// Called from landscapeEditorCore.loadLs()
	// Called from landscapeViewerCore.initialLoad()

	// Returns non-null string on error

	public String loadDiagram(String taPath, Vector bgPaths, Object context) {

		resString = null;
		char lc	  = taPath.charAt(taPath.length()-1);


		if (lc == File.separatorChar) {
			taPath = taPath.substring(0, taPath.length()-1);
		}


		// sourceList = new Vector();

		if (taPath.equals("__internal")) {
			processInternalBuffer(taPath);		
		} else if (context instanceof URL || Util.isHTTP(taPath)) {
			MsgOut.dprintln("Parse a URL");
			this.context = parseURL(taPath, (URL) context);
		} else {
			MsgOut.dprintln("Parse a file");
			this.context = parseFile(taPath, (File) context);
		}

		Attribute attr = m_rootInstance.getAttribute(EDGEMODE_ID);
		if (attr.avi == null) { 
			attr.avi = new AttributeValueItem(String.valueOf(DIRECT_EDGE));
		}

		LandscapeObject.setEdgeMode(attr.parseInt());
		clientCompareFn.setEdgeMode(attr.parseInt());
		supplierCompareFn.setEdgeMode(attr.parseInt());

		setupOption(LandscapeViewerCore.TOP_CLIENTS,    TOPCLIENTS_ID,    true);
		setupOption(LandscapeViewerCore.SHOW_CLIENTS,   WANTCLIENTS_ID,   true);
		setupOption(LandscapeViewerCore.SHOW_SUPPLIERS, WANTSUPPLIERS_ID, true);
		setupOption(LandscapeViewerCore.SHOW_CARDINALS, WANTCARDINALS_ID, false);

		attr = m_rootInstance.getAttribute(RELN_HIDDEN_ID);
		relVisibilityAttr = attr;

		AttributeValueItem avi = attr.avi;

		while(avi != null) {
			RelationClass rc = (RelationClass) relationClasses.get(avi.value);
			rc.setVisibleState(false); 
			avi = avi.next; 
		}

		clients = new Vector();
		suppliers = new Vector();

		dClients = clients;
		dSuppliers = suppliers;

		setVisibilityFlags();

		if (this.context == null) {
			return resString;
		}
		return backgroundLoad(bgPaths);
	}

	// Save the landscape in the output stream

	public void
	saveDiagram(OutputStream os, boolean markEnd) throws IOException
	{

		BufferedOutputStream bos = new BufferedOutputStream(os);



		PrintStream ps = new PrintStream(bos);



		writeSchemeTuples(ps);

		writeSchemeAttributes(ps);

		writeFactTuples(ps);

		writeFactAttributes(ps);



		if (markEnd)

			ps.print("END\n");



		ps.flush();

		ps.close();



		changedFlag = false;

	}



	public void

	saveDiagramRaw(OutputStream os) throws IOException
	{
		BufferedOutputStream bos = new BufferedOutputStream(os);
		DataOutputStream	 dos = new DataOutputStream(bos);

		Hashtable stringHash = new Hashtable();
		Vector	  stringTable = new Vector();
		String str;

		int id = 0;

		Enumeration en = entityClasses.keys();

		while(en.hasMoreElements()) {

			str = (String) en.nextElement();

		

			stringHash.put(str, new Integer(id++));

			stringTable.addElement(str);

		}



		en = relationClasses.keys();



		while(en.hasMoreElements()) {

			str = (String) en.nextElement();

		

			stringHash.put(str, new Integer(id++));

			stringTable.addElement(str);

		}



		en = entityInstances.keys();



		while(en.hasMoreElements()) {

			str = (String) en.nextElement();

		

			stringHash.put(str, new Integer(id++));

			stringTable.addElement(str);

		}



		en = attrNames.keys();



		while(en.hasMoreElements()) {

			str = (String) en.nextElement();

		

			stringHash.put(str, new Integer(id++));

			stringTable.addElement(str);

		}



		dos.writeUTF(RAW_HEADER);



		dos.writeInt(stringTable.size());



		en = stringTable.elements();



		while(en.hasMoreElements()) {

			dos.writeUTF((String) en.nextElement());

		}



		writeSchemeTuplesRaw(dos, stringHash);

		writeSchemeAttributesRaw(dos, stringHash);

		writeFactTuplesRaw(dos, stringHash);

		writeFactAttributesRaw(dos, stringHash);



		dos.writeUTF("#END#");



		dos.flush();

		dos.close();

		bos.close();



		changedFlag = false;

	}



	protected void doSaveForUndo() {

		undoDg.ls = ls;

		undoDg.entityClasses = (Hashtable) entityClasses.clone();

		undoDg.relationClasses	= (Hashtable) relationClasses.clone();

		undoValid = true; 

	}



	public void saveForUndo() 
	{
		changedFlag = true;
		m_rootInstance.saveForUndo();
		doSaveForUndo();
	}



	public void undo() 
	{
		m_rootInstance.undo();
		Diagram undoDg = this.undoDg;
		this.undoDg = new Diagram(); 
		doSaveForUndo();						// Save the undo inverse 
		entityClasses   = undoDg.entityClasses; 
		relationClasses = undoDg.relationClasses; 
	}



	public boolean isUndoAvailable() {

		return undoValid;

	}



	public void saveLayout() {

		m_rootInstance.saveLayout();

	}



	public void restoreLayout() {

		m_rootInstance.restoreLayout();

	}



	public void clearCache() 
	{
		m_rootInstance.clearCache();
	}



	public void processClientSuppliers(Graphics g, Vector v, double csHeight, double ypos, boolean handlingClients)
	{
		double	tw, xpos, scale;
		Enumeration en;
		EntityInstance e;
		Dimension dim;
		Layout lyt;

		tw = calcWidth(g, v, 0);
		
		if (tw <= (m_width - GAP*4)) {
			xpos  = (((double) m_width) - GAP - tw)/2;
			scale = 1.0;
		} else {
			xpos  = GAP;
			// Compress the X axis to make every thing fit
			scale = (((double) m_width) - GAP*4)/tw;
		}
				
		boolean wantCardinals = ls.getOption(LandscapeViewerCore.SHOW_CARDINALS);

		for (en = v.elements(); en.hasMoreElements(); ) {
			e	= (EntityInstance) en.nextElement();
			dim = e.getFitDim(g, EntityInstance.SMALL_FONT, true);
			lyt = e.getLayout();

			lyt.width  = dim.width * scale;
			lyt.height = dim.height;
			lyt.x	   = xpos * scale;
			lyt.y	   = ypos;

			e.setGlobalLayout(lyt);
			e.drawAll(g);
			e.drawLabel(g, EntityInstance.SMALL_FONT, true /* With parent label*/);

			if (!handlingClients && wantCardinals) {
				e.drawCardinals(g);
			}
			xpos += dim.width + GAP;	// Do it this way to avoid rounding errors
		}
	}

	public void sortClients(Vector clients) 
	{
		if (clients.size() > 1 && !clientsSorted) {
			Util.sortVector(clients, clientCompareFn, true);
			clientsSorted = true;
		}
	}

	public void drawClients(Graphics g) 
	{
		if (dClients != null && dClients.size() > 0) {

			Layout lyt = m_drawRoot.getLayout();
			double cHeight = Math.max(CLIENT_SUPPLIER_HEIGHT, m_height - lyt.y - lyt.height - GAP*10);
			sortClients(dClients);
			processClientSuppliers(g, dClients, cHeight, getClientSupplierPos(GAP*3, m_height - cHeight - GAP*3), true);


			if (!allClients) {
				g.setFont(EntityInstance.getSmallFont());

				FontMetrics fm = g.getFontMetrics();

				int h = Util.fontHeight(fm);
				h += h/2;

				g.setColor(Color.black);

				Util.drawStringClipped(g, 
					"Showing only external clients. Siblings and their descendents are not shown.",
					MARGIN, 
					getClientSupplierPos(-h, m_height - cHeight + h),
					m_width-MARGIN*2, h, true, false);
			}

		} else if (clients != null && clients.size() > 0) {

			g.setFont(EntityInstance.getSmallFont());

			FontMetrics fm = g.getFontMetrics();
			int h = Util.fontHeight(fm);
			h += h/2;
			g.setColor(Color.black);
			Util.drawStringClipped(g, "All clients are also suppliers", MARGIN, getClientSupplierPos(GAP, m_height - GAP), m_width-MARGIN*2, h, true, false);
		}
	}



	public void sortSuppliers(Vector suppliers) 
	{
		if (suppliers.size() > 1 && !suppliersSorted) {

			Util.sortVector(suppliers, supplierCompareFn, true);

			suppliersSorted = true;

		}

	}



	public void drawSuppliers(Graphics g) 
	{
		if (dSuppliers != null && dSuppliers.size() > 0) {

			Layout lyt = m_drawRoot.getLayout();

			double sHeight = Math.max(CLIENT_SUPPLIER_HEIGHT, lyt.y - GAP*10);
			sortSuppliers(dSuppliers);

			processClientSuppliers(g, dSuppliers, sHeight, getClientSupplierPos(m_height - sHeight - GAP*2, GAP*2), false);

			if (!allSuppliers) {
				FontMetrics fm = g.getFontMetrics();
				int h = Util.fontHeight(fm);
				h += h/2;

				g.setColor(Color.black);

				Util.drawStringClipped(g, 
					"Showing only external suppliers. Siblings and their descendents are not shown.",
						MARGIN, 
						getClientSupplierPos(m_height - sHeight + h, MARGIN),
						m_width-MARGIN*2, h, true, false);
			}
		}
	}

	/*  Draw a small mark as shown in top left of object

		x---
        |
		|   --------
		|  |        |
		   |        |
		   |        |
	  	   |  ----  |
		   |        |
		   |        |
		   |        |
		   |________|
	*/


	protected void drawExitFlag(Graphics g) 
	{
		g.setColor(boxColour.darker());

		g.drawRect(3, 3, EXIT_FLAG_DIM, EXIT_FLAG_DIM);
		// g.setColor(Color.black);
		g.drawLine(5, 7, 9, 7);
	}

	// Draw the entities, edges, and labels

	protected void doDraw(Graphics g, EntityInstance se, boolean drawSe) 
	{
		Rectangle cr = g.getClipRect();
		Rectangle dr = bounds();

/*		System.out.println("Diagram.doDraw(g," + se + ", " + drawSe + ")" + cr + " " + dr);		// IJD
		java.lang.Thread.dumpStack();
		System.out.println("-----");
*/
		clearCache();

		drawCache = new DrawCache(entityInstances.size(), relationClasses.size());

		timeStamp++;


		/* Draw all the visible objects */

		if (drawSe) {
			// Draw root entity which will handle drawing children
			se.drawAll(g);
		} else {
			// Skip drawing root, but draw children (and recurse from there)
			se.drawChildren(g);
		}

		boolean wantCardinals = ls.getOption(LandscapeViewerCore.SHOW_CARDINALS);

		if (wantCardinals) {
			m_rootInstance.resetCardinals(numRelationClasses);
			se.calcEdgeCardinals(!drawEdges);
		}

		if (m_drawRoot.getParent() != null) {
			drawExitFlag(g);
		}
		drawClients(g);
		drawSuppliers(g);

		if (drawEdges) {
			if (visibleEdges) {
				se.drawEdges(g); 
				if (se != m_drawRoot && se.isOpen()) {
					// Also draw edges that call things in starting entity
					// se.drawDestEdges(g);
				}
			}
		} else {
			se.drawHighlightedEdges(g);
		}

		se.drawLabels(g); 

		if (wantCardinals) {
			se.drawCardinals(g);
		}
	}



	public void draw(Graphics g) 
	{
		doDraw(g, m_drawRoot, true);
	}

	public void draw(Graphics g, EntityInstance e) 
	{
		if (isClient(e)) {
			drawClients(g);
			return;
		}
		if (isSupplier(e)) {
			drawSuppliers(g);
			return;
		}
		doDraw(g, e, true);
	}

	public void rescaleDiagram() 
	{
		m_drawRoot.rescaleChildren();
	}

	// 
	// Generates global coordinates for current scale factor
	//

	public void rescaleDiagram(int x, int y, int width, int height) 
	{
		m_drawRoot.setGlobalLayout(x,y,width,height);
	}


	public boolean isMouseOver(int x, int y) 
	{
		return (x >= 0 && x <= m_width && y >= 0 && y <= m_height);
	}



	public RelationInstance mouseOverEdge(EntityInstance e, int x, int y) 
	{
		if (e == null) {
			return null;	
		}

		if (drawEdges && !visibleEdges) {
			return null;
		}
		return e.getMouseOverEdge(x, y, timeStamp);
	}



	public RelationInstance mouseOverAnyEdge(EntityInstance e, int x, int y) 
	{
		if (e == null) {
			return null;
		}
		return e.getMouseOverEdge(x, y, -1);
	}



	public RelationInstance mouseOverEdge(int x, int y) 
	{
		return mouseOverEdge(m_drawRoot, x, y);
	}



	protected void mouseOverAllEdges(EntityInstance e, int x, int y, Vector v)
	{
		e.getMouseOverAllEdges(x, y, v);

		Enumeration en = e.getChildren();

		while (en.hasMoreElements()) {
			 EntityInstance ce = (EntityInstance) en.nextElement();
			 mouseOverAllEdges(ce, x, y, v);
		}
	}



	public Vector mouseOverAllEdges(int x, int y) 
	{
		Vector v = new Vector();

		mouseOverAllEdges(m_drawRoot, x, y, v);
		return v;
	}



	public EdgePoint mouseOverIO(EntityInstance e, int x, int y) 
	{
		if (drawBends && e != null && e.isOpen()) {

			// Test the entity, and its children
			EdgePoint pt = e.getMouseOverIO(x, y);
			if (pt != null) {
				return pt;
			}

			Enumeration en = e.getChildren();
			while (en.hasMoreElements()) {
				EntityInstance ce = (EntityInstance) en.nextElement();

				pt = ce.getMouseOverIO(x, y);
				if (pt != null) {
					return pt;
				}
			}
		}
		return null;
	}



	public boolean mouseOverEnterExit(EntityInstance e, int x, int y) 
	{
		if (e == null) {
			return false;
		}

		EntityInstance pe = m_drawRoot.getParent();

		if (e == pe) {
			if (x >= 3 && x <= EXIT_FLAG_DIM+3 && y >= 3 && y <= EXIT_FLAG_DIM+3) {
				return true;
			}
		} else if (e.isEnterable() && e.hasChildren() && !e.isOpen()) {

			Layout lyt = e.getLayout();

			if (x >= lyt.x+3 && x <= lyt.x + EXIT_FLAG_DIM+3 &&	y >= lyt.y+3 && y <= lyt.y + EXIT_FLAG_DIM+3) {
				return true;
			}
		}
		return false;
	}

	// Used during parse to collapse bends

	public Bend newBendRel(EntityInstance e, RelationInstance ri, double xRel, double yRel) 
	{
		// See if this bend is already defined
		// Hack: Should be better than a O(n) lookup!!

		Enumeration en;
		Bend		bend;

		for (en = globalBends.elements(); en.hasMoreElements(); ) {
			bend = (Bend) en.nextElement();

			if (bend.e == e && Math.abs(bend.xRelLocal() - xRel) < 0.1 && Math.abs(bend.yRelLocal() - yRel) < 0.1) {
				bend.addRelation(ri);
				return bend;
		}	}

		// Otherwise create new bend

		Bend nbend = new Bend(e, ri, xRel, yRel);
		globalBends.addElement(nbend);
		return nbend;
	}

	public void deleteBend(Bend bend) 
	{
		bend.delete();
	}



	public void moveBend(Bend bend, int x, int y)
	{
		EntityInstance e = mouseOverEx(x, y);

		if (e != null) {
			if (e != bend.e) {
				bend.e.deleteBend(bend);  // Move parent
				bend.e = e;
				e.addBend(bend);
			}
			bend.move(x, y);
		}
	}

	public void deleteEdge(RelationInstance ri)
	{
	
		Enumeration en = ri.getBends();

		if (en != null) {
			while(en.hasMoreElements()) {
				Bend bend = (Bend) en.nextElement();
				bend.e.deleteBend(bend);
			}
		}
		ri.getSrc().removeSrcRelation(ri);
		ri.getDst().removeDstRelation(ri);
	}



	public Bend mouseOverBend(int x, int y) {

		return(m_drawRoot.getMouseOverBend(x, y)); 

	}



	public EntityInstance mouseOverEntity(int x, int y) {

		if (dClients == null) {

			/*[irbull] not sure why this is null, FIXME*/

			return null;

		}

		Enumeration en = dClients.elements();

		EntityInstance over = null;

		while (en.hasMoreElements()) {

			EntityInstance e = (EntityInstance) en.nextElement();

			over = e.getMouseOver(x, y);

			if (over != null) {
				return over;
		}	}

		en = dSuppliers.elements();

		while (en.hasMoreElements()) {
			EntityInstance e = (EntityInstance) en.nextElement();

			over = e.getMouseOver(x, y);

			if (over != null) {
				return over;
		}	}

		return(m_drawRoot.getMouseOver(x, y));
	}



	public EntityInstance mouseOver(int x, int y) {

		EntityInstance e = mouseOverEntity(x, y);



		return (e == m_rootInstance ? null : e); 

	}



	public EntityInstance mouseOver(Point pt) {

		return mouseOver(pt.x, pt.y); 

	}



	public EntityInstance mouseOverEx(int x, int y) {

		if (!isMouseOver(x, y))

			return null;



		EntityInstance e = mouseOverEntity(x, y);



		if (e == null) {

			e = m_drawRoot.getParent();

		}



		return e;

	}



	public EntityInstance mouseOverEx(Point pt) {

		return mouseOverEx(pt.x, pt.y); 

	}

	public EntityInstance intersects(Layout lyt)
	{
		return m_drawRoot.intersects(lyt); 
	}



	public EntityInstance containing(Layout lyt) {

		return m_drawRoot.containing(lyt);

	}



	public Vector setGroupRegion(Layout lyt) { 

		EntityInstance e = m_drawRoot.getMouseOver((int) lyt.x, (int) lyt.y);



		if (e == null)

			return null;



		return e.groupRegion(lyt);

	}



	public boolean zoom(double xfactor, double yfactor) 
	{

		rescaleDiagram(m_drawRoot.x(), m_drawRoot.y(), (int) (m_drawRoot.width() * xfactor), (int) (m_drawRoot.height() * yfactor) );
		return true;
	}

	public void setMode(int mode) 
	{
		this.mode = mode; 
	}


	public void setDrawBends(boolean state) {

		MsgOut.dprintln("Draw bends set to: " + state);

		drawBends = state;

	}



	public boolean isDrawBends() 
	{
		return drawBends;
	}

	public void setEdgeMode(int mode) 
	{
		LandscapeObject.setEdgeMode(mode);
		clientCompareFn.setEdgeMode(mode);
		supplierCompareFn.setEdgeMode(mode);
		Attribute attr = m_rootInstance.getAttribute(EDGEMODE_ID);
		attr.avi = new AttributeValueItem(String.valueOf(mode));
	}

	public int getEdgeMode() 
	{
		return LandscapeObject.getEdgeMode();
	}

	public EntityInstance getRoot() 
	{
		return m_drawRoot; 
	}


	public EntityInstance getTopInstance() 
	{
		return m_rootInstance;
	}

	public int getTop() 
	{
		return m_yoffset;
	} 



	public int getTimeStamp() 
	{
		return timeStamp;
	}



	public boolean excludeReln (RelationClass rc) {

		String id = rc.getId();

		return id.equals(CONTAIN_ID) || id.equals(RelationClass.RELATION_BASE_CLASS_ID);
	}



	public void toggleInElision(EntityInstance e) 
	{
		Enumeration en = enumRelations();

		while(en.hasMoreElements()) {
			RelationClass rc = (RelationClass) en.nextElement(); 

			if (!excludeReln(rc) && rc.isVisible()) {
				e.toggleInElision(rc); 
			}
		}
	}



	public void toggleOutElision(EntityInstance e) {

		Enumeration en = enumRelations();



		while(en.hasMoreElements()) {

			RelationClass rc = (RelationClass) en.nextElement();



			if (!excludeReln(rc) && rc.isVisible())

				e.toggleOutElision(rc);

		}

	}



	public void toggleClientElision(EntityInstance e) {

		Enumeration en = enumRelations();



		while(en.hasMoreElements()) {

			RelationClass rc = (RelationClass) en.nextElement(); 



			if (!excludeReln(rc) && rc.isVisible())

				e.toggleClientElision(rc); 

		}

	}



	public void toggleSupplierElision(EntityInstance e) {

		Enumeration en = enumRelations();



		while(en.hasMoreElements()) {

			RelationClass rc = (RelationClass) en.nextElement();



			if (!excludeReln(rc) && rc.isVisible())

				e.toggleSupplierElision(rc);

		}

	}



	public void toggleInternalElision(EntityInstance e) {

		Enumeration en = enumRelations();



		while(en.hasMoreElements()) {

			RelationClass rc = (RelationClass) en.nextElement();



			if (!excludeReln(rc) && rc.isVisible())

				e.toggleInternalElision(rc);

		}

	}



	public void toggleContainElision(EntityInstance e) {

		MsgOut.dprintln("Toggle contains elision on " + e.getLabel());

		e.toggleInElision(CONTAIN_ID);

	}



	public boolean setContainElision(EntityInstance e, boolean open) {

		if (e.canOpen() && ((e.isOpen() && !open) || (!e.isOpen() && open))) {

			toggleContainElision(e);
			return true;

		}
		return false;
	}



	public void toggleAggElision(EntityInstance e) {

		MsgOut.dprintln("Toggle aggregation elision on " + e.getLabel());

		e.toggleInElision(EntityInstance.AGG_ELISION_ID);

	}



	public void setEdgeActiveState(RelationClass rc, boolean state) {

		rc.setActiveState(state);

	}



	public void setEdgeVisibilityState(RelationClass rc, boolean state) {

		rc.setVisibleState(state);

		

		// List is HIDDEN relations



		if (state)

			relVisibilityAttr.removeFromList(rc.getId());

		else

			relVisibilityAttr.addToList(rc.getId());



		setVisibilityFlags();

	}





	public void toggleEdgeVisibility() {

		Enumeration en = enumRelations();



		while(en.hasMoreElements()) {

			RelationClass rc = (RelationClass) en.nextElement();



			if (!excludeReln(rc) && rc.isVisible()) {

				boolean ns = !rc.isVisible();



				setEdgeVisibilityState(rc, ns);

			}

		}

	}

	/* Never called 2002-06-31 IJD

	public boolean toggleAnnotTabs() 
	{
		m_drawAnnots = !m_drawAnnots;
		return m_drawAnnots;
	}
	
	*/



	public void setForHighlightEdges() 
	{
		drawEdges = false;
	}



	public Vector getHighlightedEdges() 
	{
		Vector v = new Vector();

		m_drawRoot.getHighlightedEdges(v);
		if (v.size() == 0) {
			return null;
		}
		return v;
	}



	public boolean clearFlags() {

		boolean ret;

		keyEntity = null;

		ret = false;
		if (!drawEdges) {
			ret = true;
			drawEdges = true; 
		}
		ret |= m_rootInstance.clearAllFlags();
		return(ret);
	}



	public boolean clearQueryFlags() {

		return(m_rootInstance.clearHighlightFlags());

	}



	public void clearGroupFlags() {

		keyEntity = null;

		drawEdges = true;

		m_rootInstance.clearGroupFlags();

	}



	public boolean toggleQueryPersistence() {

		persistentQuery = !persistentQuery;

		return persistentQuery;

	}



	public boolean getQueryPersistance() {

		return persistentQuery;

	}



	public boolean edgeSrcValid(EntityInstance e) {

/*

		return rc.isValidSrc(e.getEntityClass()); 

*/

		return true;

	}



	public boolean edgeDstValid(EntityInstance e) {

/*

		return rc.isValidDst(e.getEntityClass()); 

*/

		return true;

	}



	public boolean edgePresent(EntityInstance src, EntityInstance dst) {

/*

		return src.isRelationPresent(rc, dst); 

*/

		return false;

	}



	public void setDrawEdges(boolean state) {

		drawEdges = state;

	}



	public void drawCreateEdge(Graphics gc, EntityInstance src, int x, int y) {

		src.drawSegment(gc, x, y); 

	}



	public void addEdge(EntityInstance src, EntityInstance dst, 

						RelationClass rc)

	{

/*

		String key = Util.hashEdge(rc, src, dst);



		if (edges.contains(key))

			return;



		edges.put(key, key);

*/



		RelationInstance ri = 

				rc.newRelation(src, dst, this);



		src.addRelation(ri, dst); 

	}



	public EntityInstance addEntity(String id, String label, String desc, Layout lyt, EntityInstance container,	EntityClass ec, Vector contents)
	{
		Enumeration en;

		EntityInstance e = ec.newEntity(id, this); 
		e.setNid(entityInstances.size());
		entityInstances.put(id, e);

		container.addContainment(e);


		e.setLayout(lyt);
		e.setLabel(label);
		e.setDescription(desc);

		for (en = contents.elements(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();

			Layout clyt = child.getLayout();
			container.removeContainment(child);
			e.addContainment(child);
			child.setLayout(clyt);
		}

		m_rootInstance.rescaleChildren();
		return e;
	} 



	public EntityInstance addEntity(String initId, Layout lyt, EntityInstance container)

	{
		EntityInstance	e;
		EntityClass		parent;

		e = new BaseEntity(defaultEntityClass, initId, this);
		e.setLayout(lyt);
		e.setNid(entityInstances.size());
		entityInstances.put(initId, e);

		EditAttribute.Create(ls, e);
		parent = e.getEntityClass();

		if (parent != null) {
			parent.makeInstanceOfUs(e);
		}
		container.addContainment(e);
		m_rootInstance.rescaleChildren();
		return e;
	} 

	public RelationClass nameToRelationClass(String name) {

		if (relationClasses.containsKey(name)) {

		   return (RelationClass) relationClasses.get(name);

		}



		return null;

	}



	public Enumeration enumRelations() 
	{
		return new OrderedHashTableEnumeration(relationClasses); 
	}



	public int numRelationClasses() 
	{
		return this.numRelationClasses;
	}



	public int numVisibleRelationClasses() 
	{
		return this.numVisibleRelationClasses;
	}



	public RelationClass getContainsClass() 
	{
		return (RelationClass) relationClasses.get(CONTAIN_ID); 
	}



	public Enumeration enumEntityClasses() 
	{
		return new OrderedHashTableEnumeration(entityClasses); 
	}



	public int numEntityClasses() 
	{
		return this.numEntityClasses;
	}



	public Enumeration enumEntities() 
	{
		return entityInstances.elements();
	}



	public void drawEntityOutline(Graphics gc, Layout lyt, EntityInstance e) 
	{
		e.drawOutline(gc, lyt);
	}



	public void drawEntityHighlight(Graphics gc, EntityInstance e) 
	{
		e.drawHighlight(gc);
	}



	public void undrawEntityHighlight(Graphics gc, EntityInstance e) 
	{
		e.undrawHighlight(gc);
	}

	public void drawEdge(Graphics gc, RelationInstance ri) 
	{
		ri.draw(gc);
	}

	public void enter(EntityInstance e) 
	{
		setRootInstance(e);
		m_drawRoot = e;
	}

	public Object getContext() 
	{
		return context;
	}



	public Object setContext(Object context) 
	{
		return this.context = context;
	}



	public String getName() 
	{
		if (context instanceof File) {

			return Util.nameFromPath(((File) context).getPath()); 

		}

		else

			return m_rootInstance.getLabel();

	}



	public String getDir(File file) {

		if (file.isAbsolute()) 

			return file.getParent();



		return (new File(file.getAbsolutePath())).getParent();

	}



	public String getDir() {

		return getDir((File) context);

	}



	public String getAbsolutePath() {

		if (context instanceof File)

			return ((File) context).getAbsolutePath();

		else

			return ((URL) context).toExternalForm();

	}



	public Vector getGroup() {

		Vector grp = new Vector();



		m_rootInstance.getGroup(grp);



		if (grp.isEmpty())

			return null;



		return grp;

	}



	public Layout getGroupBoundingBox() {

		Vector grp = getGroup();



		if (grp == null || grp.isEmpty())

			return null;



		// Determine the bounding box of whole group



		Enumeration enum1 = grp.elements();



		double x1, y1, x2, y2;



		x1 = Double.MAX_VALUE;

		y1 = Double.MAX_VALUE;

		x2 = Double.MIN_VALUE;

		y2 = Double.MIN_VALUE;



		while (enum1.hasMoreElements()) {

			EntityInstance e = (EntityInstance) enum1.nextElement();



			Layout lyt = e.getLayout();



			if (lyt.x < x1) 

				x1 = lyt.x;



			if (lyt.y < y1)

				y1 = lyt.y;



			if (lyt.x + lyt.width > x2)

				x2 = lyt.x + lyt.width;



			if (lyt.y + lyt.height > y2)

				y2 = lyt.y + lyt.height;

		}



		return new Layout(x1, y1, x2-x1, y2-y1);

	}



	public EntityInstance getKeyEntity() {

		return keyEntity;

	}





	public void setKeyEntity(EntityInstance e) {

		if (keyEntity != null) {
			keyEntity.clearGroupKeyFlag();		// Must do this first
			keyEntity.setGroupFlag();
		}
		keyEntity = e;
		keyEntity.setGroupKeyFlag();
		keyEntity.setGroupFlag();

	}



	public Vector getHighlightGroup() {

		Vector grp = new Vector();



		m_drawRoot.getHighlightGroup(grp);



		if (grp.isEmpty())

			return null;



		return grp;

	}



	public void selectEdges(Vector edges) {

		Enumeration en = edges.elements();



		while (en.hasMoreElements()) {

			RelationInstance r = (RelationInstance) en.nextElement();



			r.setHighlightFlag();

			r.setGroupFlag();

		}



		drawEdges = false;

	}



	public boolean isOverGroupRegion(int x, int y) {

		Layout lyt = getGroupBoundingBox();

		if (lyt != null) {
			return lyt.contains(x, y);
		}
		return false;
	}

	public boolean isOverGrabRegion(EntityInstance e, int x, int y) 
	{
		if (e == m_rootInstance) {
			return false;
		}

		ScreenLayout lyt = new ScreenLayout(e.getLayout());

		// If near edge then this is a move event
		int dl = x - lyt.x;
		int dr = lyt.x + lyt.width - x;
		int dt = y - lyt.y;
		int db = lyt.y + lyt.height - y;
		int zw = Math.min(lyt.width / 4, MOVE_ZONE_MAX);
		int zh = Math.min(lyt.height / 4, MOVE_ZONE_MAX);

		if ((dl > 0 && dl < zw) || (dr > 0 && dr < zw) || (dt > 0 && dt < zh) || (db > 0 && db < zh)) {
			return true;
		}
		return false;
	}

	public boolean isOverLabel(EntityInstance e, int x, int y) 
	{
		return false;
	}

	public int getGrid() 
	{
		return gridPixels;
	}

	public void setGrid(int val) 
	{
		gridPixels = val;
	}

	public void flagChanged() {

		changedFlag = true;

	}

	public boolean getChangedFlag()
	{
		return changedFlag;
	}

	public void resetChangedFlag() 
	{
		changedFlag = false;
	}

	public void setToViewport() 
	{
		m_rootInstance.verifyFit();
//		System.out.println("Diagram:setToViewport(" + m_x + "," + m_y + "," + m_width + "," + m_height + ")");
		rescaleDiagram(0, 0, m_width, m_height);
	}

	public void fitTo(EntityInstance e) 
	{
		e.fitTo(true);
		rescaleDiagram();
	}

	public void navigateTo(EntityInstance e) 
	{
		// Make entity take a full footprint in the display.

		int	 mw, mh, yshift, temp;

		clearCache();

		mw    = m_width  - GAP*6;		// Maximum width  of e
		mh	  = m_height - GAP*4;		// Maximum height of e

		m_drawRoot = e;

		yshift     = 0;
		if (e == m_rootInstance) {
			clients    = new Vector();
			suppliers  = new Vector();
			dClients   = clients;
			dSuppliers = suppliers;
		} else {
			findClientsAndSuppliers();
			clientsSorted   = false;
			suppliersSorted = false;
	
			if (clients.size() > 0) {
				if (dClients.size() > 0 || isTopClients()) {
					// we will either show or report not showing at top
					// Reduce height to allow clients
					temp = (CLIENT_SUPPLIER_HEIGHT + GAP*4);
					mh  -= temp;
					if (isTopClients()) {
						yshift = temp; 
			}	}	}

			if (dSuppliers.size() > 0) {			// Reduce height to allow suppliers
				temp = (CLIENT_SUPPLIER_HEIGHT + GAP*4);
				mh  -= temp;
				if (!isTopClients()) {
					yshift = temp; 
		}	}	}

//		System.out.println("Shift=" + yshift + " clients=" + clients.size() + " dClients=" + dClients.size() + " suppliers=" + suppliers.size() + " dsuppliers=" + dSuppliers.size() );

		clearFlags();
		clientCompareFn.setRoot(m_drawRoot);
		supplierCompareFn.setRoot(m_drawRoot);
		rescaleDiagram(GAP*3, GAP*2+yshift, mw, mh);
	}

	public boolean navigateTo(String eid) 
	{
		EntityInstance e = (EntityInstance) entityInstances.get(eid);

		if (e == null) {
			return false;
		}
		navigateTo(e);
		return true;
	}

	public boolean isReadOnly() 
	{
		return readOnly;
	}

	public void setReadOnly()
	{
		readOnly = true;
	}



	public boolean entityExists(String name) 
	{
		EntityInstance e = (EntityInstance) entityInstances.get(name);

		return (e != null);
	}

	public LandscapeViewerCore getLs() 
	{
		return ls;
	}



	public boolean isClient(EntityInstance e) 
	{
		return clients.contains(e);
	}



	public boolean isSupplier(EntityInstance e) 
	{
		return suppliers.contains(e);
	}



	public boolean isClientOrSupplier(EntityInstance e) 
	{
		return (isClient(e) || isSupplier(e));
	}

	public EntityInstance getClient(EntityInstance e) 
	{ 
		if (isClient(e)) {
			return e;
		}


		Enumeration en;

		for (en = clients.elements(); en.hasMoreElements(); ) {

			EntityInstance pe = (EntityInstance) en.nextElement();
			if (pe.descendent(e)) {
				return pe;
		}	}
		return null;
	}



	public EntityInstance getSupplier(EntityInstance e) 
	{		
		if (isSupplier(e)) {
			return e;
		}


		Enumeration en;

		for (en = suppliers.elements(); en.hasMoreElements();) {
			EntityInstance pe = (EntityInstance) en.nextElement();
			if (pe.descendent(e)) {
				return pe;
		}	}
		return null;
	}



	public EntityInstance getClientOrSupplier(EntityInstance e) 
	{
		EntityInstance re;

		re = getClient(e);
		if (re == null) {
			re = getSupplier(e);
		}
		return re;
	}



	public boolean isClientDescendent(EntityInstance e) 
	{
		return (getClient(e) != null);
	}



	public boolean isSupplierDescendent(EntityInstance e) 
	{
		return (getSupplier(e) != null);
	}



	public RelationClass numToRelationClass(int n) 
	{
		return (RelationClass) numToRel.elementAt(n);
	}

	public boolean allowElision() {

		return drawEdges;

	}

	public Enumeration clientsEnumerator() 
	{
		if (clients != null) {
			return(clients.elements());
		}
		return(null);
	}

	public Enumeration suppliersEnumerator() 
	{
		if (suppliers != null) {
			return(suppliers.elements());
		}
		return(null);
	}

	public int getDiagramX()
	{
		return(m_x);
	}

	public int getDiagramY()
	{
		return(m_y);
	}

	public int getDiagramWidth()
	{
		return(m_width);
	}
	
	public int getDiagramHeight()
	{
		return(m_height);
	}

	public Rectangle bounds() 
	{
		return new Rectangle(m_x, m_y, m_width, m_height);
	}

	public void setDiagramX(int x)
	{
		m_x = x;
	}

	public void setDiagramY(int y)
	{
		m_y = y;
	}

	public void setDiagramWidth(int width)
	{
		m_width = width;
	}
	
	public void setDiagramHeight(int height)
	{
		m_height = height;
	}

	public void move(int x, int y) 
	{
		m_x = x;
		m_y = y; 
	}

	public void resize(int width, int height) 
	{
		m_width  = width;
		m_height = height;
	}

	public void reshape(int x, int y, int width, int height) {

		m_x      = x;
		m_y      = y; 
		m_width  = width;
		m_height = height;
	}

}

