package lsedit;

import java.awt.*;
import java.util.*;
import java.io.*;
import java.lang.*;


public class EntityClass extends LandscapeClassObject {


	public static final String ENTITY_BASE_CLASS_ID		= "$ENTITY";

	public static final int ENTITY_STYLE_NONE           = -1;
	public static final int ENTITY_STYLE_3DBOX			= 0;
	public static final int ENTITY_STYLE_2DBOX			= 1;
	public static final int ENTITY_STYLE_FILE			= 2;
	public static final int ENTITY_STYLE_DISK			= 3;
	public static final int ENTITY_STYLE_FOLDER			= 4;
	public static final int ENTITY_STYLE_SOURCEOBJ		= 5;
	public static final int ENTITY_STYLE_CLASS			= 6;
	public static final int ENTITY_STYLE_GROUP			= 7;
	public static final int ENTITY_STYLE_LABELLED_GROUP = 8;

	public static final String[] styleName =
		{ 
				"3D Box", 
				"2D Box", 
				"File", 
				"Disk", 
				"Folder", 
				"Source Object", 
				"Class", 
				"Group", 
				"Labelled Group"
		};

	protected double avg;

	// ----------------
	// Exported methods
	// ----------------

	// Constructor 

	public EntityClass(String id, int nid, EntityClass pec, Diagram dg) {

		this.id = id;
		this.setNid(nid); 
		this.label = id; 
		this.dg = dg;

		addParentClass(pec);

		setStyle(ENTITY_STYLE_3DBOX);
		setObjectColor(Color.blue);		// Fill colour
		setLabelColor(Color.cyan);		// Label colour
	}



	public boolean hasId(String id) {
		return this.id.equals(id);
	}


	public void writeAttributes(PrintStream ps) throws IOException {

		ps.print(qt(id) + " {\n");
		super.writeAttributes(ps);
		ps.print("}\n\n"); 
	}

	public EntityInstance newEntity(String id, Diagram dg) 
	{
		EntityInstance e = new BaseEntity(this, id, dg);
		makeInstanceOfUs(e);
		return e;
	}

	// Accessor functions

	public String addParentClass(EntityClass inherits) {
		return addParentClass(inherits, ENTITY_BASE_CLASS_ID);
	}

	public void setAverage(double average) {
		avg = average;
	}

	public double getAverage() {
		return avg;
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes

	public int getPrimaryAttributeCount()
	{
		return(7);
	}

	public String getAttributeNameAt(int index)
	{
		String	name;

		switch (index) {
		case 0:
			name  = "id";
			break;
		case 1:
			name  = CLASSLABEL_ID;
			break;
		case 2:
			name  = CLASSDESC_ID;
			break;
		case 3:
			name  = CLASSSTYLE_ID;
			break;	
		case 4:
			name  = COLOUR_ID;
			break;
		case 5:
			name  = LABEL_COLOUR_ID;
			break;
		case 6:
			name  = OPEN_COLOUR_ID;
			break;
		default:
			name  = super.getAttributeNameAt(index);
		}
		return(name);
	}

	public Object getAttributeValueAt(int index)
	{
		Object	value;

		switch (index) {
		case 0:
			value = getId();
			break;
		case 1:
			value = label;
			break;
		case 2:
			value = description;
			break;
		case 3:
			value = new Integer(getStyle());
			break;
		case 4:
			value = getObjectColor();
			break;
		case 5:
			value = getLabelColor();
			break;
		case 6:
			value = getObjectColorWhenOpen();
			break;
		default:
			value = super.getAttributeValueAt(index);
		}
		return(value);
	}

	public void setAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case 0:
			setId((String) value);
			break;
		case 1:
			label          = (String) value;
			break;
		case 2:
			description    = (String) value;
			break;
		case 3:
			setStyle(((Integer) value).intValue());
			break;
		case 4:
			setObjectColor((Color) value);
			break;
		case 5:
			setLabelColor((Color) value);
			break;
		case 6:
			setObjectColorWhenOpen((Color) value);
			break;
		default:
			super.setAttributeValueAt(index, value);
	}	}

	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getAttributeTypeAt(int index)
	{
		int		ret;
		
		switch (index) {
		case 0:
		case 1:
			ret = Attribute.STRING_TYPE;
			break;
		case 2:
			ret = Attribute.TEXT_TYPE;
			break;
		case 3:
			ret = Attribute.STYLE_TYPE;
			break;
		case 4:
		case 5:
		case 6:
			ret = Attribute.COLOR_OR_NULL_TYPE;
			break;
		default:
			ret = super.getAttributeTypeAt(index);
		}
		return(ret);
	}
}



