package lsedit;

import java.applet.*;

import java.awt.*;

import java.util.*;



public class Feedback extends MyComponent {



	protected static final Font feedbackFont =

		new Font("Helvetica", Font.PLAIN, 11);



	protected static final int GAP = 5; 



	protected String feedbackStr = null;



	protected void drawFeedback(Graphics g, Rectangle r) {

		if (feedbackStr != null) {

			g.setColor(Color.black);

			g.setFont(feedbackFont);



			Util.drawStringClipped(g, feedbackStr, GAP, GAP/2, r.width-GAP*2, r.height); 

		}

	}



	protected LandscapeViewerCore ls;



	// --------------

	// Public Methods

	// --------------



	public Feedback(LandscapeViewerCore ls) {

		this.ls = ls;

		setBackground(Diagram.boxColour);

		setFont(feedbackFont);

	}

	

	public void paint(Graphics gc) {

		Rectangle r = bounds();



		gc.setColor(getBackground());

		gc.fillRect(0, 0, r.width, r.height);



		Util.drawFrame(gc, r);



		if (feedbackStr != null) 

			drawFeedback(gc, r);

	}



	public void draw(Graphics gc) 
	{
		// Create another with a clipping region over us



		Rectangle r = bounds();



		Graphics ngc = gc.create(r.x, r.y, r.width, r.height);



		paint(ngc);



		ngc.dispose();

	}



	public void repaint() 
	{
		if (isVisible()) {
			Graphics gc = ls.getGraphics();
			draw(gc);
			gc.dispose();
	}	}

	public void set(String str) 
	{
		feedbackStr = str;
		repaint();
	}

	public String get() 
	{
		return(feedbackStr);
	}


}

