package lsedit;

import java.applet.*;

import java.awt.*;

import java.util.*;



public class HelpBox extends Canvas {



	protected static final int GAP = 5; 

	protected static final int HELP_WIDTH = 250; 



	protected static final Color BACKGROUND_COLOUR = 

										new Color(1.0f, 1.0f, 0.85f);



	protected static final Font textFont =

				new Font("Helvetica", Font.PLAIN, 11); 



	protected String text; 



	protected boolean horizFit = false;



	// Protected methods 



	protected void drawText(Graphics g, Rectangle r) {



		// Draw title 



		int xpos = GAP;

		int ypos = GAP;



		// Now lines of text



		String desc = this.text;



		g.setColor(Color.black);

		g.setFont(textFont);



		FontMetrics fm = g.getFontMetrics();



		int h = Util.fontHeight(textFont) - 2;

		ypos += h;



		// Output as many lines as we can of the description within the

		// text box provided by parsing the description for words.



		StringLinizer sl = new StringLinizer(desc, fm, r.width-GAP*2);

		while(sl.hasMoreLines()) {
			String line = sl.nextLine();
			g.drawString(line, xpos, ypos);
			ypos += (h+2);
		}
	}



	protected int countLines(Graphics g, int width) {



		int xpos = GAP;

		int ypos = GAP;



		g.setFont(textFont);



		FontMetrics fm = g.getFontMetrics();



		String desc = this.text;



		StringLinizer sl = new StringLinizer(desc, fm, width);

		int numLines = 0;

		while(sl.hasMoreLines()) {
			String line = sl.nextLine();
			numLines++;
		}
		return numLines;
	}



	protected void setSize(Graphics gc) {

		if (text != null) {

			gc.setFont(textFont);



			FontMetrics fm = gc.getFontMetrics();



			int w = (horizFit ? fm.stringWidth(text) + GAP*2 : HELP_WIDTH);

			int h = Util.fontHeight(textFont);

			int n = countLines(gc, w - GAP*2);



			resize(w, h*n+GAP*2);

		}

	}



	// --------------

	// Public methods 

	// --------------



	public HelpBox() {

		setBackground(BACKGROUND_COLOUR);

		resize(HELP_WIDTH, 5);

		hide();

	}



	public void paint(Graphics gc) {

		setSize(gc);



		Rectangle r = bounds();



		gc.clearRect(0, 0, r.width, r.height);



		gc.setColor(Color.black);		

		gc.drawRect(0, 0, r.width-1, r.height-1);



		if (text != null) {

			drawText(gc, r);

		}

	}



	public void set(String text, boolean horizFit) {

		this.text = text; 

		repaint();

		this.horizFit = horizFit;

	}



	public void set(String text) {

		set(text, false);

	}



}

