package lsedit;

import java.util.*;
import java.io.*;
import java.awt.*;



public abstract class LandscapeClassObject extends LandscapeObject {

	protected Vector inherits = new Vector();							// Set of class's this class inherits from

	protected static final String CLASSLABEL_ID = "class_label";
	protected static final String CLASSSTYLE_ID = "class_style";
	protected static final String CLASSDESC_ID	= "class_description";

	// -----------------
	// Protected methods
	// -----------------

	// Make passed object an instance of this class. Instances obtain copies
	// of the attributes defined for the class. 

	protected void makeInstanceOfUs(LandscapeObject lo) {

		// We employ a clone on write strategy.
		//
		// We can keep references to the parent classes attributes
		// until such time as an override occurs. At that time, 
		// a clone of the attribute object occurs.
		//
		// Since we have an inheritance among TA relation classes
		// we first add the attributes of the TA superclasses which this 
		// inherits from, since child TA classes can override parent values.

		Enumeration en = getParentElements();

		while (en.hasMoreElements()) {
			LandscapeClassObject lco = (LandscapeClassObject) en.nextElement();

			if (lco == null) {
				System.out.println("Internal error: Null inheritance");
				break;
			}
			lco.makeInstanceOfUs(lo);
		}

		// And now this class' attributes

		en = attributes.elements();

		while (en.hasMoreElements()) {
			Attribute attr = (Attribute) en.nextElement();
			if (!attr.id.startsWith("class"))
				lo.addAttribute(attr);
		}
	}

	protected String addParentClass(LandscapeClassObject lco, String baseId) {

		if (lco == null) {
			return ("Can't inherit from null class");
		}

		if (!inherits.contains(lco)) {
			// We should make sure we're
			// not being asked to inherit from an ancestor of something
			// we already inherit from.
			inherits.addElement(lco);
			return null;
		}

		return ("Already inherits from " + lco.id);	   
	}

	protected void saveForUndo(LandscapeClassObject undoObject) {

		undoObject.setNid(getNid());
		super.saveForUndo(undoObject); 
	}

	protected void undo(LandscapeClassObject undoObject) {

		setNid(undoObject.getNid());
		super.undo(undoObject); 
	}



	protected boolean processClassAttributes(Attribute attr) {

		if (attr.id.startsWith("class_")) {

			if (attr.avi != null) {

				if (attr.id.equals(CLASSLABEL_ID)) {

					label = attr.avi.value;

				}

				else if (attr.id.equals(CLASSSTYLE_ID)) {

					setStyle(Util.parseInt(attr.avi.value));

				}

				else if (attr.id.equals(CLASSDESC_ID)) {

					description = attr.avi.value;

				}

				else {

					return false;

				}

			}

			return true;

		}

		return false;

	}



	// --------------

	// Public methods

	// --------------

 
	public LandscapeObject derivedFrom(int i)
	{
		return((i < inherits.size()) ? (LandscapeObject) inherits.elementAt(i) : null);
	}

	// If a new attribute, add it to the attribute database,
	// otherwise merely update the value.

	public void addAttribute(Attribute attr) {

		if (processClassAttributes(attr)) 
			return;

		if (processFirstOrder(attr)) 
			return;

		Attribute curAttr = (Attribute) attributes.get(attr.id);

		if (curAttr == null) {
			// New attribute
			attributes.put(attr.id, attr);
			attr.cloneOnAssign = true;
		} else if (attr.avi != null) {
			// Simply change the value if value present
			curAttr.avi = attr.avi; 
		}
	}

	public boolean addRawAttribute(String id, int val) {

		if (id.equals(CLASSSTYLE_ID)) {

			setStyle(val);

			return true;

		}



		return super.addRawAttribute(id, val);

	}



	public boolean addRawAttribute(String id, double val) {

		return false;

	}



	public boolean addRawAttribute(String id, String val) {

		if (id.equals(CLASSLABEL_ID)) {

			label = val;

			return true;

		}

		else if (id.equals(CLASSDESC_ID)) {

			description = val;

			return true;

		}



		return false;

	}



	// Return the attribute with the associated id



	public Attribute getAttribute(String id) {

		Attribute attr = (Attribute) attributes.get(id);



		if (attr != null)

			return attr;



		Enumeration en = getParentElements();



		while (en.hasMoreElements()) {

			LandscapeClassObject lco = (LandscapeClassObject) en.nextElement();



			attr = lco.getAttribute(id);



			if (attr != null)

				return attr;

		}



		return null;

	}



	public void writeAttributes(PrintStream ps) throws IOException {

		super.writeAttributes(ps, true);

		

		if (!id.equals(label)) {

			ps.print(Attribute.indent + CLASSLABEL_ID + " = " 

						+ qt(label) + "\n");

		}



		ps.print(Attribute.indent + CLASSSTYLE_ID + " = " + getStyle() + "\n");



		if (description != null) {

			ps.print(Attribute.indent + CLASSDESC_ID + " = \"" +

								description + "\"\n");

		}

	}



	public void getAttributesRaw(Vector mv, Hashtable st) {

		Vector v = new Vector();



		super.getAttributesRaw(v, st, true);



		if (!id.equals(label)) {

			regRawAttribute(v, st, CLASSLABEL_ID, label);

		}



		regRawAttribute(v, st, CLASSSTYLE_ID, getStyle());



		if (description != null) {

			regRawAttribute(v, st, CLASSDESC_ID, description);

		}



		Object[] objs = new Object[2];



		objs[0] = st.get(id);

		objs[1] = v;



		mv.addElement(objs);

	}



	public void setColor(Color c) {

		Attribute attr = getAttribute(EntityInstance.COLOUR_ID);

		double r = ((double) c.getRed())/255;
		double g = ((double) c.getGreen())/255;
		double b = ((double) c.getBlue())/255;

		attr.avi.value			 = "" + r;
		attr.avi.next.value		 = "" + g;
		attr.avi.next.next.value = "" + b;
	}



	public boolean inheritsFrom(LandscapeClassObject lco) {
		return inherits.contains(lco);
	}

	public Enumeration getParentElements() {
		return inherits.elements();
	}
}

