package lsedit;
import java.applet.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class LandscapeEditorApp extends LandscapeEditorCore {
	/* Implements the standalone version of the editor */

	protected static final String QUIT_LABEL = "Quit";

	protected Menu optionMenu;

	protected static int openFrames = 1;

	protected static String fileMenuEntries[] =
		{ "Open landscape (^O)",
		  "Save landscape (^S)",
		  "Save landscape (raw)",
		  "Save landscape as",
		  "-",
		  "Save LS as .eps file",
		  // "Print LS book to .eps file",
		  // "Print all LS to .eps files",
		  // "Print app to file",
		  "-",
		  "Close editor (^W)", 
		  QUIT_LABEL
		};

	protected static int fileMenuKeys[] =
		{ CTRL.O, 
		  CTRL.S, 
		  SAVE_RAW, 
		  SAVE_AS, 
		  0, 
		  PRINT_LS,
		 /*PRINT_BOOK,*/ 
//		  PRINT_ALL, 
		  0, 
		  CTRL.W, 
		  0
		};

	protected static String editMenuEntries[] =
		{ "Undo (^Z)",
		  "Refresh (^R)",
		  "-",
		  "Cut group (^X)",
		  "Paste group (^V)",
		  "-",
		  "Grid decrease (g)",
		  "Grid increase (G)",
		  "-",	
		  "Clear current query/group (ESC)",
		  "Find entities (^F)"
		};

	protected static int editMenuKeys[] =
		{ CTRL.Z, CTRL.R, 0,
		  CTRL.X, CTRL.V, 0,
		  'g', 'G', 0,
		  CTRL.ESC, CTRL.F, 0
		};

	protected static String optionMenuEntries[] =
		{ 
		  // "Query persistence",
		  "Viewer mode on/off (V)",
		  "-",
		  "Inflection point edge",
		  "Top/Bottom edge",
		  "Direct edge",
		  "-",
		  "Clients at top",
		  "-",
		  "Show clients",
		  "Show suppliers",
		  "Show edge cardinals",
		  "-",
		  "Show descriptions",
		  "Show feedback",
		  "Show right box",
		  "Show animation",
		  // "Show TOC box",
		}; 

	protected static int optionMenuKeys[] =
		// { QUERY_PERSIST, 'V', 0,
		{ 'V', 0,
		  Diagram.BEST_EDGE+EDGE_BASE, Diagram.TB_EDGE+EDGE_BASE,
		  Diagram.DIRECT_EDGE+EDGE_BASE, 0,
		  TOP_CLIENTS, 0,
		  SHOW_CLIENTS, SHOW_SUPPLIERS, SHOW_CARDINALS, 0,
		  SHOW_DESC, SHOW_FB, SHOW_RIGHT, SHOW_ANIMATE
		};

	protected static boolean optionMenuStates[] =
		// { false, false, false,
		{ false, false,
		  true, false, false, false,	  // mutex
		  true, false, 
		  true, true, false, false,
		  true, true, true, false
		};

	protected static String arrangeMenuEntries[] = 
		{
		  "Align (top/horiz.)",
		  "Align (center/horiz.)",
		  "Align (left/vertical)",
		  "Align (right/vertical)",
		  "Align (center/vertical)",
		  "-",
		  "Same size",
		  "Same width",
		  "Same height",
		  "-",
		  "Equal spacing (horiz.)",
		  "Equal spacing (vertical)",
		  "Fit to label",
		  "-",
		  "Fit children to parent",
		  "Put group in container",
		};

	protected static int arrangeMenuKeys[] =
		{
		 A_HORIZ_TOP, A_HORIZ_CENTER, 
		 A_VERTICAL_LEFT, A_VERTICAL_RIGHT, A_VERTICAL_CENTER, 0,
		 SZ_WIDTH_HEIGHT, SZ_WIDTH, SZ_HEIGHT, 0,
		 SPC_HORIZ, SPC_VERTICAL, A_FIT_LABEL, 0,
		 A_FIT, A_GROUP, 0,
		};

	protected static String helpMenuEntries[] =
		{ 
		  "About Landscape Editor",
		  "-",
		  "Show legend (l)",
		};

	protected static int helpMenuKeys[] =
		{ ABOUT_HELP, 0, 
		  'l'
		};

	protected Dimension getViewDimensions() {
		Rectangle ap = af.bounds();
		Rectangle ag = bounds();

		return new Dimension(ap.width-GAP*2, ap.height-GAP*3-ag.y);
	}

	protected void genMenuButtons() {
		// Empty since we use real menus in app
	}

	// Overrides LandscapeEditorCore.genGUI()
	protected void genGUI() {
		MsgOut.dprintln("App: gen GUI");

		genModeHandlers();

		genDropDowns();
		genMainGUI();

		this.validate();
		this.setLayout(null);
		
		layoutGUI();
	}

	protected void layoutGUI() {

		super.layoutGUI();
	}

	protected void setMenuCheck(int key, boolean state) {
		for (int i = 0; i<optionMenuKeys.length; i++) {
			if (optionMenuKeys[i] == key) {
				CheckboxMenuItem mi = (CheckboxMenuItem) optionMenu.getItem(i);
				mi.setState(state);
				return;
			}
		}
	}

	protected boolean testForClose() {
		if (!dg.getChangedFlag())
			return true;

		System.out.print("\007");

		int rc = OkNoCanBox.Create(this, "Landscape Changed",
					 "Landscape has been changed.\nShould it be saved?");

		switch(rc)
		{
		case OkNoCanBox.OK:
			saveLs();
			// Drop through

		case OkNoCanBox.NO:
			return true;
		}

		return false;
	}

	/*
	 * Public methods
	 */

	public MenuBar genMenu() { 
		MenuBar mb = new MenuBar();

		Menu m = new Menu("File");
		MenuItem mi;
		CheckboxMenuItem cmi;

		for (int i = 0; i<fileMenuEntries.length; i++) {
			mi = new MenuItem(fileMenuEntries[i]);
			m.add(mi);
		}

		mb.add(m);

		m = new Menu("Edit");

		for (int i = 0; i<editMenuEntries.length; i++) {
			mi = new MenuItem(editMenuEntries[i]);
			m.add(mi);
		}

		mb.add(m);

		m = new Menu("Arrange");

		for (int i = 0; i<arrangeMenuEntries.length; i++) {
			mi = new MenuItem(arrangeMenuEntries[i]);
			m.add(mi);
		}

		mb.add(m);


		m = new Menu("Layout");

		layoutManager.setMenu(m);
		
		mb.add(m);


		m = new Menu("Options");

		for (int i = 0; i<optionMenuEntries.length; i++) {
			cmi = new CheckboxMenuItem(optionMenuEntries[i]);
			if (optionMenuStates[i])
				cmi.setState(true);
			m.add(cmi);
		}

		mb.add(m);
		optionMenu = m;

		m = new Menu("Help");

		for (int i = 0; i<helpMenuEntries.length; i++) {
			mi = new MenuItem(helpMenuEntries[i]);
			m.add(mi);
		}

		mb.add(m);

		return mb;
	}

	// Overrides LandscapeEditorCore.processKey() 
	public boolean processKey(int key, int modifiers) 
	{
		if (super.processKey(key, modifiers))
			return true; 

		switch(key)
		{
		case CTRL.W:
			if (!testForClose())
				return true;

			if (openFrames == 1)
				System.exit(0);
			else {
				Container c = this; 

				do { 
					c = c.getParent(); 
				} while (!(c instanceof Frame)); 

				Frame f = (Frame) c;

				f.hide();
				f.dispose();
		
				openFrames--;
			}
			return true;
		}
		return false;
	}

	public boolean action(Event ev, Object arg) {
		if (ev.target instanceof MenuItem) {
			// Handle real menu selections here
			MenuItem mi = (MenuItem) ev.target;
			String label = mi.getLabel();

			if (label.equals(QUIT_LABEL) && testForClose()) 
				System.exit(0);

			for (int i = 0; i<fileMenuEntries.length; i++) {
				if (label.equals(fileMenuEntries[i]))
					return processKey(fileMenuKeys[i], ev.modifiers);
			}

			for (int i = 0; i<editMenuEntries.length; i++) {
				if (label.equals(editMenuEntries[i]))
					return processKey(editMenuKeys[i], ev.modifiers);
			}

			for (int i = 0; i<arrangeMenuEntries.length; i++) {
				if (label.equals(arrangeMenuEntries[i]))
					return processKey(arrangeMenuKeys[i], ev.modifiers);
			}

			int ind = layoutManager.getMenuIndex(label);

			if (ind >= 0) {
				doLayout(ind);
				return true;
			}

			for (int i = 0; i<optionMenuEntries.length; i++) {
				if (label.equals(optionMenuEntries[i]))
					return processKey(optionMenuKeys[i], ev.modifiers);
			}

			for (int i = 0; i<helpMenuEntries.length; i++) {
				if (label.equals(helpMenuEntries[i]))
					return processKey(helpMenuKeys[i], ev.modifiers);
			}
		}
		return super.action(ev, arg);
	}

	public void followLink(String file, int target) {
		System.out.println("followLink: " + target);

		if (target == LsLink.TARGET_NEW) {
			LandscapeEditorApp ap = new LandscapeEditorApp();

			ap.lsPath = file;
			ap.tocOn = tocOn;
 
			LandscapeEditorFrame af = LandscapeEditorFrame.create(ap);
			openFrames++;
		}
		else if (target == LsLink.TARGET_APP) {
			super.followLink(file, target);
		}
		else {
			attach(file);
		}
	}

	public String getParameter(String name) {
		return System.getProperty(name);
	}

	protected void doSetCursor(int cursor) {
		af.setCursor(cursor);
	}
}
