package lsedit;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;
import javax.swing.JFrame;

/*
	main() 
		creates instance of applet
		parses arguments
		calls create()
			new LandscapeEditorFrame(...)
*/

class LandscapeEditorFrame extends JFrame implements WindowListener
{

	protected static final String title = "Software Landscape Editor";

	protected static final int MAX_WIDTH  = 1280;
	protected static final int MAX_HEIGHT = 1024;

	protected boolean appFrameInitialized = false;

	protected LandscapeEditorApp applet;

	protected static Dimension editorDim = null;			// Set by -g option
	protected static Dimension diagDim = null;				// Set by -G option

	protected static boolean landscapeGeo = false;			// Set by -L option
	protected static boolean startInViewerMode = false;		// Set by -V option (but not used?)

	public LandscapeEditorFrame(LandscapeEditorApp applet, int width, int height) 
	{
		super(title);

		this.applet = applet;

		addWindowListener(this);				// Want to be able to detect x pressed in Top RH corner
		this.getContentPane().setLayout(null);	// There is no layout manager?

		MenuBar mb = applet.genMenu();

		this.setMenuBar(mb);
		this.setBackground(Color.lightGray);

		this.getContentPane().add(applet);

		this.resize(width, height); 
		this.show();

		MsgOut.dprintln("App: " + bounds());

		applet.init_app(this, diagDim);
		applet.start();
		appFrameInitialized = true;		// Ignore all events to frame until reach this point
	}

	public boolean handleEvent(Event ev) {
		if (!appFrameInitialized) {
			return false;
		}
		return applet.handleEvent(ev);
	}

	// Returns the dimensions for input of form <x>x<y>

	protected static Dimension parseDim(String geo) {
		int ind = geo.indexOf('x');

		if (ind > 0) {
			try {
				int w = Util.parseInt(geo.substring(0, ind));
				int h = Util.parseInt(geo.substring(ind+1));

				return new Dimension(w, h);
			}
			catch (Exception e) {
			}
		}
		return null;
	}

	protected static void usage() 
	{
		System.out.println("\nLandscape Editor " + Version.MAJOR + "." + Version.MINOR + "." + Version.BUILD + "\n");
		System.out.println("<executor> LandscapeEditorFrame [options] <HTTP or file path>\n");
		System.out.println("-h	 This message");
		System.out.println("-t	 Activate with TOC");
		System.out.println("-v	 Verbose parsing output");
		System.out.println("");

		System.out.println("-g<width>x<height> Geometry of editor");
		System.out.println("-G<width>x<height> Geometry of diagram");
		System.out.println("");
  
		System.out.println("-L	 Start with landscape geometry");
		System.out.println("-V	 Start in viewer mode");
		System.out.println("");

		System.out.println("-P <path>  Optional save path");
		System.out.println("-S <path>  Optional save suffix");
		System.out.println("-X <path>  Optional app to exec on save");
		System.out.println("");
	}

	public static LandscapeEditorFrame create(LandscapeEditorApp applet) {
		int w, h;

		if (editorDim != null) {
			w = editorDim.width;
			h = editorDim.height;
		}
		else {
			Toolkit tk = Toolkit.getDefaultToolkit();

			Dimension dim = tk.getScreenSize();

			double f = 0.75;

			if (landscapeGeo) {
				w = Math.min(MAX_WIDTH, dim.width);
				h = Math.min(MAX_HEIGHT, dim.height);
			}
			else {
				h = dim.height-50;
				w = (int) (dim.width/f);

				if (applet.tocOn)
					w += 200;
			}

			w = Math.min(w, dim.width);
			h = Math.min(h, dim.height);
		}

		return new LandscapeEditorFrame(applet, w, h);
	}

	public static void main(String args[]) 
	{
		LandscapeEditorApp applet = new LandscapeEditorApp();

		int n = 0;

			MsgOut.setVerboseFlag(false); 
			MsgOut.setDebugFlag(false);
		// Process command line switches
		while(n < args.length && args[n].charAt(0) == '-') {
			int len = args[n].length();


			for (int i = 1; i < len; i++) {
				char c = args[n].charAt(i);

				switch(c)
				{
				case 'd':
					// Turn on debugging output 
					MsgOut.setDebugFlag(true);
					MsgOut.dprintln("Start app: " + System.getProperty("java.version"));
					if (i < len-1 && args[n].charAt(i+1) == 'd') {
						LandscapeTokenStream.setDebugOn();
						i++;
					}
					break; 

				case 'h':
					// Show usage info
					usage();
					System.exit(0);
					break;

				case 't':
					applet.tocOn = true;
					break;

				case 'v':
					// Turn on verbose parsing output 
					MsgOut.setVerboseFlag(true); 
					break;

				case 'g':
					editorDim = parseDim(args[n].substring(i+1));
					i = len;
					break;

				case 'G':
					diagDim = parseDim(args[n].substring(i+1));
					i = len;
					break;

				case 'L':
					landscapeGeo = true;
					break;

				case 'N':
					n++;
					if (n == args.length) {
						System.out.println("\nInvalid use of -N");
						usage();
						System.exit(0);
					}

					applet.startEntity = args[n];
					i = len;	
					break;

				case 'V':
					startInViewerMode = true;
					break;

				case 'P':
					n++;
					if (n == args.length) {
						System.out.println("\nInvalid use of -P");
						usage();
						System.exit(0);
					}

					applet.lsSavePath = args[n];
					i = len;	
					break;

				case 'S':
					n++;
					if (n == args.length) {
						System.out.println("\nInvalid use of -S");
						usage();
						System.exit(0);
					}

					applet.lsSaveSuffix = args[n];
					i = len;	
					break;
		
		
				case 'X':
					n++;
					if (n == args.length) {
						System.out.println("\nInvalid use of -X");
						usage();
						System.exit(0);
					}

					applet.lsSaveCmd = args[n];
					i = len;
					break;
				}
			}
			n++;
		}

		// Process command line args
		if (n == args.length) {
			applet.lsPath = null;
		}
		else {
			applet.lsPath = args[n++];
		}

		while (n < args.length) {
			applet.lsPath_bg.addElement(args[n++]);
		}

		LandscapeEditorFrame af = create(applet);

		MsgOut.dprintln("exit main");
	}

	// Window Listener implementation follows

	public void windowOpened(WindowEvent evt) {
	}

	public void windowActivated(WindowEvent evt) {
	}

	public void windowClosed(WindowEvent evt) {
	}

	public void windowClosing(WindowEvent evt) {

		removeWindowListener(this);
		dispose();

	}

	public void windowDeactivated(WindowEvent evt) {
	}

	public void windowDeiconified(WindowEvent evt) {
	}

	public void windowIconified(WindowEvent evt) {
	}
}
