package lsedit;

import java.applet.*;

import java.awt.*;



public abstract class LsPopupMenu extends Canvas {



	public final static int MARGIN = 4; 


	public final static Color backGroundColor = Color.lightGray;
	public final static Color textColor		  = Color.black;
	public final static Color textGrayedColor = Color.gray; 

	protected final static String FONT_NAME = "Dialog";
	protected final static int	  FONT_SIZE = 10;

	public final static Font font = new Font(FONT_NAME, Font.PLAIN, FONT_SIZE);

	protected final static int X_OFFSET = 10;
	protected final static int Y_OFFSET = 5;
	protected final static int NONE = -1;

	protected Applet applet; 
	protected int entries, fontHeight;

	protected LsPopupMenuItem currentItem = null;		// Currently over
	protected LsPopupMenuItem firstItem;				// Chain 

	protected int maxWidthLeft = 0; 
	protected int maxWidthRight = 0; 

	protected void setupMaxWidthCalc() {
		maxWidthLeft = 0;
		maxWidthRight = 0;
	}

	protected void calcMaxWidth(String str, FontMetrics fm) {
		int ind = str.indexOf("\t");

		if (ind >= 0) {
			maxWidthLeft = Math.max(fm.stringWidth(str.substring(0, ind)), maxWidthLeft);
			maxWidthRight = Math.max(fm.stringWidth(str.substring(ind)), maxWidthRight); 
		}
		else
			maxWidthLeft = Math.max(fm.stringWidth(str), maxWidthLeft); 
	}

	protected int getMaxWidth() {
		if (maxWidthRight > 0)
			return maxWidthLeft + maxWidthRight + 5 + MARGIN*4; 
		else
			return maxWidthLeft + MARGIN*4;
	}

	protected LsPopupMenuItem overItem(int x, int y) {
		Rectangle pr = bounds();

		if (x < pr.x || x > pr.x + pr.width ||	
			y < pr.y || y > pr.y + pr.height) 
		{
			// Outside of the menu rectangle

			return null;
		}

		LsPopupMenuItem item = firstItem;

		while (item != null && !item.isOver(x-pr.x, y-pr.y))
			item = item.next;

		return item;
	}

	// Display the popup menu

	protected void popup(int width, int height, int x, int y) {
		resize(width, height);
		move(x, y);
		show();
	}

   
	// --------------
	// Public methods
	// --------------


	public void paint(Graphics g) { 

		Rectangle pr = bounds();

		g.setColor(backGroundColor);
		g.fill3DRect(1, 1, pr.width-2, pr.height-2, true);
		g.setColor(Color.black);
		g.drawRect(0, 0, pr.width-1, pr.height-1);

		LsPopupMenuItem item = firstItem;

		while (item != null) {
			item.drawNormal(g, 0, 0);
			item = item.next;
		}
	}

	public void trackMotion(int x, int y) {

		Rectangle r = bounds();

		LsPopupMenuItem item = overItem(x, y);

		if (currentItem == item) {
			return;
		}

		Graphics g = this.getGraphics();

		if (currentItem != null && currentItem.isHighlightable()) {
			currentItem.drawNormal(g, 0, 0);
		}

		currentItem = item;

		if (item != null && item.isHighlightable()) {
			item.drawHighlighted(g, 0, 0);
		}

		g.dispose();
	}

	public boolean mouseDrag(Event ev, int x, int y) {

		trackMotion(x, y);
		return true;
	}


	public boolean mouseUp(Event ev, int x, int y) {
		// Let parent handle event
		currentItem = null;
		return false;
	}

}

