package lsedit;

import java.awt.*;



public class LsPopupMenuItem {



	public LsPopupMenuItem next;



	Rectangle rect;

	String	  label; 

	String	  link;

	boolean	  grayed; 

	String	  target; 



	protected void drawString(Graphics g, int xpos, int ypos) {

		int ind = label.indexOf("\t");



		if (ind >= 0) {

			g.drawString(label.substring(0, ind), xpos+rect.x+2,

								ypos+rect.y + rect.height-LsPopupMenu.MARGIN);



			FontMetrics fm = g.getFontMetrics();



			int w = fm.stringWidth(label.substring(ind));



			g.drawString(label.substring(ind+1), xpos+rect.x+rect.width-w-8,

								ypos+rect.y + rect.height-LsPopupMenu.MARGIN);

		}

		else {

			g.drawString(label, xpos+rect.x+2,

						ypos+rect.y + rect.height-LsPopupMenu.MARGIN);

		}

	}



	public LsPopupMenuItem(String label, String link, boolean grayed, 

								int x, int y, int width, int height) 

	{

		this.label = label;

		this.link = link; 

		this.grayed = grayed; 

		rect = new Rectangle(x+LsPopupMenu.MARGIN, y+2, width-LsPopupMenu.MARGIN*2, height-4);

	}



	public LsPopupMenuItem(String label, String link, String target, boolean grayed, int x, int y, int width, int height)

	{

		this.label = label;

		this.link = link;

		this.grayed = grayed;

		this.target = target;

		rect = new Rectangle(x+LsPopupMenu.MARGIN, y+2,	width-LsPopupMenu.MARGIN*2, height-4);

	}	



	public void drawNormal(Graphics g, int xpos, int ypos) { 

		g.setColor(LsPopupMenu.backGroundColor); 

		g.fillRect(rect.x+xpos, rect.y+ypos, rect.width, rect.height);

		g.setFont(LsPopupMenu.font);

		if (label.equals("-")) {

			int y = ypos + rect.y + rect.height/2; 



			g.setColor(Color.gray);	   

			g.drawLine(xpos + rect.x+2, y, xpos+rect.x+rect.width-4, y);

			g.setColor(Color.white);

			g.drawLine(xpos + rect.x+2, y+1, xpos+rect.x+rect.width-4, y+1);

		}

		else {

			if (grayed)

				g.setColor(LsPopupMenu.textGrayedColor);

			else

				g.setColor(LsPopupMenu.textColor);

			drawString(g, xpos, ypos);		  

		}

	}



	public void drawHighlighted(Graphics g, int xpos, int ypos) {

		g.setColor(LsPopupMenu.backGroundColor);

		g.fill3DRect(xpos+rect.x, ypos+rect.y, rect.width, rect.height, true);

		g.setFont(LsPopupMenu.font);

		g.setColor(LsPopupMenu.textColor);	

		drawString(g, xpos, ypos); 

	}



	public boolean isOver(int x, int y) {

		return (x >= rect.x && x <= rect.x + rect.width && 

				 y >= rect.y && y <= rect.y + rect.height);

	}



	public boolean isHighlightable() {

		return (!grayed && link.length() > 0); 

	}

}

