package lsedit;

import java.awt.*;



public class OkNoCanBox extends Dialog {



	public static final int OK = 0;

	public static final int NO = 1;

	public static final int CANCEL = 2;



	protected Button okButton, noButton, canButton;

	protected MultiLineLabel label;



	protected static int rc = -1;



	public OkNoCanBox(Frame f, String title, String message)

	{

		// Create a dialog 

		super(f, title, true);



		// Create and use a BorderLayout manager with specified margins

		this.setLayout(new BorderLayout(15, 15));

		

		// Create the message component and add it to the window

		label = new MultiLineLabel(message, 20, 20);

		this.add("Center", label);

		

		// Create an Okay button in a Panel; add the Panel to the window

		// Use a FlowLayout to center the button and give it margins.

		okButton = new Button("OK");

		Panel p = new Panel();

		p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));

		p.add(okButton);

		this.add("South", p);



		noButton = new Button("No");

		p.add(noButton);

		this.add("South", p);



		canButton = new Button("Cancel");

		p.add(canButton);

		this.add("South", p);



		// Resize the window to the preferred size of its components

		this.pack();

	}



	

	// Pop down the window when the button is clicked.

	public boolean action(Event e, Object arg)

	{

		if (e.target == okButton) {

			rc = OK;

		}

		else if (e.target == noButton) {

			rc = NO;

		}

		else if (e.target == canButton) {

			rc = CANCEL;

		}



		if (rc != -1) {

			this.hide();

			this.dispose();

			return true;

		}



		return false;

	}



	public static int Create(Panel p, String title, String message) {

		Container c = p; 



		do { 

			c = c.getParent(); 

		} while (!(c instanceof Frame)); 



		rc = -1;

			

		OkNoCanBox mb = new OkNoCanBox((Frame) c, title, message);

		mb.move(20, 20);

		mb.show();



		return rc;

	}

}

