package lsedit;

import java.applet.*;

import java.awt.*;

import java.util.*;



public class QueryBox extends TabbedBox {



	protected static final int CB_WD = 15;

	protected static final int CB_HT = 15;

	protected static final int WIDTH = 20;

	protected static final int HEIGHT = 20;



	protected static final Font textFont =

				new Font("Helvetica", Font.PLAIN, 11); 



	protected static final String endRelMsg1 =

		"Checkboxes select active relations.";



	protected static final String endRelMsg2 =

		"Click relation arrow for description.";



	protected static final String helpStr =	"This box shows the relations which are active during queries";



	protected static final int MAX_NUM_CHECKS = 20;



	protected Checkbox	 grpChk;

	protected Checkbox[] relnChk = new Checkbox[MAX_NUM_CHECKS];

	protected RelationClass[] relnClass = new RelationClass[MAX_NUM_CHECKS];



	protected Vector objects;



	protected void drawContents(Diagram dg, Graphics g, boolean fullInfo) {

		Rectangle r = bounds();



		int xpos = GAP;

		int ypos = -scrollBar.getValue();

		int iypos = ypos;



		g.setFont(textFont);



		FontMetrics fm = g.getFontMetrics();

		int h = Util.fontHeight(textFont); // Util.fontHeight(fm);



		ypos += h+5;



		int bw = h*3/2;

		int tw = r.width-bw-GAP*3;



		g.setColor(Color.black);

		g.drawString("Relations", xpos, ypos+h);

		ypos += h+3;

		g.drawLine(xpos, ypos, xpos+fm.stringWidth("Relations"), ypos);

		ypos += h;



		// Draw legend for relations



		Enumeration en = dg.enumRelations();



		int n = 0;

		int item = 0;



		objects = new Vector();



		while(en.hasMoreElements()) {

			RelationClass rc = (RelationClass) en.nextElement();



			String id = rc.getId();

			String label = rc.getLabel();



			if (!dg.excludeReln(rc)) {

				String str = label + " (" + (n+1) + ")";



				if (true /* item >= itemNo && item < vitem */) {



					Attribute attr = rc.getAttribute(EntityInstance.COLOUR_ID);

					if (attr != null)
						g.setColor(attr.parseColor());
					else
						g.setColor(Color.black); 

					int x1 = xpos + CB_WD + GAP;

					int y1 = ypos+HEIGHT/2;

					int x2 = x1+WIDTH;

					int y2 = y1;



					Rectangle rect = new Rectangle(r.x + xpos + CB_WD + GAP, r.y + ypos, WIDTH, HEIGHT);

				 

					relnClass[n] = rc; 

					relnChk[n].resize(CB_WD, CB_HT); 

					relnChk[n].move(r.x + xpos + GAP, 

						r.y + ypos + tabDim.height + GAP + 3);

					relnChk[n].show();

					relnChk[n].setState(rc.isActive());



					objects.addElement(new LegendObject(rect, rc));



					RealPoint p1 = new RealPoint(x1, y1); 

					RealPoint p2 = new RealPoint(x2, y2); 



					Util.drawArrow(g, p1, p2);



					g.setColor(Color.black);

					Util.drawStringClipped(g, str, x1+WIDTH+GAP, ypos, 

												tw, h);

					ypos += h+GAP;

				}

				item++;

				n++;

			}

		}



		for (int i=n; i<MAX_NUM_CHECKS; i++) {

			relnChk[i].hide();

			relnClass[i] = null;

		}



		if (n == 0) {

			g.setColor(Color.black);



			int x1 = xpos;

			int y1 = ypos+HEIGHT/2;

			int x2 = xpos+WIDTH;

			int y2 = ypos+HEIGHT/2;



			RealPoint p1 = new RealPoint(x1, y1);

			RealPoint p2 = new RealPoint(x2, y2);



			Util.drawArrow(g, p1, p2);



			g.setColor(Color.black);

			Util.drawStringClipped(g, "Relation", xpos+WIDTH+GAP, ypos, tw, h);



			ypos += h+GAP;



			item++;

		}



		if (fullInfo) {

			ypos += (h + h/2);



			Util.drawStringClipped(g, endRelMsg1, xpos, ypos, tw, h);



			ypos += h;



			Util.drawStringClipped(g, endRelMsg2, xpos, ypos, tw, h);



			ypos += h*2;



			grpChk.resize(CB_WD, CB_HT); 

			grpChk.move(r.x + xpos + GAP, r.y + tabDim.height + ypos + GAP + 3);



			grpChk.show();



			Util.drawStringClipped(g, "Group with queries", xpos+WIDTH+GAP, ypos, tw, h);

		}



		setupScrolling(ypos-iypos);

	}





	protected void genChecks() {

		for (int i=0; i<MAX_NUM_CHECKS; i++) {

			relnChk[i] = new Checkbox();

			relnChk[i].hide();

			ls.add(relnChk[i]);

		}



		grpChk = new Checkbox();

		grpChk.hide();

		ls.add(grpChk);

	}



	protected void grpStateInfo() {

		ls.doFeedback("Entities " + (grpChk.getState() ? "are" : "aren't") + " grouped with queries");

	}

		



	// --------------

	// Public methods 

	// --------------



	public QueryBox(LandscapeViewerCore ls) {

		super(ls, "Queries", 88);

		genChecks();

	}



	public boolean mouseMotion(Event ev, int x, int y) {

		Enumeration en = objects.elements();



		while (en.hasMoreElements()) {

			LegendObject lo = (LegendObject) en.nextElement();
			Rectangle	 r;

			r = lo.getRectangle();
			if (x >= r.x && x <= r.x + r.width && y >= r.y && y <= r.y + r.height) {
				String description = lo.getDescription();
				if (description != null) {
					ls.setHelpPopup(lo.getDescription(), x, y);
					return true;
				}
			}
		}

		// Otherwise, display the general help

		ls.setHelpPopup(helpStr, x, y);
		return true;
	}



	public boolean handleEvent(Diagram dg, Graphics gc, Event event) {

		if (!isVisible())

			return false;



		if (super.handleEvent(dg, gc, event))

			return true;



		if (event.target == grpChk) {

			if (event.id == Event.ACTION_EVENT) {

				grpStateInfo();

				ls.requestFocus();

			}

			return true;

		}

		else { 

			for(int i = 0; i<MAX_NUM_CHECKS; i++) {

				if (event.target == relnChk[i]) {

					if (event.id == Event.ACTION_EVENT) {

						ls.processKey('1' + i, Event.SHIFT_MASK);

					}



					return true;

				}

			}

		}

		return false;

	}



	public void toggleRelationActivity(Diagram dg, int key) {

		if (key == 10) {

			// Affect all relations



			boolean ns = !relnClass[0].isActive();



			int i = 0;



			while(relnClass[i] != null) {

				dg.setEdgeActiveState(relnClass[i], ns);

				i++;

			}

		}

		else {

			RelationClass rc = relnClass[key];



			if (rc != null) {

				boolean ns = !rc.isActive();



				dg.setEdgeActiveState(rc, ns);

				ls.doFeedback("Relation " + rc.getLabel()

								+ " set to " + (ns ? "active" : "inactive"));

			}

		}

		repaint();

	}





	public void activate() {

		super.activate();

	}



	public void inactivate() {

		super.inactivate();



		for (int i=0; i<MAX_NUM_CHECKS; i++) {

			relnChk[i].hide();

		}

		grpChk.hide();

	}



	public void toggleGroupingFlag() {

		grpChk.setState(!grpChk.getState());

		grpStateInfo();

	}



	public boolean getGroupingFlag() 
	{
		return grpChk.getState();
	}

}



