package lsedit;

import java.awt.*;
import java.util.*;
import java.io.*;

public class RelationClass extends LandscapeClassObject {

	protected static final String FACTOR_ID = "class_iofactor";

	protected static final String RELATION_BASE_CLASS_ID = "$RELATION";

	protected boolean active  = true; 
	protected boolean visible = true; 

	// Permitted relations

	protected Vector relationList = new Vector();	 
	protected int ordinal;

	// --------------
	// Public methods
	// --------------

	public RelationClass(String id, int nid, RelationClass prc, Diagram dg)
	{
		this.id = id;					// The string name of this relation class
		this.setNid(nid);				// The numeric id
		this.label = id;				// The label of this relation
		this.dg = dg;					// Backreference to diagram

		setStyle(Util.LINE_STYLE_NORMAL);

		addParentClass(prc);			// Parent class
		setObjectColor(Color.black);
	}

	// If new, add an edge to the ERD (permitted relation)

	public void addRelation(EntityClass ec1, EntityClass ec2) {

		// Should check to see if relation is already present  
		EntityClassPair p = new EntityClassPair(ec1, ec2);
		relationList.addElement(p);

	}



	public boolean isValidRelation(EntityClass ec1, EntityClass ec2) {

		return true;

	}



	public boolean isValidRelation(EntityInstance e1, EntityInstance e2) {

		return isValidRelation(e1.getEntityClass(), e2.getEntityClass());

	}



	public boolean isValidSrc(EntityClass ec) {

		Enumeration enum1 = relationList.elements();

		while(enum1.hasMoreElements()) {
			EntityClassPair ep = (EntityClassPair) enum1.nextElement();
			if (ep.entityClass1 == ec) {
				return true; 
		}	}
		return false;
	}



	public boolean isValidDst(EntityClass ec) {

		Enumeration enum1 = relationList.elements();

		while(enum1.hasMoreElements()) {
			EntityClassPair ep = (EntityClassPair) enum1.nextElement();
			if (ep.entityClass2 == ec) {
				return true;
		}	}	
		return false; 
	}





	public boolean hasId(String id) {

		return this.id.equals(id);
	}



	// Return RelationInstance based on our RelationClass



	public RelationInstance 

	newRelation(EntityInstance e1, EntityInstance e2, Diagram dg) {

		RelationInstance ri = new RelationInstance(this, e1, e2, dg);

		makeInstanceOfUs(ri);
		return ri;
	}



	public void writeRelations(PrintStream ps) throws IOException {

		Enumeration en = relationList.elements();

		while(en.hasMoreElements()) {
			EntityClassPair ep = (EntityClassPair) en.nextElement();
			ps.print(qt(id) + " " + qt(ep.entityClass1.id) + " " + qt(ep.entityClass2.id) + "\n");
		}
	}



	public void getRelationsRaw(Vector v, Hashtable st) {

		Enumeration en = relationList.elements();



		while(en.hasMoreElements()) {

			EntityClassPair ep = (EntityClassPair) en.nextElement();

			Integer[] tup = new Integer[3];

			tup[0] = (Integer) st.get(id);
			tup[1] = (Integer) st.get(ep.entityClass1.id);
			tup[2] = (Integer) st.get(ep.entityClass2.id);

			v.addElement(tup);	  
		}
	}

	public void writeAttributes(PrintStream ps) throws IOException 
	{

		if (getNid() >= 2) {
			ps.print("(" + qt(id) + ") {\n");
			super.writeAttributes(ps);
			ps.print("}\n\n");
		}
	}

	// Accessor functions

	public String toString() {
		return id;
	}

	public boolean isVisible() {
		return visible;
	}



	public void setVisibleState(boolean state) {
		visible = state; 
	}



	public boolean isActive() {
		return active;
	}



	public void setActiveState(boolean state) {
		active = state; 
	}



	public String addParentClass(RelationClass inherits) {
		return addParentClass(inherits, RELATION_BASE_CLASS_ID);
	}



	public void setOrdinal(int ord) {
		ordinal = ord;
	}

	public double getIOfactor() {
		Attribute attr = getAttribute(FACTOR_ID);

		if (attr != null) {
			return Util.parseReal(attr.avi.value);
		}

		if (dg.allowElision()) {
			double num = dg.numVisibleRelationClasses();
			return (ordinal+1)/(num+1);
		}
		double num = dg.numRelationClasses();
		return ((num > 2) ? (getNid()-1)/(num-1) : 0.5);
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes

	public int getPrimaryAttributeCount()
	{
		return(6);
	}

	public String getAttributeNameAt(int index)
	{
		String	name;

		switch (index) {
		case 0:
			name  = "id";
			break;
		case 1:
			name  = CLASSLABEL_ID;
			break;
		case 2:
			name  = CLASSDESC_ID;
			break;
		case 3:
			name  = CLASSSTYLE_ID;
			break;	
		case 4:
			name  = COLOUR_ID;
			break;
		case 5:
			name  = LABEL_COLOUR_ID;
			break;
		default:
			name  = super.getAttributeNameAt(index);
		}
		return(name);
	}

	public Object getAttributeValueAt(int index)
	{
		Object	value;

		switch (index) {
		case 0:
			value = getId();
			break;
		case 1:
			value = label;
			break;
		case 2:
			value = description;
			break;
		case 3:
			value = new Integer(getStyle());
			break;
		case 4:
			value = getObjectColor();
			break;
		case 5:
			value = getLabelColor();
			break;
		default:
			value = super.getAttributeValueAt(index);
		}
		return(value);
	}

	public void setAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case 0:
			setId((String) value);
			break;
		case 1:
			label          = (String) value;
			break;
		case 2:
			description    = (String) value;
			break;
		case 3:
			setStyle(((Integer) value).intValue());
			break;
		case 4:
			setObjectColor((Color) value);
			break;
		case 5:
			setLabelColor((Color) value);
			break;
		default:
			super.setAttributeValueAt(index, value);
	}	}

	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getAttributeTypeAt(int index)
	{
		int		ret;
		
		switch (index) {
		case 0:
		case 1:
			ret = Attribute.STRING_TYPE;
			break;
		case 2:
			ret = Attribute.TEXT_TYPE;
			break;
		case 3:
			ret = Attribute.REL_STYLE_TYPE;
			break;
		case 4:
		case 5:
			ret = Attribute.COLOR_TYPE;
			break;
		default:
			ret = super.getAttributeTypeAt(index);
		}
		return(ret);
	}
}

