package lsedit;

import java.awt.*;
import java.util.*;
import java.io.*;

public class RelationInstance extends LandscapeObject {
	// Constants

	public final static int CLIENT_SUPPLIER_EL_LEN = 16;

	protected final static double SEP_THRESHOLD    = 10.0;

	protected final static Color HIGHLIGHT_COLOUR  = Color.yellow;
	protected final static int	 HIGHLIGHT_DIM	   = 4;

	// First order attribute ids

	protected final static String STYLE_ID	= "style";
	protected final static String BENDS_ID	= "bends";
	protected final static String BENDSREL_ID = "bendsrel";

	// An edge is defined by a relation class and two entity instances

	protected RelationClass	  parentClass;
	protected EntityInstance  src, dst;

	// First order attributes

	protected Vector	bends = null;
	protected Vector	bendContainer = null;

	protected int timeStamp = -1;
	protected boolean groupFlag = false;
	protected boolean highlightFlag = false;


	protected static int stump_mode = Diagram.STUMP_DST;

	public static void drawBend(Graphics g, double x, double y, boolean sc) 
	{
		if (sc) {
			g.setColor(Color.black);
		}
		ScreenPoint pt = new ScreenPoint(x-Bend.SIZE/2, y-Bend.SIZE/2);

		g.fillRect(pt.x, pt.y, Bend.SIZE, Bend.SIZE);
	}

	protected boolean 
	processFirstOrderAttributes(Attribute attr, Hashtable entities) 
	{
		boolean hasVal = (attr.avi != null);

		if (attr.id.equals(COLOUR_ID)) {
			if (hasVal)
				setObjectColor(attr.parseColour());
			return true; 
		}
		if (attr.id.equals(STYLE_ID)) {
			if (hasVal) {
				setStyle(attr.parseInt());
			}
			return true;
		}
/* 
		Bends are not output so no need for legacy code ??

		if (attr.id.equals(BENDS_ID)) {
			if (hasVal) {
				// List of lists

				if (bends == null)
					bends = new Vector();

				AttributeValueItem avi = attr.avi;

				while (avi != null) {
					RealPoint pt = avi.next.parsePoint();
					EntityInstance e = (EntityInstance) entities.get(avi.value);

					if (e != null) {
						double x1, y1;
						double	parentLocalWidth, parentLocalHeight, parentLocalX, parentLocalY;

						parentLocalWidth  = e.widthLocal();
						parentLocalHeight = e.heightLocal();
						parentLocalX      = e.xLocal();
						parentLocalY      = e.yLocal();

						if (parentLocalWidth == 0.0) {
							x1 = 0.0;
						} else {
							x1 = (pt.x - parentLocalX) / parentLocalWidth;
						}
						if (parentLocalHeight == 0.0) {
							y1 = 0.0;
						} else {
							y1 = (pt.y - parentLocalY) / parentLocalHeight;
						}

						Bend bend = dg.newBendRel(e, this, x1, y1);

						bends.addElement(bend); 
						e.addBend(bend);
						MsgOut.dprintln("Bend added: " + e.getId() + " " + pt.x + " " + pt.y);
					}
					else {
						MsgOut.println("Missing bend parent entity: " + e.getId());
					}
					avi = avi.nextList;
				}
			} 
			return true;
		}
*/
		if (attr.id.equals(BENDSREL_ID)) {
			if (hasVal) {
				// List of lists

				if (bends == null)
					bends = new Vector();

				AttributeValueItem avi = attr.avi;

				while (avi != null) {
					RealPoint pt = avi.next.parsePoint();
					EntityInstance e = (EntityInstance) entities.get(avi.value);

					if (e != null) {
						Bend bend = dg.newBendRel(e, this, pt.x, pt.y);

						bends.addElement(bend); 
						e.addBend(bend);
						MsgOut.dprintln("Bendrel added: " + e.getId() + " " + pt.x + " " + pt.y);
					}
					else {
						MsgOut.println("Missing bend parent entity: " + e.getId());
					}
					avi = avi.nextList;
				}
			} 
			return true;
		}

		return false;
	}

	protected EdgePoint 
	getOutPoint(EntityInstance e, Layout srcLyt, Layout dstLyt) 
	{
		return e.getOutPoint(this, edge_mode, srcLyt, dstLyt);
	}

	protected Bend nextBend(Enumeration en) 
	{
		if (en.hasMoreElements()) {
			return (Bend) en.nextElement();
		}
		return null;
	}

	protected Bend nextBendRev(int cind) {
		if (cind >= 0) {
			return (Bend) bends.elementAt(cind);
		}
		return null;
	}

	protected Vector points(boolean allowElision) {

		EntityInstance root = dg.getRoot();

		EntityInstance e1 = src.getVisibleEntity(root);
		EntityInstance e2 = dst.getVisibleEntity(root);

		if (e1 == e2 || e1 == null || e2 == null) {
			return null;
		}

		if (src.containedBy == dst.containedBy || (edge_mode == Diagram.DIRECT_EDGE || !allowElision))
		{
			if (root.descendent(src) && src.containedBy != dst.containedBy) {
				// Determine e1 based on elisions

				if (allowElision) {
					while (e1 != root && e1.getParent().isSupplierRelationElided(parentClass))
					{
						e1 = e1.getParent();
					}
			}	}

			Layout srcLyt = e1.getLayout();
			Layout dstLyt = e2.getLayout();

			Vector v = new Vector();

			if (bends == null) {
				EdgePoint pt1 = getOutPoint(e1, srcLyt, dstLyt);
				EdgePoint pt2 = getOutPoint(e2, dstLyt, srcLyt);

				pt1.active = true;
				pt1.elision = false;

				pt2.active = true;
				pt2.elision = false;

				v.addElement(pt1);
				v.addElement(pt2);
			} else {
				Bend fb = (Bend) bends.firstElement();
				Bend lb = (Bend) bends.lastElement();

				Layout fLyt = new Layout(fb.x, fb.y, 0, 0);
				Layout lLyt = new Layout(lb.x, lb.y, 0, 0);

				v.addElement(getOutPoint(e1, srcLyt, fLyt));
			
				Enumeration en = bends.elements();

				while(en.hasMoreElements()) {
					Bend b = (Bend) en.nextElement();
					BendPoint pt = new BendPoint(b.x, b.y);

					pt.active = true;
					pt.elision = false;

					v.addElement(pt);
				}

				v.addElement(getOutPoint(e2, dstLyt, lLyt));
			}
			return v;
		} else {

			EntityInstance endUp, endDown;

			boolean client = !root.descendent(src);
			boolean supplier = !root.descendent(dst);

			if (!client && !supplier) {
				endUp = src.common(dst); // Common container
				endDown = endUp;
			}
			else if (client) {
				endUp = dg.getClient(src).containedBy;
				endDown = root.containedBy;
			}
			else {
				endUp = root.containedBy;
				endDown = dg.getSupplier(dst).containedBy;
			}

			if (endUp == null) {
				System.out.println("C Error: " + src + " " + dst + " " + client + " " + supplier);
				return null;
			}

			if (endDown == null) {
				System.out.println("S Error: " + src + " " + dst + " " + client + " " + supplier);
				return null;
			}

			// Not in the same container

			Vector v1 = new Vector();
			Vector v2 = new Vector();

			EntityInstance e = e1;

			EntityInstance sp = src;
			EntityInstance dp = dst;

			while (sp.containedBy != endUp)
				sp = sp.containedBy;

			while (dp.containedBy != endDown)
				dp = dp.containedBy;

			Layout spLyt = sp.getLayout();
			Layout dpLyt = dp.getLayout();

			Enumeration en = null;
			Bend nxBend = null;

			if (bends != null) {
				en = bends.elements();

				nxBend = nextBend(en);
			}

			/* The following is a bit tricky.
			 *
			 * We build up two vectors of points which represent the
			 * the curve we want the edge to take. These sets are built
			 * one point at a time. 
			 *
			 * The first set builds a curve from the source entity to
			 * to the common container entity. The second set builds
			 * the curve from the destination to the common container.
			 * The second curve then has its points reversed an is 
			 * appended to the first curve. 
			 *
			 * Throughout this, we must handle any bends that may be
			 * part of the curve.
			 *
			 * Client/Supplier edge elision complicated things because
			 * it requires the ability to have discontinuous curves.
			 *
			 */

			EdgePoint ppt = null;		// Previous point

			while (e != endUp) {
				if (e == null) {
					MsgOut.println("Error in points: " +
									   "(" + parentClass.getId() + " " +
									   src.getId() + " " + dst.getId() + ")");
					return null;
				}

				EntityInstance ep = e.containedBy;

				if (nxBend != null && ep != endUp && ep == nxBend.e) {

					spLyt = e.getLayout();
					Layout bLyt = new Layout(nxBend.x, nxBend.y, 0, 0);

					v1.addElement(getOutPoint(e, spLyt, bLyt));
					spLyt = bLyt;

					while (nxBend != null && ep == nxBend.e) {	
						BendPoint pt = 
							new BendPoint(nxBend.x, nxBend.y);

						v1.addElement(pt);
						nxBend = nextBend(en);
					}
				} else {
					EdgePoint pt = getOutPoint(e, spLyt, dpLyt);

					pt.active  = true;
					pt.elision = false;

					if (allowElision && ppt != null &&	e.isSupplierRelationElided(parentClass))
					{
						ppt.active = false;
						ppt.elision = true;
/*
						// Introduce an interim point and mark points.

						EdgePoint npt = (EdgePoint) pt.clone();

						switch(pt.side)
						{
						case EdgePoint.TOP:
							npt.y += CLIENT_SUPPLIER_EL_LEN;
							break;

						case EdgePoint.BOTTOM:
							npt.y -= CLIENT_SUPPLIER_EL_LEN;
							break;

						case EdgePoint.LEFT:
							npt.x += CLIENT_SUPPLIER_EL_LEN;
							break;
							
						default:
							npt.x -= CLIENT_SUPPLIER_EL_LEN;
							break;
						}
						
						ppt.active	= false;
						npt.elision = true;
						v1.addElement(npt);
*/
					}

					v1.addElement(pt);
					ppt = pt;

					// spLyt = new Layout(pt.x, pt.y, 0, 0);
				}

				e = ep; 

			}

			// We've found all points from source entity to 
			// the edge of its ancestor in the common container
		
			// Now add any bends between the ancestor entities

			while (nxBend != null && endUp == nxBend.e) {		
				BendPoint pt = new BendPoint(nxBend.x, nxBend.y);

				v1.addElement(pt);
				nxBend = nextBend(en);
			}

			// Finally, find the points from the destination entity
			// to the edge of its ancestor in the common container.
			// We'll reverse the order later.

			int cInd = -1;

			if (nxBend != null) {
				cInd = bends.size()-1;
				nxBend = nextBendRev(cInd--);
			}

			e = e2;

			spLyt = dp.getLayout();
			dpLyt = sp.getLayout();

			ppt = null;

			while (e != endDown) {
				EntityInstance ep = e.containedBy;

				if (nxBend != null && ep != endDown && ep == nxBend.e) {
					spLyt = e.getLayout();
					Layout bLyt = new Layout(nxBend.x, nxBend.y, 0, 0);

					v2.addElement(getOutPoint(e, spLyt, bLyt));
					spLyt = bLyt;

					if (ep != endDown) {
						while (nxBend != null && ep == nxBend.e) {
							BendPoint pt = 
								new BendPoint(nxBend.x, nxBend.y);

							v2.addElement(pt);
							nxBend = nextBendRev(cInd--);
						}
					}
				} else {
					EdgePoint pt = (EdgePoint) getOutPoint(e, spLyt, dpLyt);

					pt.elision = false;
					pt.active  = true;

					if (allowElision && ppt != null && e.isClientRelationElided(parentClass))
					{
						// Introduce an interim point and mark points

						pt.elision = true;
						pt.active = false;
/*
						EdgePoint npt = (EdgePoint) pt.clone();

						switch(pt.side)
						{
						case EdgePoint.TOP:
							npt.y += CLIENT_SUPPLIER_EL_LEN;
							break;

						case EdgePoint.BOTTOM:
							npt.y -= CLIENT_SUPPLIER_EL_LEN;
							break;

						case EdgePoint.LEFT:
							npt.x += CLIENT_SUPPLIER_EL_LEN;
							break;
							
						default:
							npt.x -= CLIENT_SUPPLIER_EL_LEN;
							break;
						}

						npt.active = false;
						pt.elision = true;

						v2.addElement(npt);
*/
					}

					v2.addElement(pt);
					ppt = pt;

					// spLyt = new Layout(pt.x, pt.y, 0, 0);
				}

				e = ep;

			} 

			for (int i = v2.size()-1; i >= 0; i--) {
				v1.addElement(v2.elementAt(i));
			}

			return v1;
		}
	}

	protected int findNearestSeg(int x, int y, int threshold, Vector pts) {
		Enumeration en = pts.elements();

		RealPoint srcPt, dstPt;

		int ind = 0;

		dstPt = (RealPoint) en.nextElement();

		do {
			srcPt = dstPt;
			dstPt = (RealPoint) en.nextElement();

			if (!srcPt.elision && srcPt.active) {

				// Determine distance to line and point R(x, y)
				//
				// Using parametric form for equation of line
				// L = P0 + tV	where V is vector from P0 to P1
				//
				// Find t such that vector R -> P0 + tV is orthogonal to V.
				// We then restrict to checking distances to
				// segment P0, P1 (0 < t < 1). 

				double rx = x;
				double ry = y;

				double vx = dstPt.x - srcPt.x;
				double vy = dstPt.y - srcPt.y; 

				double t = ((rx - srcPt.x) * vx + (ry - srcPt.y) * vy) /
					   (vx*vx + vy*vy);

				if (t > 0 && t < 1.0) {
					// Only check for segment between P0 and P1
					double px = srcPt.x + t * vx;
					double py = srcPt.y + t * vy; 

					double lx = (rx - px);
					double ly = (ry - py);

					int dist = (int) Math.sqrt(lx*lx + ly*ly);

					if (dist < threshold)
						return ind;
				}
			}

			ind++;

		} while (en.hasMoreElements());

		return -1;
	}


	protected void drawEdge(Graphics g, boolean allowElision) {

		if (src == null || dst == null) {
			MsgOut.println("Landscape error: null src or dst");
			return;
		}

		ScreenPoint p1 = new ScreenPoint();		  
		ScreenPoint p2 = new ScreenPoint();

		if (src.containedBy == null) {
			MsgOut.println("drawEdge: containedBy error");
			return;
		}
		if (dst.containedBy == null) {
			MsgOut.println("drawEdge: containedBy error");
			return;
		}

		Vector v = points(allowElision);

		if (v != null) {

			EntityInstance root = dg.getRoot();

			int dstyle;

			if (allowElision && (!root.descendent(src) || !root.descendent(dst))) {
				dstyle = Util.LINE_STYLE_DOTTED;
			} else {
				dstyle = getStyle();
			}

			// v contains the set of EdgePoints and BendPoints we need to draw
			// line segments between the src and dst entities

			Enumeration en = v.elements();

			RealPoint srcPt, dstPt;

			EdgePoint ept = (EdgePoint) en.nextElement();
			EdgePoint lept;

			boolean drawHead = false;
			boolean drawBends = dg.isDrawBends();

			if (ept.active && ept.getEntity() == src) {
				Util.drawTailPoint(g, ept);
			}

			dstPt = ept;

			do {
				srcPt = dstPt;
				dstPt = (RealPoint) en.nextElement();

				drawHead = false;

				if (srcPt.active) {
					if (drawBends && !dstPt.isBend()) {
						ept = (EdgePoint) dstPt;

						if (srcPt.active && dstPt.active && ept.getEntity().isOpen()) {
							ept.getEntity().drawIOpoint(g, parentClass, ept, true);
						}
					}

					p1.set(srcPt.x, srcPt.y);
					p2.set(dstPt.x, dstPt.y);

					// System.out.println("(" + p1.x + "," + p1.y + ") (" + p2.x + "," + p2.y + ")");
					dg.drawCache.drawSegment(g, dstyle, p1, p2);
					drawHead = true;

					if (groupFlag) {
						// Draw a selected highlight marker
						// at the middle of the segment

						Color tc = g.getColor();
		
						g.setColor(HIGHLIGHT_COLOUR);

						p1.set((p1.x + p2.x - HIGHLIGHT_DIM)/2, 
								(p1.y + p2.y - HIGHLIGHT_DIM)/2);

						g.fillRect(p1.x, p1.y, HIGHLIGHT_DIM, HIGHLIGHT_DIM);

						g.setColor(tc);
					}

					if (srcPt.elision) {
						RealPoint halfPt = (RealPoint) dstPt.clone();

						halfPt.y = srcPt.y + ((dstPt.y - srcPt.y) * 0.7);

						Util.drawArrowHead(g, srcPt, halfPt);
						drawHead = false;
					}
				}

			} while(en.hasMoreElements());

			if (drawHead) {
				Util.drawArrowHead(g, srcPt, dstPt);	
			}

			if (bends != null && drawBends) {
				en = bends.elements();

				while (en.hasMoreElements()) {
					Bend b = (Bend) en.nextElement();

					drawBend(g, b.x, b.y, true);
				}
			}
		}
	}


	protected void drawElided(Graphics g, EntityInstance vsrc, 
								EntityInstance vdst, 
								boolean srcElOverride, boolean dstElOverride)
	{
		if (vsrc.isOutRelationElided(parentClass) || srcElOverride)
		{
			Layout srcLyt = vsrc.getLayout();
			Layout dstLyt = vdst.getLayout();

			RealPoint srcPt = getOutPoint(vsrc, srcLyt, dstLyt);

			RealPoint dstPt;

			if (srcElOverride) {
				dstPt = getOutPoint(vsrc.getParent(), srcLyt, dstLyt);
			}
			else {
				dstPt = new RealPoint(dstLyt.x + dstLyt.width/2,
									dstLyt.y + dstLyt.height/2);
			}

			double dx = srcPt.x - dstPt.x;
			double dy = srcPt.y - dstPt.y;

			double df = Math.sqrt(dx*dx + dy*dy);

			double x = srcPt.x - dx*2*Util.ARROW_L/df;
			double y = srcPt.y - dy*2*Util.ARROW_L/df;

			ScreenPoint p1 = new ScreenPoint(srcPt.x, srcPt.y);
			ScreenPoint p2 = new ScreenPoint(x, y); 

			dg.drawCache.drawSegment(g, getStyle(), p1, p2);

			RealPoint pt = new RealPoint(x, y); 
			Util.drawArrowHead(g, srcPt, pt); 
		}

		if (vdst.isInRelationElided(parentClass) || dstElOverride)
		{
			Layout srcLyt = vsrc.getLayout();
			Layout dstLyt = vdst.getLayout();

			RealPoint dstPt = getOutPoint(vdst, dstLyt, srcLyt); 

			RealPoint srcPt;

			if (dstElOverride) {
				srcPt = getOutPoint(vdst.getParent(), dstLyt, srcLyt);
			}
			else {
				srcPt = new RealPoint(srcLyt.x + srcLyt.width/2,
												srcLyt.y + srcLyt.height/2);
			}

			double dx = srcPt.x - dstPt.x;
			double dy = srcPt.y - dstPt.y;

			double df = Math.sqrt(dx*dx + dy*dy);
		   
			double x = dstPt.x + dx*2*Util.ARROW_L/df;
			double y = dstPt.y + dy*2*Util.ARROW_L/df; 

			ScreenPoint p1 = new ScreenPoint(x, y);
			ScreenPoint p2 = new ScreenPoint(dstPt.x, dstPt.y); 

			dg.drawCache.drawSegment(g, getStyle(), p1, p2);
			Util.drawArrowHead(g, srcPt, dstPt);
		}
	}

	protected void drawRecursiveLoop(Graphics g) {
		if (!src.containedBy.isOpen())
			return;

		int rad = 8;

		Layout lyt = src.getLayout();

		ScreenPoint p = new ScreenPoint(lyt.x + lyt.width - rad, lyt.y - rad);

		g.drawArc(p.x, p.y, rad*2, rad*2, 270, 270);

		int xp[] = new int[3];
		int yp[] = new int[3];

		xp[0] = p.x;
		yp[0] = p.y+rad;
		xp[1] = p.x-1;
		yp[1] = p.y;
		xp[2] = p.x+rad-1;
		yp[2] = p.y+rad-1;

		g.fillPolygon(xp, yp, 3);
	}


	// --------------
	// Public methods
	// --------------

	public RelationInstance(RelationClass parentClass, 
				EntityInstance src, EntityInstance dst, Diagram dg)
	{
		this.parentClass = parentClass;
		this.src = src;
		this.dst = dst;
		this.dg	 = dg;

		setObjectColor(parentClass.getObjectColor());
	}

	public LandscapeObject derivedFrom(int i)
	{
		return((i == 0) ? parentClass : null);
	}


	// Draw an edge between two entities, handling elision settings.
	// 

	public boolean draw(Graphics g, boolean allowElision) {
		if (parentClass.isVisible() || !allowElision) {

			EntityInstance vsrc = src.getVisibleEntity();
			EntityInstance vdst = dst.getVisibleEntity();

			if (vsrc == null || vdst == null ||	dg.drawCache.haveDrawn(vsrc, vdst, parentClass)) {
				return false;
			}

			if (allowElision) {
				EntityInstance srcP = vsrc.containedBy;
				EntityInstance dstP = vdst.containedBy; 

				if (srcP == dstP) {
					// See if container is elided for internal edges
					if (srcP.isInternalRelationElided(parentClass)) {
						return false;
					}
				}
			}

			g.setColor(getObjectColor());

			if (vsrc != src && vsrc == vdst) {	// Allow recursion
				return false;
			}

			EntityInstance root = dg.getRoot();

			if (src == dst) {
				drawRecursiveLoop(g);
			}
			else if (allowElision && 
					 root.descendent(src) && root.descendent(dst))
			{
				if ( vsrc.isOutRelationElided(parentClass) ||
					 vdst.isInRelationElided(parentClass))
				{
					// Elided draw
					drawElided(g, vsrc, vdst, false, false);
				}
				else {
					// Normal draw
					drawEdge(g, allowElision);
					timeStamp = dg.getTimeStamp();
				}
			}
			else {
				// Normal draw
				drawEdge(g, allowElision);
				timeStamp = dg.getTimeStamp();
			}
		}

		return true;
	}

	public boolean draw(Graphics g) {
		drawEdge(g, true);
		return true;
	}

/*
	public void drawHighlighted(Graphics g) {
		g.setColor(Color.white);
		drawEdge(g, false);
	}
*/

	public boolean isNearEdge(int x, int y, int threshold, int timeStamp) {

		if (timeStamp != -1 && timeStamp != this.timeStamp)
			return false;

		Vector pts = points(!highlightFlag && timeStamp != -1);

		if (pts == null || pts.size() < 2) {
		   return false;
		}
/*		System.out.println("RelationInstance:isNearEdge(x=" + x + ", y=" + y + ", threshold=" + threshold + ", timestamp=" + timeStamp + ")");	// IJD
		for (int i = 0; i < pts.size(); ++i) {					// IJD
			System.out.println("pts[" + i + "]=" + pts.elementAt(i));
		}
*/
		return (findNearestSeg(x, y, threshold, pts) >= 0);
	}

	public boolean addBend(Bend bend) {
		if (bends == null) {
			// First bend for this relation

			bends = new Vector();
			bends.addElement(bend);
		}
		else {
			// Put it in proper place in bend list

			Vector pts = points(true);

			int ind = findNearestSeg((int) bend.x, (int) bend.y, 4, pts);

			if (ind == -1) {
				MsgOut.println("Couldn't find bend slot");
				return false;
			}

			if (ind == 0) {
				// Bend must go first
				bends.insertElementAt(bend, 0);
			}
			else if (ind == pts.size()-1) {
				// Bend must go last
				bends.addElement(bend);
			}
			else {
				// Find slot

				int slot = bends.size()-1;

				while (slot >= 0 && pts.indexOf(bends.elementAt(slot)) > ind)
					slot--;

				slot++;

				if (slot == bends.size())
					bends.addElement(bend);
				else {
					bends.insertElementAt(bend, slot);
				}
			}
		}
		return true;
	}

	public void deleteBend(Bend bend) {
		bends.removeElement(bend);

		if (bends.size() == 0) 
			bends = null;
	}

	public void addAttribute(Attribute attr) {

		if (processFirstOrderAttributes(attr, null))
			return;

	}

	public void assignAttributes(Attribute attr, Hashtable entities)
	{
		// Passed list of attributes

		while (attr != null) {
			// For each attribute assignment, find the variable,
			// and assign the value.

			if (attr.avi == null) {
				MsgOut.println("Null attribute assignment");
			}
			else if (!processFirstOrderAttributes(attr, entities)) {
				Attribute attrVar = getAttribute(attr.id);

				if (attrVar == null) {
					MsgOut.println("Missing attribute '" + attr.toString() + "'");
				} else {
					if (attrVar.cloneOnAssign) {
						Attribute newAttr = (Attribute) attrVar.clone();
						replaceAttribute(newAttr);
					}
					attrVar.avi = attr.avi;
				}
			}
			attr = attr.next;
		}
	}

	public void writeRelation(PrintStream ps) throws IOException {
		ps.print(qt(parentClass.getId()) + " " + 
					qt(src.getId()) + " " + qt(dst.getId()) + "\n");
	}

	public void writeAttributes(PrintStream ps) throws IOException 
	{
		ps.print("(" + qt(parentClass.getId()) + " " + 
						qt(src.getId()) + " " + qt(dst.getId()) + ") {\n");

		// Write first order attributes

		if (bends != null) {
			ps.print(" bendsrel = (");
			Enumeration en = bends.elements();
			while (en.hasMoreElements()) {
				Bend bend = (Bend) en.nextElement();
				ps.print("(" + bend.e.getId() + " " + bend.xRelLocal() + " " + bend.yRelLocal() + ") ");
			}
			ps.print(")\n");
		}

		// Write any others
		super.writeAttributes(ps, false);
		ps.print("}\n\n");
	
	}

	public boolean hasId(String id) {
	   return false;
	}

	public boolean
	isSameRelation(RelationClass rc, EntityInstance src, EntityInstance dst) {
		return (rc == parentClass && this.src == src && this.dst == dst); 
	}

	public EntityInstance getSrc() {
		return this.src;
	}

	public EntityInstance getDst() {
		return this.dst;
	}

	public RelationClass getRelationClass() {
		return parentClass;
	}

	public Enumeration getBends() {
		if (bends == null)
			return null;
		else
			return bends.elements();
	}

	public void setHighlightFlag() {
		highlightFlag = true;
	}

	public boolean getHighlightFlag() {
		return highlightFlag;
	}

	public boolean clearHighlightFlag() {

		boolean ret;

		ret = highlightFlag;

		if (ret) {
			highlightFlag = false;
		}
		return(ret);
	}

	public static void setStumpMode(int mode) {
		stump_mode = mode;
	}

	public void setGroupFlag() {
		groupFlag = true; 
		setHighlightFlag();
	}

	public void clearGroupFlag() {
		groupFlag = false;
	}

	public boolean getGroupFlag() {
		return groupFlag;
	}

	public String toString() {

		EntityInstance root, e1, e2;

		root = dg.getRoot();
		e1	 = src.getVisibleEntity(root);
		e2	 = dst.getVisibleEntity(root);

		return e1 + (e1 == src ? "" : "{" + src + "}") + "->" + e2 + (e2 == dst ? "" : "{" + dst + "}");
	}

}
