package lsedit;

import java.awt.*;

import java.util.*;



public class ResizeModeHandler extends LandscapeModeHandler

{

	// Variables used by modes

	protected static final int RM_NONE	 = 0;
	protected static final int RM_LEFT	 = 1;
	protected static final int RM_RIGHT	 = 2;
	protected static final int RM_TOP	 = 4;
	protected static final int RM_BOTTOM = 8;


	protected static final int LR_MASK = RM_LEFT | RM_RIGHT;

	protected static final int TB_MASK = RM_TOP | RM_BOTTOM;



	protected static final int RZONE_SIZE = 5;



	protected static final double MIN_DIM	 = 10.0;

	protected Layout	curLayout;

	protected Layout	bb;				// bounding box of children 

	private Rectangle	m_plyt = null;


	protected int resizeMode = RM_NONE;



	protected int[] startMode = 

		{ RM_TOP | RM_LEFT, 
		  RM_TOP, 
		  RM_TOP | RM_RIGHT, 
		  RM_RIGHT,
		  RM_BOTTOM | RM_RIGHT,
		  RM_BOTTOM, 
		  RM_BOTTOM | RM_LEFT, 
		  RM_LEFT
		};



	protected void addMode(int newMode) {

		int omode = 0;



		switch(newMode) 

		{

		case RM_TOP:

			omode = RM_BOTTOM;

			break;



		case RM_BOTTOM:

			omode = RM_TOP;

			break;



		case RM_LEFT:

			omode = RM_RIGHT;

			break;



		case RM_RIGHT:

			omode = RM_LEFT;

			break;

		} 



		if ((resizeMode & omode) == 0) {

			resizeMode |= newMode;

		}

	}


	private String resizeDescription() {

		String ret;

		if (resizeMode == RM_NONE) {
			ret = "NONE";
		} else {
			ret = "";
			if ((resizeMode & RM_LEFT) != 0) {
				ret += "LEFT ";
			}
			if ((resizeMode & RM_RIGHT) != 0) {
				ret += "RIGHT ";
			}
			if ((resizeMode & RM_TOP) != 0) {
				ret += "TOP ";
			}
			if ((resizeMode & RM_BOTTOM) != 0) {
				ret += "BOTTOM";
			}
		}
		return(ret);
	}

	protected void doResizeAdjust(int mode, int xpos, int ypos) {

		int gap = 20;
		int x1, y1, width1, height1;

		x1		= (int) curLayout.x;
		y1		= (int) curLayout.y;
		width1	= (int) curLayout.width;
		height1 = (int) curLayout.height;

		if (xpos-x1 < 4) {
			addMode(RM_LEFT);
		}
		if (x1 + width1 - xpos < 4) {
			addMode(RM_RIGHT);
		}
		if (ypos-y1 < 4) {
			addMode(RM_TOP);
		}
		if (y1 + height1 - ypos < 4) {
			addMode(RM_BOTTOM);
		}

		if ((mode & RM_TOP) != 0) {

			if (ypos >= m_plyt.y + gap) {
				height1 += y1 - ypos;
				y1		 = ypos;
			}
		} else if ((mode & RM_BOTTOM) != 0) {
			if (ypos <= m_plyt.y + m_plyt.height - gap) {
				height1 = ypos - y1;
		}	 }

		if ((mode & RM_LEFT) != 0) {
			if (xpos >= m_plyt.x + gap) {
				width1 += x1 - xpos;
				x1		= xpos;
			}
		} else if ((mode & RM_RIGHT) != 0) {
			if (xpos <= m_plyt.x + m_plyt.width - gap) {
				width1 = xpos - x1;
		}	}	

//		System.out.println("1: x=" + xpos + " y=" + ypos + " curLayout=" + curLayout + " plyt=" + m_plyt + " new={" + x1 +"," + y1 + "," + width1 + "," + height1);

		if (width1 >= MIN_DIM) {
			curLayout.x		 = (double) x1;
			curLayout.width	 = (double) width1;
		}
		if (height1 >= MIN_DIM) {
			curLayout.y		 = (double) y1;
			curLayout.height = (double) height1;
		}
	}



	//

	// Public methods

	//



	public ResizeModeHandler() {

	}


	//
	//	 ++-----------++
	//	 +			   +   
	//	 |			   |  Corner or edge grab
	//	 |			   | 
	//	 +			   +
	//	 ++-----------++
	//



	public boolean mouseDown(Event ev, int x, int y) {

//		System.out.println("ResizeModeHandler mousedown\n");

		if (dg == null) {
			return false;
		}

		e = dg.mouseOver(x, y);

		if (e == null || !e.getGroupKeyFlag()) {
			return false;
		} 

		int rpoint = e.overResizeTab(x, y);
		if (rpoint < 0) {
			return false;
		}

		resizeMode = startMode[rpoint];
		curLayout  = (Layout) e.getLayout().clone();

		if (m_plyt == null) {
			m_plyt = new Rectangle();
		} 


		EntityInstance parent;

		parent = e.getParent();
		if (parent != null && parent.getParent() != null) {
			Layout plyt;

			plyt = parent.getLayout();
			m_plyt.x	  = (int) plyt.x;
			m_plyt.y	  = (int) plyt.y;
			m_plyt.width  = (int) plyt.width;
			m_plyt.height = (int) plyt.height;
		} else {
			m_plyt	 = dg.bounds();
			m_plyt.x = 0;
			m_plyt.y = 0;
		}

		gc.setXORMode(e.getParent().getBackground());
		dg.drawEntityOutline(gc, curLayout, e);

		ls.doFeedback("Size: " + Math.round(curLayout.width) + " x " + Math.round(curLayout.height));

		return true; 

	}



	public boolean mouseDrag(Event ev, int x, int y) {

		double xpos = x;
		double ypos = y;

		if (resizeMode == RM_NONE) {

			// See if we have reached an edge

			boolean l = (xpos <= curLayout.x);
			boolean r = (xpos >= curLayout.x + curLayout.width);
			boolean t = (ypos <= curLayout.y);
			boolean b = (ypos >= curLayout.y + curLayout.height);


			if (e == dg.getRoot()) {
				l = false;		// Can't change left
				t = false;		// Can't change top
			}

			if (l) {
				if (t || ypos-curLayout.y < 4) {
					resizeMode = RM_LEFT | RM_TOP;
				} else if (b || (curLayout.y + curLayout.height - ypos < 4)) {
					resizeMode = RM_LEFT | RM_BOTTOM;
				} else {
					resizeMode = RM_LEFT;
			}	}

			else if (r) {
				if (t || ypos-curLayout.y < 4) {
					resizeMode = RM_RIGHT | RM_TOP;
				} else if (b || (curLayout.y + curLayout.height - ypos < 4)) {
					resizeMode = RM_RIGHT | RM_BOTTOM;
				} else {
					resizeMode = RM_RIGHT;
			}	}

			else if (t) {
				if (xpos-curLayout.x < 4) {
					resizeMode = RM_TOP | RM_LEFT;
				} else if (curLayout.x + curLayout.width - xpos < 4) {
					resizeMode = RM_TOP | RM_RIGHT;
				} else {
					resizeMode = RM_TOP;
			}	}

			else if (b) {
				if (xpos-curLayout.x < 4) {
					resizeMode = RM_BOTTOM | RM_LEFT;
				} else if (curLayout.x + curLayout.width - xpos < 4) {
					resizeMode = RM_BOTTOM | RM_RIGHT;
				} else {
					resizeMode = RM_BOTTOM;
			}	}
		}

		if (resizeMode == RM_NONE)
			return true; 


		dg.drawEntityOutline(gc, curLayout, e);

		doResizeAdjust(resizeMode, x, y);

		dg.drawEntityOutline(gc, curLayout, e);

		ls.doFeedback("Size: " + Math.round(curLayout.width) + " x " + Math.round(curLayout.height));

		return true;

	}



	public void mouseUp(Event ev, int x, int y) {

		if (e != null) {

			dg.saveForUndo();

			e.setLayout(curLayout);

			dg.rescaleDiagram();

			e.fitTo(false);

			ls.redrawDg();

		}



		ls.clearFeedback();

	}

}

