package lsedit;

import java.applet.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.util.*;



public class ScrollableDiagram extends Diagram {

	protected static final int SB_WIDTH	 = 12;
	protected static final int SB_HEIGHT = 12;

	protected Scrollbar rightScroll, bottomScroll;

	protected int diffx, diffy;

	protected void posScroll() 
	{
		rightScroll.move(getDiagramX() + getDiagramWidth()-GAP-SB_WIDTH, getDiagramY()+GAP);
		rightScroll.resize(SB_WIDTH, getDiagramHeight()-GAP*2-(SB_HEIGHT+1));
		bottomScroll.move(getDiagramX()+GAP, getDiagramY()+getDiagramHeight()-GAP-SB_HEIGHT); 
		bottomScroll.resize(getDiagramWidth()-GAP*2-(SB_WIDTH+1), SB_HEIGHT);
	}

	protected void resetScroll() 
	{
/*
		Layout lyt = m_drawRoot.getLayout();

		int h = getDiagramHeight()-GAP*2;
		int w = getDiagramWidth()-GAP*2;

		// Set bottom scrollbar

		if (lyt.width <= (double) w) {
			if (bottomScroll.isVisible()) {
				MsgOut.dprintln("Hide: " + lyt.width + " " + w);
				bottomScroll.hide();
			}
		} else { 
			if (!bottomScroll.isVisible()) {
				bottomScroll.show();
			}

			// Set scrollbar values
			diffx = (int) lyt.width - w;
			bottomScroll.setValues(-m_xoffset, w, 0, (int) lyt.width); // diffx);
		}

		// Set right scrollbar

		if (lyt.height <= (double) h) {
			if (rightScroll.isVisible()) {
				rightScroll.hide();
			}
		} else { 
			MsgOut.dprintln("Vert: " + lyt.height + " " + ((double) h));

			if (!rightScroll.isVisible()) {
				rightScroll.show();
			}	

			// Set scrollbar values

			diffy = (int) lyt.height - h; 

			rightScroll.setValues(-m_yoffset, h, 0, (int) lyt.height); // diffy);

		}

*/

	}



	protected Graphics gContext(Graphics gc) {

		int vpwidth, vpheight;



		if (rightScroll.isVisible()) {
			vpwidth = getDiagramWidth()-(GAP*3+SB_WIDTH);
		} else {
			vpwidth = getDiagramWidth()-GAP*2;
		}


		if (bottomScroll.isVisible()) {
			vpheight = getDiagramHeight() - (GAP*3+SB_HEIGHT);
		} else {
			vpheight = getDiagramHeight() - GAP*2;
		}
		Graphics g = gc.create(getDiagramX()+GAP, getDiagramY()+GAP, vpwidth, vpheight);
		return g;
	}



	protected void scrollRightBar(Graphics gc, Event ev) {

		switch(ev.id)

		{

		case Event.SCROLL_LINE_UP:

		case Event.SCROLL_PAGE_UP:

			if (m_yoffset < 0) {

				m_yoffset = Math.min(m_yoffset+diffy/5, 0);

				rescaleDiagram();

				draw(gc);

			} 

			return;



		case Event.SCROLL_LINE_DOWN:

		case Event.SCROLL_PAGE_DOWN:

			if (m_yoffset > -diffy) {

				m_yoffset = Math.max(m_yoffset-diffy/5, -diffy);

				rescaleDiagram();

				draw(gc);

			}

			return;



		case Event.SCROLL_ABSOLUTE:

			m_yoffset = -(((Integer) ev.arg).intValue());

			rescaleDiagram();

			draw(gc);

			return;

		}

	}



	protected void scrollBottomBar(Graphics gc, Event ev) 
	{
		switch(ev.id)

		{

		case Event.SCROLL_LINE_UP:
		case Event.SCROLL_PAGE_UP:

			if (m_xoffset < 0) {
				m_xoffset = Math.min(m_xoffset+diffx/5, 0);
				rescaleDiagram();
				draw(gc);
			}
			return;


		case Event.SCROLL_LINE_DOWN:
		case Event.SCROLL_PAGE_DOWN:

			if (m_xoffset > -diffx) {
				m_xoffset = Math.max(m_xoffset-diffx/5, -diffx);
				rescaleDiagram();
				draw(gc);
			}
			return;



		case Event.SCROLL_ABSOLUTE:

			m_xoffset = -(((Integer) ev.arg).intValue());
			rescaleDiagram();
			draw(gc);
			return;
		}
	}







	// --------------

	// Public methods

	// --------------



	public ScrollableDiagram(LandscapeViewerCore ls, Scrollbar rightScroll, Scrollbar bottomScroll)
	{
		super(ls, true);

		this.rightScroll = rightScroll;

		this.bottomScroll = bottomScroll;

		super.reshape(0, 0, 10, 10);
	}



	public void move(int x, int y) 
	{
		super.move(x, y);
		posScroll();
	}



	public void resize(int width, int height) 
	{
		super.resize(width, height);
		posScroll();
	}



	public void reshape(int x, int y, int width, int height)
	{
		super.reshape(x, y, width, height);
		posScroll();
	}



	public Graphics getContext(Graphics gc) {

		int vpwidth, vpheight;



		if (rightScroll.isVisible()) {

			vpwidth = getDiagramWidth()-(GAP*3+SB_WIDTH);

		} else {

			vpwidth = getDiagramWidth()-GAP*2;
		}


		if (bottomScroll.isVisible())

			vpheight = getDiagramHeight() - (GAP*3+SB_HEIGHT);

		else

			vpheight = getDiagramHeight() - GAP*2;



		return gc.create(getDiagramX()+GAP, getDiagramY()+GAP, vpwidth, vpheight);

	}



	// Draw the entities, edges, and labels 



	public void draw(Graphics gc) {

		gc.setColor(Diagram.boxColour);

		gc.fillRect(getDiagramX(), getDiagramY(), getDiagramWidth(), getDiagramHeight());
		gc.draw3DRect(getDiagramX(), getDiagramY(), getDiagramWidth(), getDiagramHeight(), true);
		gc.draw3DRect(getDiagramX()+1, getDiagramY()+1, getDiagramWidth()-2, getDiagramHeight()-2, true);

		posScroll();



		Graphics g = getContext(gc);



		doDraw(g, m_drawRoot, (m_drawRoot != m_rootInstance)); 


		// drawCache.printStats();



		g.dispose();

	}



	public void draw(Graphics gc, EntityInstance e) {

		Graphics g = getContext(gc);



		super.draw(g, e);



		g.dispose();

	}



	// 

	// Generates global coordinates for current scale factor

	//

	public void rescaleDiagram() 
	{
		super.rescaleDiagram();
		resetScroll();
	}



	public int adjustX(int x) 
	{
		return(x - (getDiagramX()+GAP)); 
	}



	public int adjustY(int y) 
	{
		return(y - (getDiagramY()+GAP)); 
	}



	public void scroll(Graphics gc, Event ev) 
	{
		if (ev.target == rightScroll) {
			scrollRightBar(gc, ev);
		} else {
			scrollBottomBar(gc, ev);
	}	}

	public void navigateTo(EntityInstance e) 
	{
		super.navigateTo(e);
		resetScroll();
	}
}
