package lsedit;

import java.applet.*;

import java.awt.*;

import java.util.*;



public class TitleBox extends Canvas {

	protected static final int MARGIN = 5; 



	protected static final Color BACKGROUND_COLOUR = 

										new Color(1.0f, 1.0f, 0.85f);

	protected static final Font textFont =

				new Font("Helvetica", Font.PLAIN, 12); 



	protected Applet ls;

	protected EntityInstance e;



	protected Dimension getLabelDim(Graphics gc, String label) {

		gc.setFont(textFont);



		FontMetrics fm = gc.getFontMetrics();



		int h = Util.fontHeight(fm);

		int w = fm.stringWidth(label);



		return new Dimension(w, h);

	}



	public TitleBox(Applet ls) {

		this.ls = ls;

		hide();

	}



	public void set(EntityInstance e, Diagram dg) {

		if (this.e != e) {

			this.e = e;

		

			Graphics gc = getGraphics();



			Dimension dim = getLabelDim(gc, e.getLabel());

			Rectangle r	  = dg.bounds();



			setBackground(BACKGROUND_COLOUR);



			int w = dim.width+MARGIN*2+1;

			int h = dim.height+MARGIN;

		

			resize(w, h);



			ScreenLayout lyt = new ScreenLayout(e.getLayout());



			move(r.x + lyt.x + lyt.width/2, 

						r.y + lyt.y + lyt.height + MARGIN*2);



			show();

		}

	}



	public void hide() {

		if (e != null) {

			super.hide();

			e = null;

		}

	}



	public void paint(Graphics gc) {

		if (e != null) {

			Rectangle r = bounds();



			gc.clearRect(0, 0, r.width, r.height);



			gc.setColor(Color.black);

			gc.setFont(textFont);

			e.doDrawLabel(gc, 0, 0, r.width, r.height, false);



			gc.drawRect(0, 0, r.width-1, r.height-1);

		}

	}

}

