package lsedit;

import java.util.*;

import java.awt.*;

import java.applet.*;



public class Util
{
	public final static double ARROW_L = 10.0;
	public final static double ARROW_TH = 0.40; 

	public static final int LINE_STYLE_NORMAL			= 0;
	public static final int LINE_STYLE_DASHED			= 1;
	public static final int LINE_STYLE_DOTTED			= 2;
	public static final int LINE_STYLE_INSCRIBED		= 3;

	public static final String[] lineStyleName =
		{ 
				"Normal", 
				"Dashed", 
				"Dotted", 
				"Inscribed"
		};

	protected static final int DASH_LEN			= 4;
	protected static final int DASH_GAP			= 3;

	protected static final int DOT_LEN			= 0;
	protected static final int DOT_GAP			= 4;

	protected static boolean adjustFonts  = false;
	protected static boolean reverseZflag = false;

	protected static final Font tabFont = new Font("Helvetica", Font.BOLD, 10);

	protected static final int GAP		  = 5;
	protected static final int INSET	  = 12;
	protected static final int OUTSET	  = 5;

	protected static final StringCompareFn stringCompareFn = new StringCompareFn();

	private static final int partition( Vector v, int l, int r, CompareFn cf, boolean asc )
	{
		// Arbitrarily pick the left element as the pivot element:

		Object p = v.elementAt(l);

		l--; 
		r++;

		while(true) {
			// Figure out what's before and after the pivot:

			boolean f;

			do {
				r--;
				Object o = v.elementAt(r);

				if (asc) {
					f = (cf.compare(o, p) > 0);
				} else {	
					f = (cf.compare(o, p) < 0);
				}
			} while (f);

			do {
				l++;
				Object o = v.elementAt(l);

				if (asc) {
					f = (cf.compare(o, p) < 0);
				} else {	
					f = (cf.compare(o, p) > 0);
				}
			} while (f);

			// Swap elements if we can:

			if (l < r) {
				if (cf.compare(v.elementAt(l), v.elementAt(r)) != 0) {
					Object o = v.elementAt(l);
					v.setElementAt(v.elementAt(r), l);
					v.setElementAt(o, r);
				}
			} else {
				return r;
	}	}	}

	private static final void qsort( Vector v, int l, int r, CompareFn cf, boolean asc)
	{
		// If we haven't reached a termination condition...

		if (l < r) {

			//	Partition the vector into left and right halves:
			int p = partition(v, l, r, cf, asc);

			//	Recursively sort each half:
			qsort(v, l, p, cf, asc);
			qsort(v, p+1, r, cf, asc);
	}	}

	private static final void sort( Vector v, int l, int r, CompareFn cf, boolean asc)
	{
		switch(r) {
		case 0:
			return;
		case 1:
			if (cf.compare(v.elementAt(0), v.elementAt(1)) == 1) {
				Object o = v.elementAt(0);
				v.setElementAt(v.elementAt(1), 0);
				v.setElementAt(o, 1);
			}
			return;
		default:
			qsort(v, l, r, cf, asc);
			return;
	}	}

	public static void sortVector(Vector v, CompareFn cf, boolean ascending) 
	{
		sort(v, 0, v.size() - 1, cf, ascending);
	}

	public static void sortVector(Vector v, boolean ascending)
	{
		sort(v, 0, v.size() - 1, stringCompareFn, ascending);
	}

	public static void sortVector(Vector v) 
	{
		sort(v, 0, v.size() - 1, stringCompareFn, true);
	}

	public static boolean adjustFontToggle() 
	{
		adjustFonts = !adjustFonts;

		return adjustFonts;
	}

	public static int fontHeight(FontMetrics fm)
	{
		return (adjustFonts ? fm.getHeight()/2 : fm.getHeight());
	}

	public static int fontHeight(Font font)
	{
		Toolkit tk = Toolkit.getDefaultToolkit();

		FontMetrics fm = tk.getFontMetrics(font);
		return (adjustFonts ? fm.getHeight()/2 : fm.getHeight());
	}

	public static boolean drawStringClipped(Graphics g, String str,	double x, double y, double width, double height, boolean centered, boolean underlined)
	{
		FontMetrics fm = g.getFontMetrics();


		int len = str.length();
		int pos = len-1;

		if (fm.stringWidth(str) > width) {
			while(pos >= 0 && fm.stringWidth(str.substring(0, pos) + "...") > width) {
				pos--;
			}
		}

		if (pos < 0) {
			return false;
		}


		String dstr;
		double xpos;

		if (pos == len-1) {
			dstr = str;

			double sw = (double) fm.stringWidth(str);

			xpos = (centered ? x+width/2-sw/2 : x); 
		} else {
			dstr = str.substring(0, pos) + "...";

			xpos = x;
		}

		ScreenPoint pt;	 

		if (centered) {
			pt = new ScreenPoint(xpos, y + height/2 + fontHeight(fm)/2);
		} else {
			pt = new ScreenPoint(xpos, y + fontHeight(fm));
		}

		g.drawString(dstr, pt.x, pt.y);

		if (underlined) {
			int sw = fm.stringWidth(dstr);

			g.drawLine(pt.x, pt.y, pt.x+sw, pt.y);
		}

		return (pos == len-1);
	}

	public static boolean drawStringClipped(Graphics g, String str,	double x, double y, double width, double height)
	{
		return drawStringClipped(g, str, x, y, width, height, false, false);
	}

	public static boolean drawUnderlinedStringClipped(Graphics g, String str, double x, double y, double width, double height)
	{
		return drawStringClipped(g, str, x, y, width, height, false, true);
	}

	protected static int longestSubStr(String str, FontMetrics fm, int width) 
	{
		int pos = str.indexOf('\n');

		if (pos > 0) {
			str = str.substring(0, pos);
		}
		pos = str.indexOf(' ');

		if (pos < 0 || fm.stringWidth(str) < width) {
			return str.length();
		}
		int lpos = -1;

		while(pos >= 0) {
			if (fm.stringWidth(str.substring(0, pos)) > width) {
				return (lpos < 0 ? pos : lpos);
			}
			lpos = pos;
			pos = str.indexOf(pos+1, ' ');
		}
		return lpos;
	}



	public static boolean drawStringWrapped(Graphics g, String str,	double x, double y, double width, double height, boolean centered, boolean underlined)
	{
		FontMetrics fm = g.getFontMetrics();
		Vector		strs = new Vector();

		if (str.indexOf(' ') < 0 && str.indexOf('\n') < 0) {
			return drawStringClipped(g, str, x, y, width, height, centered, underlined);
		}

		int pos;

		for (;;) {
			pos = longestSubStr(str, fm, (int) width); 
			strs.addElement(str.substring(0, pos));
			if (pos == str.length()) {
				break;
			}
			str = str.substring(pos + 1);
		}

		int fh = (fontHeight(fm) * 3)/4;
		int ht = strs.size() * fh;

		Enumeration en = strs.elements();

		double ypos = (centered ? y + (height - ht)/2 + fh : y + fh);

		while(en.hasMoreElements()) {
			str     = (String) en.nextElement();
			int len = str.length();
			pos     = len-1;

			while(pos >= 0 && fm.stringWidth(str.substring(0, pos)) > width) {
				pos--;
			}

			String dstr;
			double xpos;

			if (pos == len-1) {
				dstr = str;

				double sw = (double) fm.stringWidth(str);
				xpos = (centered ? x+width/2-sw/2 : x); 
			} else {
				dstr = str.substring(0, pos);

				xpos = x;
			}

			ScreenPoint pt = new ScreenPoint(xpos, ypos);

			g.drawString(dstr, pt.x, pt.y);
			if (underlined) {
				int sw = fm.stringWidth(dstr);
				g.drawLine(pt.x, pt.y, pt.x+sw, pt.y);
			}
			ypos += fh;
		}
		return true;
	}



	public static boolean isUnix() {

		try {

		   if(System.getProperty("file.separator").equals("/"))

			   return true;

		}

		catch(Exception e) {

			// Catch exception and ignore

		}

		return false;

	}



	public static boolean isHTTP(String path) {

		return path.length() > 7 && 

			   (path.substring(0,7).equals("http://") ||

				path.substring(0,7).equals("HTTP://"));

	}



	public static String prefixOf(String name) {

		int ind = name.lastIndexOf('.');



		if (ind >= 0) {

			return name.substring(0, ind);

		}



		return name;

	}



	public static void drawFrame(Graphics gc, Rectangle r) {

		gc.setColor(Diagram.boxColour);



		gc.draw3DRect(0, 0, r.width-1, r.height-1, true);

		gc.draw3DRect(1, 1, r.width-3, r.height-3, true);

	}



	public static Dimension getTabDim(Graphics gc, String title) {

		gc.setFont(tabFont);

   

		FontMetrics fm = gc.getFontMetrics();



		int w = fm.stringWidth(title) + GAP*2;

		int h = fontHeight(tabFont) + GAP;



		return new Dimension(w, h);

	}



	public static void

	drawTab(Graphics gc, String title, Color titleColor,

						int offx, boolean active)

	{

		boolean underlineFC = (title.charAt(0) == '&');



		String dstr;



		if (underlineFC) {

			dstr = title.substring(1);

		}

		else {

			dstr = title;

		}



		gc.setFont(tabFont);



		FontMetrics fm = gc.getFontMetrics();



		int h = fontHeight(tabFont);



		int tabw = fm.stringWidth(dstr) + GAP*2;

		int tabh = h + GAP;



		gc.setColor(Diagram.boxColour);



		gc.draw3DRect(offx, 0, tabw, tabh, true);

		gc.draw3DRect(offx+1, 1, tabw-2, tabh, true);



		if (active)

			gc.fillRect(offx+2, 2, tabw-3, tabh+10);



		gc.setColor(titleColor);



		gc.drawString(dstr, offx + 5, h);



		if (underlineFC) {

			int w = fm.stringWidth(title.substring(1, 2));



			gc.drawLine(offx+5, h+1, offx+w+5, h+1);

		}

	}



	public static void

	drawTabbedFrame(Graphics gc, Rectangle r, String title, Color titleColor, int offx)
	{

		int h = fontHeight(tabFont) + GAP;

		gc.setColor(Diagram.boxColour);

		gc.draw3DRect(0, h, r.width-1, r.height-h-1, true);
		gc.draw3DRect(1, h+1, r.width-3, r.height-h-3, true);

		drawTab(gc, title, titleColor, offx, true);
	}



	public static double parseReal(String str) {

		return (new Double(str)).doubleValue();

	}



	public static int parseInt(String str) {

		return (new Integer(str)).intValue();

	}



	public static boolean parseBoolean(String str) {

		return str.equals("true");

	}



	protected static String qt(String str) {

		if (str.indexOf(' ') >= 0)

			return "\"" + str + "\"";

		else

			return str;

	}



	protected static String doExpand(String src, String id, 

										LandscapeViewerCore ls) 

	{

		String link = "";



		int pos = 0;

		int len = src.length();



		boolean found;



		MsgOut.dprintln("Expand: " + src);



		do {

			int ind = src.indexOf('$', pos);



			found = (ind == 0 || (ind > 0 && src.charAt(ind-1) != '\\')) &&

					(ind+1 < len);



			if (found) {

				int endInd = src.indexOf('$', ind+1);



				if (endInd < ind) {

					MsgOut.println("Missing delimitting '$'" + 

										" in expansion variable");

					return null;

				}

				link += src.substring(pos, ind);



				String var = src.substring(ind+1, endInd);



				if (var.equals("ID")) {

					link += qt(id);

				}

				else if (var.equals("IDPREFIX")) {

					int dind = id.lastIndexOf('.');



					if (dind >= 0)

						link += qt(id.substring(0, dind));

					else

						link += qt(id);

				}

				else if (var.equals("IDSUFFIX")) {

					int dind = id.lastIndexOf('.');



					if (dind >= 0)

						link += id.substring(dind+1);

				}

				else if (var.equals("DGDIR")) {

					String path = ls.getDiagram().getAbsolutePath();



					String dir = dirFromPath(path);

					

					link += dir;

				}

				else if (var.equals("DGSUFFIX")) {

					String path = ls.getDiagram().getAbsolutePath();



					String name = nameFromPath(path);



					int dind = name.indexOf('.');

				   

					if (dind >=0)  

						link += name.substring(dind+1);

				}

				else {

					// Assume it's a PARAM name

					String value = ls.getParameter(var);



					if (value != null) {

						link += qt(value); 

					}

					else {

						MsgOut.println("Parameter not found: "

												+ "'" + var + "'");

						return "";

					}

				}

				pos = endInd+1;

			}

		} while (found && pos < len);



		if (pos < len)

			link += src.substring(pos);



		MsgOut.dprintln("Result: " + link);



		return link;

	}



	public static String expand(String src, String id, 

								LandscapeViewerCore ls)

	{



		String nstr1, nstr2;



		nstr2 = doExpand(src, id, ls);



		do {

			nstr1 = nstr2;

			nstr2 = doExpand(nstr1, id, ls);



		} while (!nstr1.equals(nstr2));



		return nstr1;

	}



	public static String expand(String src, LandscapeViewerCore ls) {

		return expand(src, "", ls);

	}

 

	public static Frame getFrame(Component c) {

		if (c instanceof Frame)

			return (Frame) c;



		while ((c = c.getParent()) != null) {

			if (c instanceof Frame)

				return (Frame) c;

		}



		return null;

	}



	public static String dirFromPath(String path) {

		int ind1 = path.lastIndexOf('/');

		int ind2 = path.lastIndexOf('\\');

		

		if (ind1 > ind2) {

			return path.substring(0, ind1);

		}

		else if (ind2 > ind1) {

			return path.substring(0, ind2);

		}



		return "";

	}



	public static String nameFromPath(String path) {

		int ind1 = path.lastIndexOf('/');

		int ind2 = path.lastIndexOf('\\');

		

		if (ind1 > ind2) {

			return path.substring(ind1+1);

		}

		else if (ind2 > ind1) {

			return path.substring(ind2+1);

		}



		return path;

	}



	public static boolean isBlack(Color c) {

		if (c == Color.black) {
			return true;
		}

		if (c.getRed() != 0) {
			return false;
		}
		if (c.getGreen() != 0) {
			return false;
		}
		return(c.getBlue() == 0);
	}



	public static String addNL(String instr, int cols) {

		StringBuffer sb = new StringBuffer();



		int spos = 0;

		int epos;

		int len	 = instr.length();



		while (spos+cols < len) {

			epos = spos+cols-1;



			while (epos > spos && instr.charAt(epos) != ' ')

				epos--; 



			if (epos == spos) 

			   epos = cols;



			sb.append(instr.substring(spos, epos) + "\n");

			spos = epos+1;

		}



		sb.append(instr.substring(spos));



		return new String(sb);

	}



	public static String stripNL(String instr) {

		return instr.replace('\n', ' ');

	}



	public static String quoted(String str) {

		if (str.indexOf(' ') >= 0) {

			return "\"" + str + "\"";

		}



		return str;

	}



	protected static void drawLine(Graphics g, LineWalker lw) 
	{
		ScreenPoint p1 = new ScreenPoint(0, 0);
		ScreenPoint p2 = new ScreenPoint(0, 0);

		while(lw.morePoints()) {
			 lw.nextPoints(p1, p2);
			 g.drawLine(p1.x, p1.y, p2.x, p2.y);
		}
	}



	protected static void 

	drawInscribedLine(Graphics g, ScreenPoint p1, ScreenPoint p2) 

	{

		Color cc = g.getColor();



		g.setColor(Color.gray);

		g.drawLine(p1.x, p1.y, p2.x, p2.y);

		g.setColor(Color.white);



		if (p1.x == p2.x)

			g.drawLine(p1.x+1, p1.y, p2.x+1, p2.y);

		else

			g.drawLine(p1.x, p1.y+1, p2.x, p2.y+1);



		g.setColor(cc);

	}



	public static void drawLine(Graphics g,	ScreenPoint p1, ScreenPoint p2, int style)
	{
		LineWalker lw;

		switch(style) {
		case LINE_STYLE_NORMAL:
			g.drawLine(p1.x, p1.y, p2.x, p2.y);
			break;

		case LINE_STYLE_DOTTED:
			lw = new LineWalker(p1, p2, DOT_LEN, DOT_GAP);
			drawLine(g, lw);
			break;

		case LINE_STYLE_DASHED:
			lw = new LineWalker(p1, p2, DASH_LEN, DASH_GAP);
			drawLine(g, lw);
			break;

		case LINE_STYLE_INSCRIBED:
			drawInscribedLine(g, p1, p2);
			break;
		}
	}



	public static void drawTailPoint(Graphics g, RealPoint p1) {

		int hb = Bend.SIZE/2;



		ScreenPoint pt = new ScreenPoint(p1.x-hb, p1.y-hb);



		g.fillOval(pt.x, pt.y, hb*2, hb*2);

	}



	public static void drawArrowHead(Graphics g, RealPoint p1, RealPoint p2) 
	{
		double dx = p1.x - p2.x;
		double dy = p1.y - p2.y;

		if (dx == 0 && dy == 0) {
			return;
		}

		double theta = Math.atan2(dy, dx);
		double len = Math.min(ARROW_L, Math.sqrt(dx*dx + dy*dy));
		double ax = p2.x + len*Math.cos(theta-ARROW_TH);
		double ay = p2.y + len*Math.sin(theta-ARROW_TH);
		double bx = p2.x + len*Math.cos(theta+ARROW_TH);
		double by = p2.y + len*Math.sin(theta+ARROW_TH);

		int[] x = new int[3];
		int[] y = new int[3];

		x[0] = (int) Math.round(p2.x);
		y[0] = (int) Math.round(p2.y);
		x[1] = (int) Math.round(ax);
		y[1] = (int) Math.round(ay);
		x[2] = (int) Math.round(bx);
		y[2] = (int) Math.round(by);

		g.fillPolygon(x, y, 3);
	}



	public static void drawArrow(Graphics g, RealPoint p1, RealPoint p2) 
	{
		int x1, y1, x2, y2;

		x1 = (int) (p1.x + 0.5);
		y1 = (int) (p1.y + 0.5);
		x2 = (int) (p2.x + 0.5);
		y2 = (int) (p2.y + 0.5);

		g.drawLine(x1, y1, x2, y2);
		drawArrowHead(g, p1, p2);
		// drawTailPoint(g, p1);
	}



	public static void drawOutlineBox(Graphics g, ScreenLayout rect, boolean has3Dlook)
	{
		g.setColor(Color.gray);

		if (!has3Dlook) {
			g.drawRect(rect.x, rect.y, rect.width, rect.height);
			return;
		}

		int x = rect.x;
		int y = rect.y;
		int w = rect.width;
		int h = rect.height;

		g.drawLine(x, y, x+w, y);
		g.drawLine(x+w-1, y+1, x+w-1, y+h-1);
		g.drawLine(x+w-1, y+h-1, x+1, y+h-1);
		g.drawLine(x, y+h, x, y);
		g.setColor(Color.white);

		g.drawLine(x+1, y+1, x+w, y+1);
		g.drawLine(x+w, y+1, x+w, y+h);
		g.drawLine(x+w, y+h, x+1, y+h);
		g.drawLine(x+1, y+h, x+1, y+1);
	}

	public static void drawGroupBox(Graphics g, ScreenLayout rect, String label, Color labelColour, boolean has3Dlook)
	{
		int x = rect.x;
		int y = rect.y;
		int w = rect.width;
		int h = rect.height;

		FontMetrics fm = g.getFontMetrics();

		int len   = fm.stringWidth(label);
		int ht	  = fontHeight(fm);
		int inset = Math.min(INSET, w/12);

		if (w < inset + OUTSET) {
			drawOutlineBox(g, rect, has3Dlook);
			return;
		}

		int x2;

		if (len+GAP*2 > w-inset-OUTSET) {
			x2 = x + w - OUTSET;
		} else {
			x2 = x + inset + len + GAP*2;
		}

		g.setColor(Color.gray);

		if (has3Dlook) {
			g.drawLine(x, y+h, x, y);
			g.drawLine(x, y, x+inset, y);
			g.drawLine(x2, y, x+w, y);
			g.drawLine(x+w-1, y+1, x+w-1, y+h-1);
			g.drawLine(x+w-1, y+h-1, x+1, y+h-1);
			g.setColor(Color.white);
			g.drawLine(x+1, y+h, x+1, y+1);
			g.drawLine(x+1, y+1, x+inset, y+1);
			g.drawLine(x2, y+1, x+w, y+1);
			g.drawLine(x+w, y+1, x+w, y+h);
			g.drawLine(x+w, y+h, x+1, y+h);
		} else {
			g.drawLine(x, y+h, x, y);
			g.drawLine(x, y, x+inset, y);
			g.drawLine(x2, y, x+w, y);
			g.drawLine(x+w, y, x+w, y+h);
			g.drawLine(x+w, y+h, x, y+h);
		}
		g.setColor(labelColour);

		drawStringClipped(g, label, x+inset+GAP, y - (ht*2)/3, x2-x-GAP*2, 100);
	}

	public static String mungeName(String name) {
		String tmp = name.replace(' ', '_');

		tmp = tmp.replace('/', '-');
		tmp = tmp.replace(',', '_');
		return tmp.replace('\\', '-');
	}

	public static String hashEdge(RelationClass rc, EntityInstance src, EntityInstance dst)
	{
		return src.getId() + rc.getId() + dst.getId();
	}

	public static int round(double val) {
		return (int) (val + 0.5);
	}
}

