package lsedit;

public class Version {
	public final static int MAJOR = 6;
	public final static int MINOR = 0;
	public final static int BUILD = 17;
		public final static String COMPILED = "November 24, 2002";

		public static String Number()
		{
				return(MAJOR + "." + MINOR + "." + BUILD);
		}

		public static String CompileDate()
		{
				return("Compiled: " + COMPILED);
		}

		private static String Detail(String property)
		{
				String result;

				try {
						result = System.getProperty(property);
				} catch (Exception e) {
						result = "";
				};
				return(result);
		}

		public static String Details()
		{
				String result;

				// System.getProperties().list(System.out);

				result	= Version.Number() + "\n\n";


				try		{ //set if possible
						result += Version.CompileDate() + "\n";
						result += "Original Author: Gary Farmaner\n";
						result += "Developed at the University of Waterloo under the supervision of Prof. Ric Holt\n";
						result += "Version 6.0 corrections and improvements by Ian Davis \n";
						result += "LSEDIT is part of the Software Landscape tool suite\n\n";
						result += " licensed to CTBTO by Telepresence Systems, Inc. (www.telepres.com)\n\n";
						result += " under contact No. 01/2/20/163\n\n";
						result += "Run Time Engine: " + Detail("java.vendor") + " " + Detail("java.version") + "\n";
						result += "Virtual Machine: " + Detail("java.vm.name") + " " + Detail("java.vm.version") + "\n";
						result += "V/M Vendor: " + Detail("java.vm.vendor") + "\n"; 
						result += "Operating System: " + Detail("os.name") + " " + Detail("os.arch") + " " + Detail("os.version") + "\n";
						result += "Patch level: " + Detail("sun.os.patch.level") + "\n";
						result += "User id: " + Detail("user.name") + "\n";
						result += "Directory: " + Detail("user.dir") + "\n";

				} catch (Exception e) {}

				return(result);
		}
}

/* History:
   6.0.0 -- Changes by Ian Davis

   April 4th (All day) 9:30-10pm
   
   Placed all source in package lsedit.
   Fixed minor compile problems under latest version of sun.
   Added code to close window when x pressed in Top Right hand corner.
   Enhanced the version information.
   Changed file prompt to prompt using java.awt.FileDialog
   Made right tabbed box go away completely when turned off
   Activated appropriate right tab so will display properly when turned back on

   April 5th		   10:30-4pm
   Removed some debug output
   Made animation optional to improve refresh rate.
   By default now in options menu "Show animations" is set to false.
   Changed cursor back to default after double click of mouse
   Removed some null pointer exceptions (rather by guessing desired behaviour)

   6.0.1 

   April 7th
   Corrected bug in drawing edges introduced in 6.0.0
   Worked towards understanding lsedit layout strategy
   Cleaned up code
   Traced layout problem to	  Diagram.setToViewport()
   Attempting to decipher what occurs beneath this.
   Quite bemused since right now nothing makes much sense.
   Concerns include:
	(1) rootInstance.getChildBoundingBoxLocal();
		  this only gets the bounding box of its own children, not its decendants.
		  Is there a presumption that children strictly contained within parent.
	(2) old formula for y scale was bizarre.
		  yScale = (height-width/16)/bb.height;	 [ changed to function purely of height]
	(3) don't understand dx and dy at all..	 Don't see how using only height and width one
		can correct positions of children.
	(4) translateChildrenLocal changes local values using dx and dy for both children and bends
		But bends not considered in computing what the bounding box was

   April 8th-10
   Released 6.0.1

   6.0.2

   Began exploring the refresh problem
   Tracked bug down to repaints() on both mouse down and mouse up pairs
   Have changed code to paint group flags in tight relationship to setting/clearing group flag
   Have delayed painting of group to be moved until move actually begins to avoid need to refresh
   Removed debug messages
   Released 6.0.2

   6.0.3

   April 14th

   Corrected the way in which point positions were cached.	There was a problem that simply rescaling
   the point positions when want to actually say discard the cache of point positions doesn't work
   because the x,y positions of the objects containing these points may not yet be right.

   6.0.4

   April 16th

   Added source file provided by eric.
   Rewrote Stringlinizer.  Potentially some problems now with <A ...> </A> tags.. No idea what was
   being attempted before here.	 Investigated types of object.	Investigated setting color of
   objects manually.

   April 17th

   Added ability to assign open color to entity.  "opencolor=value".
   Added dynamic color changes to object through P or menu.
   Hopefully all works when saved.

   6.0.5

   Corrected displaying of descriptions in Legend box
   Corrected minor error in drawing flags on box.. An outline is one pixel wider than a fill.
   Enhanced color chooser to allow for an alpha
   Fixed bug in forward edge tracing

   6.0.6

   Wednesday April 24th

   Changed how flags were cleared
   Removed key codes from popup menus
   Removed U/u/S/s from entity popup menu
   Removed U/u/S/s from toolbar
   Removed fit child to container
   Removed save landscape raw from File menu
   Removed print all to eps files
   Moved towards handling resize of objects correctly
   Cleaned up forward/back reporting on result tab logic
   Improved/rewrote again stringLiner
   Corrected infinite loop in util

   6.0.7

   Wednesday April 25th 2002

   Added feedback message to description box when over feedback box, so can read entire error message.
   Refresh entire drawing if selecting a box clears highlighting anywhere
   Renamed edit button to menu button
   Removed duplication of this button
   Added code to remove menu popup on mouse down if no mouse up seen.	This is purely preventative code
   for a bug not well understood.

  6.0.8

  Thursday April 26th. 2002

  Fixed problems with Forward/Back refs..

  6.0.9

  Friday April 27th, 2002

  Removed minMax button on applet
  Changed client/suppliers so will compress rather than not draw if can't reduce while still being too wide

  6.0.10

  Added short cut keys back into menus and toolbar buttons u/s etc.

  6.0.11

  Added ability to change color of classes and relations from Legendbox
  Added ability to query things in the legend box
  Added popup menus

  6.0.12

  Changed to 4 character tabs in source code -- no release

  6.0.13

  Added CorrectBadLayout to handle irregularities in input TA file
  Huge amount of cleanup
  Completely rewrote how attributes were edited, etc

  6.0.14

  Allowed class style changes to impact on diagram
  Fixed bug in StringLinizer

  6.0.15

  Added ability to change class an entity belongs to through editing attributes
  Changed creation of new entity to use EditAttribute logic (simplifies code to maintain)

  6.0.16

  Very unclear whether this version was ever released. Work stopped so that a co-op
  student could implement 6.0.17. and 6.0.16 was where it stopped.  However, co-op
  student never did take on programming task.

  6.0.17

  Fix depth limit problems.  Converted code from using absolute external coordinate
  system to relative to parent coordinate system.  Huge rewrite of all graph drawing
  software.


*/
