package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.Font;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;

public class ArrowDimensions extends JDialog implements ActionListener { 

	static double	m_old_length;
	static double	m_old_arc;
	static int		m_old_width;
	static double	m_new_length;
	static double	m_new_arc;
	static int		m_new_width;
	
	JTextField		m_length;
	JTextField		m_arc;
	JTextField		m_width;
	JButton			m_ok;
	JButton			m_cancel;
	JButton			m_default;
	JLabel			m_message;

	protected ArrowDimensions(LandscapeViewerCore ls) //Constructor
	{
		super(ls.getFrame(), "Modify arrow settings",true); //false if non-modal

		Container	contentPane;
		JLabel		label;

		m_old_width  = Util.LINE_W;
		m_old_length = Util.ARROW_L;
		m_old_arc    = Util.ARROW_TH;
		m_new_width  = Util.LINE_W;
		m_new_length = Util.ARROW_L;
		m_new_arc    = Util.ARROW_TH;

		setSize(438,369);

		contentPane = getContentPane();
		contentPane.setLayout(null);

		setForeground(new Color(0,0,0));
		setBackground(new Color(192,192,192));
		setFont(new Font("Dialog",0,12));

		// ----------

		label = new JLabel("Width of edge:");
		label.setBounds(40,20,200,30);
		contentPane.add(label);
		label.setVisible(true);

		m_width = new JTextField("" + m_old_width, 100);
		m_width.setBounds(240,20, 75, 30);
		contentPane.add(m_width);
		m_width.setVisible(true);

		label = new JLabel("pixels");
		label.setBounds(320,20,50,30);
		contentPane.add(label);
		label.setVisible(true);

		// ----------

		label = new JLabel("Length of arrow edge:");
		label.setBounds(40,80,200,30);
		contentPane.add(label);
		label.setVisible(true);

		m_length = new JTextField("" + m_old_length, 100);
		m_length.setBounds(240,80, 75, 30);
		contentPane.add(m_length);
		m_length.setVisible(true);

		label = new JLabel("pixels");
		label.setBounds(320,80,50,30);
		contentPane.add(label);
		label.setVisible(true);

		// -----------

		label = new JLabel("Arc between edge and arrow edge:");
		label.setBounds(40,140,200,30);
		contentPane.add(label);
		label.setVisible(true);

		m_arc = new JTextField("" + m_old_arc, 30);
		m_arc.setBounds(240,140,75,30);
		contentPane.add(m_arc);
		
		label = new JLabel("radians");
		label.setBounds(320,140,50,30);
		contentPane.add(label);
		label.setVisible(true);

		// ------------

		m_ok = new JButton("Ok");
		m_ok.setBounds(40,210,50,30);
		contentPane.add(m_ok);
		m_ok.addActionListener(this);

		m_default = new JButton("Default");
		m_default.setBounds(115,210,100,30);
		contentPane.add(m_default);
		m_default.addActionListener(this);

		m_cancel = new JButton("Cancel");
		m_cancel.setBounds(240,210,100,30);
		contentPane.add(m_cancel);
		m_cancel.addActionListener(this);

		m_message = new JLabel("");
		m_message.setBounds(40,260,400,30);
		contentPane.add(m_message);

		setVisible(true);
	}

	public static void create(LandscapeViewerCore ls) 
	{
		new ArrowDimensions(ls);

		if (m_old_length != m_new_length || m_old_arc != m_new_arc || m_old_width != m_new_width) {
			Util.LINE_W   = m_new_width;
			Util.ARROW_L  = m_new_length;
			Util.ARROW_TH = m_new_arc;
			ls.repaint(); 
		} 
	}

	// ActionListener interface

	public void actionPerformed(ActionEvent ev)
	{
		Object	source;
		String	string;
		double	length, arc;
		int		width;

		// Pop down the window when the button is clicked.
		// System.out.println("event: " + ev);

		source = ev.getSource();

		if (source == m_default) {
			m_width.setText("" + Util.LINE_W_DEFAULT);
			m_length.setText("" + Util.ARROW_L_DEFAULT);
			m_arc.setText("" + Util.ARROW_TH_DEFAULT);
			m_message.setText("Values set to initial default");
			return;
		}

		if (source != m_cancel && source != m_ok) {
			return;
		}
		if (source == m_ok) {
			string = m_width.getText();
			try {
				width = Integer.parseInt(string);
				if (width < 0) {
					m_message.setText("Width negative");
					return;
				}
			} catch (Throwable exception) {
				m_message.setText("Width not an integer string value");
				return;
			}

			string = m_length.getText();
			try {
				length = Double.parseDouble(string);
				if (Double.isNaN(length)) {
					m_message.setText("Length is not a double precision number");
					return;
				}
			} catch (Throwable exception) {
				m_message.setText("Length is not a double precision string value");
				return;
			}
				
			if (length < 0) {
				m_message.setText("Length is negative");
				return;
			}
			string = m_arc.getText();
			try {
				arc    = Double.parseDouble(string);
				if (Double.isNaN(arc)) {
					m_message.setText("Arc is not a double precision number");
					return;
				}
			} catch (Throwable exception) {
				m_message.setText("Arc is not a double precision string value");
				return;
			}
			
			if (arc < 0) {
				m_message.setText("Arc is negative");
				return;
			}
			if (arc > 1.5) {
				m_message.setText("The maximum allowed arc angle is 1.5 (very near pi/2)");
				return;
			}
	
			m_new_width  = width;
			m_new_length = length;
			m_new_arc    = arc;
		}
		this.setVisible(false);
		this.dispose();
		return;
	}
} 



