package lsedit;

import java.util.*;

/* This is the object which handles inflections at the edge of a box */

public class EdgePoint extends RealPoint {

	public static final int TOP			= 0;
	public static final int BOTTOM		= 1;
	public static final int LEFT		= 2;
	public static final int RIGHT		= 3;

	private EntityInstance	m_e;			// This is an edge point of this entity
	public RelationClass	m_rc;			// The edge going here belongs to this relationclass
	public double			m_wf;			// Width fraction of entity e width
	public double			m_hf;			// Height fraction of entity e height 
	public boolean drawn     = false;
	public boolean isDefault = true;
	public int side;					// Which of four sides is this on wrt entity e

	public EdgePoint(EntityInstance e, RelationClass rc, double wf, double hf) 
	{
		m_e  = e;		// Entity we are an edge point for
		m_rc = rc;		// Relation class we serve as edge point for
		m_wf = wf;		// Width factor
		m_hf = hf;		// Height factor
	}

	// Rescale the edge point

	public void rescale()
	{
		EntityInstance e = m_e;

		m_x = ((double) e.getDiagramX()) + ((double) e.getWidth())*m_wf;
		m_y = ((double) e.getDiagramY()) + ((double) e.getHeight())*m_hf;
	}

	public Object clone() 
	{
		EdgePoint ne =	new EdgePoint(m_e, m_rc, m_wf, m_hf);

		ne.m_x     = m_x;
		ne.m_y     = m_y;
		ne.active  = active;
		ne.elision = elision;

		return ne;
	}

	public boolean isOver(int x, int y) 
	{
		return m_e.isPointOverIO(this, x, y);
	}

	public String EdgeSide() 
	{
		switch (side) {
		case EdgePoint.TOP:
			return("TOP");
		case EdgePoint.BOTTOM:
			return("BOTTOM");
		case EdgePoint.LEFT:
			return("LEFT");
		case EdgePoint.RIGHT:
			return("RIGHT");
		}
		return("??");
	}

	public EntityInstance getEntity()
	{
		return(m_e);
	}

	public void clearRc()
	{
		m_rc = null;
	}

	public void setRc(RelationClass rc1) 
	{
		m_rc = rc1;
	}

	public RelationClass getRc()
	{
		return(m_rc);
	}

/*
	// For debugging

	public double getY()
	{
		if (m_y != ((double) m_e.getDiagramY()) + ((double) m_e.getHeight())*m_hf) {
			System.out.println("EdgePoint inaccuracy " + m_y + ".v." + (((double) m_e.getDiagramY()) + ((double) m_e.getHeight())*m_hf));
			m_y = ((double) m_e.getDiagramY()) + ((double) m_e.getHeight())*m_hf;
		}
		return(m_y);
	}
*/

	public String toString() 
	{
		return EdgeSide() + " of " + m_e + " " + m_e.getDiagramBounds() + "{" + m_rc + "}: (" + ((int) m_x) + "(" + m_wf + ")" + ", " + ((int) m_y) + "(" + m_hf + "))";
	}

}

