package lsedit;

import java.awt.Cursor;
import java.awt.Event;
import java.awt.Rectangle;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

// The Edit and View ModeHandler are toggled by typing 'V'
// However this only occurs if we are using the landscapeEditorCore 

public class EditModeHandler extends ViewModeHandler {

	protected JPopupMenu buildEntityPopup()
	{
		JPopupMenu m;
		JMenu	   m1;
		
		m = new JPopupMenu("Entity options");

		m1 = new JMenu("Navigate");
		Do.navigateEntityMenu(m1, m_ls);
		m.add(m1);
		m1 = new JMenu("Query");
		Do.queryMenuItem(m1, m_ls);
		m.add(m1);

		m1 = new JMenu("Elide");
		Do.hideMenuItem(m1, m_ls);
		m.add(m1);

		m1 = new JMenu("Draw");
		Do.drawMenuItem(m1, m_ls);
		m1.addSeparator();
		Do.editEntityMenuItem(m1, m_ls);
		m1.addSeparator();
		m_ls.fontMenuItem(m1, m_ls);
		m.addSeparator();
		m.add(m1);

		m1 = new JMenu("Move");
		Do.groupAllMenuItem(m1, m_ls);
		Do.fitMenuItem(m1, m_ls);
		m.addSeparator();
		Do.scaleMenuItem(m1, m_ls);
		m.add(m1);

		return(m);
	}

	protected JPopupMenu buildRelationPopup()
	{
		JPopupMenu m;
		JMenu	   m1;
		
		m = new JPopupMenu("Edge options");
		Do.navigateEdgeMenu(m, m_ls);
		Do.deleteEdgeMenuItem(m, m_ls);
		Do.editRelationMenuItem(m, m_ls);
		return(m);
	}

	// -----------------
	// Protected methods
	// -----------------

	// Other commands

	protected void moveRedBoxes(Object object) 
	{
		Vector grp = m_dg.getRedBoxGroup();

		if (grp == null) {
			m_ls.error("No query result active.");
			return;
		}

		EntityInstance container = m_dg.targetEntity(object);
		if (container == null) {
			return;
		}

		if (container == m_dg.getRootInstance()) {
			m_ls.error("Can't add objects into the root");
			return;
		}
		/*
		if (!container.isOpen()) {
			m_ls.error("Entity to be inserted into is not open");
			return;
		}
		*/

		Enumeration en;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en.nextElement();
			if (e.hasDescendantOrSelf(container)) {
				m_ls.error("Entity " + e.getLabel() + " can't be moved into " + container.getLabel() + " because it contains the entity");
				continue;
			}
			m_ls.moveEntityContainment(container, e);
		}
		m_dg.fitTo(container);
	}

	protected void deltaFont(int delta) 
	{
		Vector grp = m_dg.getGroup();
		EntityInstance ge;

		if (grp != null && !grp.isEmpty()) {
			Enumeration en;
			
			for (en = grp.elements(); en.hasMoreElements();) {
				ge = (EntityInstance) en.nextElement();
				ge.deltaFont(delta);
			}
			m_ls.doFeedback("Selected entities font changed");
			return;
		} 
		ge = m_dg.getDrawRoot();
		if (ge != null) {
			ge.deltaFont(delta);
			m_ls.doFeedback("Outer entities font changed");
			return;
		} 
		m_ls.doFeedback("No entities exist");
	}

	// Things can't do in ViewModeHandler should go here

	protected boolean handleCommands(int key, int modifiers, Object object) 
	{
		boolean	handled = false;

//		System.out.println("EditModeHandler:handleCommands(" + key + ", " + ", " + modifiers + ", " + object +")");

		if ((modifiers & Event.SHIFT_MASK) != 0) {
			switch (key) {
			case Do.DELETE:	// Special key so SHIFT still set
				DeleteEdge(object);
				return true;
			}
		} else if (modifiers == 0) {
			switch(key) {
			case Do.DELETE:
				m_ls.DeleteEntity(object);
				return true;
			case Do.INCREASE_LABEL_FONT:
				deltaFont(1);
				handled = true;
				break;
			case Do.DECREASE_LABEL_FONT: 
				deltaFont(-1);
				handled = true;
				break;
			case Do.NEW_ENTITY:
			{
				EntityInstance e = m_dg.targetEntity(object);
				if (e == null) {
					return false;
				}				
				m_ls.newEntity(e);
				handled = true;
				break;
			}
			case Do.EDIT_ENTITY_CLASS:
			{
				EntityInstance e = m_dg.targetEntity(object);
				if (e == null) {
					return false;
				}
				// edit class attributes
				EditAttribute.Create(m_ls, e.getEntityClass());
				handled = true;
				break;
			}
			case Do.EDIT_ATTRIBUTES:
			{
				EntityInstance e = m_dg.targetEntity(object);
				if (e == null) {
					return false;
				}
				// edit attributes
				EditAttribute.Create(m_ls, e);
				handled = true;
				break;
			}
			case Do.EDIT_REL_CLASS:
			{
				RelationInstance ri = m_dg.targetRelation(object);
				if (ri == null) {
					return false;
				}
				// edit class attributes
				EditAttribute.Create(m_ls, ri.getRelationClass());
				handled = true;
				break;
			}
			case Do.EDIT_REL_ATTRIBUTES:
			{
				RelationInstance ri = m_dg.targetRelation(object);
				if (ri == null) {
					return false;
				}
				// edit attributes
				EditAttribute.Create(m_ls, ri);
				handled = true;
				break;
			}
			case Do.DELETE_CONTAINER:
			{
				EntityInstance e = m_dg.targetEntity(object);

				if (e == null) {
					return false;
				}
				if (e == m_dg.getRootInstance()) {
					m_ls.error("Can't delete root instance");
					return false;
				}
				m_ls.deleteContainer(e);
				handled = true;
				break;
			}
			case Do.MOVE_REDBOXES:
				moveRedBoxes(object);
				handled = true;
				break;
		}	}
		if (handled) {
			m_ls.redrawDg();
		} else {
			handled = super.handleCommands(key, modifiers, object);
		}
		return handled;
	}

	// --------------
	// Public methods
	// --------------

	public void select(Diagram dg) 
	{
		super.select(dg);
		dg.setDrawBends(true);
	}

	protected void DeleteEdge(Object object) 
	{
		RelationInstance ri = m_dg.targetRelation(object);

		if (ri != null) {
			m_ls.doFeedback("Edge deleted.");
			m_dg.deleteEdge(ri);
			m_dg.redrawDiagram();

	}	}

	public void movedOverThing(MouseEvent ev, Object thing, int x, int y) 
	{
		if (thing instanceof RelationInstance) {
			RelationInstance ri = (RelationInstance) thing;
			EdgePoint edgepoint = ri.mouseOverEdgePoint(x, y);
			if (edgepoint != null) {
				m_ls.setAnticipateCursor(Cursor.CROSSHAIR_CURSOR);
				return;
		}	}
		super.movedOverThing(ev, thing, x, y);
	}
}
