package lsedit;

import java.awt.Color;

import java.util.*;
import java.io.*;
import java.lang.*;


public class EntityClass extends LandscapeClassObject /* extends LandscapeObject3D extends LandscapeObject */ 
{
	public static final String ENTITY_BASE_CLASS_ID		= "$ENTITY";

	public static final int ENTITY_STYLE_NONE           = -1;
	public static final int ENTITY_STYLE_3DBOX			= 0;
	public static final int ENTITY_STYLE_2DBOX			= 1;
	public static final int ENTITY_STYLE_FILE			= 2;
	public static final int ENTITY_STYLE_DISK			= 3;
	public static final int ENTITY_STYLE_FOLDER			= 4;
	public static final int ENTITY_STYLE_SOURCEOBJ		= 5;
	public static final int ENTITY_STYLE_CLASS			= 6;
	public static final int ENTITY_STYLE_GROUP			= 7;
	public static final int ENTITY_STYLE_LABELLED_GROUP = 8;

	public static final String[] styleName =
		{ 
				"3D Box", 
				"2D Box", 
				"File", 
				"Disk", 
				"Folder", 
				"Source Object", 
				"Class", 
				"Group", 
				"Labelled Group"
		};

	// ----------------
	// Exported methods
	// ----------------

	// Constructor 

	public EntityClass(String id, int nid, EntityClass pec, Diagram dg) 
	{
		setId(id);
		setNid(nid); 
		setLabel(id); 
		setDiagram(dg);

		addParentClass(pec);

		setStyle(ENTITY_STYLE_3DBOX);
		setObjectColor(Color.blue);		// Fill colour
		setLabelColor(Color.cyan);		// Label colour
	}

	public void writeAttributes(PrintStream ps) throws IOException {

		ps.print(qt(getId()) + " {\n");
		super.writeAttributes(ps);
		ps.print("}\n\n"); 
	}

	public EntityInstance newEntity(String id) 
	{
		EntityInstance e = new EntityInstance(this, id);
		makeInstanceOfUs(e);
		return e;
	}

	// Accessor functions

	public String addParentClass(EntityClass inherits) 
	{
		return addParentClass(inherits, ENTITY_BASE_CLASS_ID);
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes

	public int getPrimaryAttributeCount()
	{
		return(7);
	}

	public String getLsAttributeNameAt(int index)
	{
		String	name;

		switch (index) {
		case 0:
			name  = "id";
			break;
		case 1:
			name  = CLASSLABEL_ID;
			break;
		case 2:
			name  = CLASSDESC_ID;
			break;
		case 3:
			name  = CLASSSTYLE_ID;
			break;	
		case 4:
			name  = COLOUR_ID;
			break;
		case 5:
			name  = LABEL_COLOUR_ID;
			break;
		case 6:
			name  = OPEN_COLOUR_ID;
			break;
		default:
			name  = super.getLsAttributeNameAt(index);
		}
		return(name);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Object	value;

		switch (index) {
		case 0:
			value = getId();
			break;
		case 1:
			value = getLabel();
			break;
		case 2:
			value = getDescription();
			break;
		case 3:
			value = new Integer(getStyle());
			break;
		case 4:
			if (hasObjectColor()) {
				value = getObjectColor();
			} else {
				value = null;
			}
			break;
		case 5:
			if (hasLabelColor()) {
				value = getLabelColor();
			} else {
				value = null;
			}
			break;
		case 6:
			value = getColorWhenOpen();
			break;
		default:
			value = super.getLsAttributeValueAt(index);
		}
		return(value);
	}

	public void setAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case 0:
			setId((String) value);
			break;
		case 1:
			setLabel((String) value);
			break;
		case 2:
			setDescription((String) value);
			break;
		case 3:
			setStyle(((Integer) value).intValue());
			break;
		case 4:
			setObjectColor((Color) value);
			break;
		case 5:
			setLabelColor((Color) value);
			break;
		case 6:
			setColorWhenOpen((Color) value);
			break;
		default:
			super.setAttributeValueAt(index, value);
	}	}

	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getLsAttributeTypeAt(int index)
	{
		int		ret;
		
		switch (index) {
		case 0:
		case 1:
			ret = Attribute.STRING_TYPE;
			break;
		case 2:
			ret = Attribute.TEXT_TYPE;
			break;
		case 3:
			ret = Attribute.STYLE_TYPE;
			break;
		case 4:
		case 5:
		case 6:
			ret = Attribute.COLOR_OR_NULL_TYPE;
			break;
		default:
			ret = super.getLsAttributeTypeAt(index);
		}
		return(ret);
	}
}



