package lsedit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Event;
import java.util.regex.Pattern;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;



public class FindBox extends JDialog implements ActionListener, ItemListener
{
	public static final int FIND = 0;
	public static final int CANCEL = 1;

	public static boolean substrings = false;
	public static boolean casesens = true;

	protected JButton findButton, canButton;
	protected JLabel label;
	protected JTextField text;
	protected JCheckBox cb_case;

	protected static String searchStr = "";

	public FindBox(JFrame f, String title)
	{
		super(f, title, true);

		Container	contentPane = getContentPane();

		// Create a dialog 

		contentPane.setLayout(new BorderLayout());

		JLabel l = new JLabel("");

		contentPane.add("West", l);

		l = new JLabel("");

		contentPane.add("East", l);

		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());

		label = new JLabel("Any java.util.regex.Pattern:");
		p.add("North", label);

		// Create input component and add it to the window

		text = new JTextField(searchStr, 30);
		p.add("Center", text);
		text.addActionListener(this);

		cb_case = new JCheckBox("Case sensitive");
		cb_case.setSelected(casesens);
		p.add("South", cb_case);
		cb_case.addItemListener(this);

		contentPane.add("Center", p);

		p = new JPanel();
		p.setLayout(new FlowLayout());

		findButton = new JButton("Find");
		p.add(findButton);
		findButton.addActionListener(this);

		canButton = new JButton("Cancel");
		p.add(canButton);
		canButton.addActionListener(this);

		contentPane.add("South", p);

		// Resize the window to the preferred size of its components

		this.pack();
	}

	public static Pattern Create(JFrame frame, String banner) 
	{
		FindBox mb      = new FindBox(frame, banner);
		Pattern pattern;
		int	flags;

		mb.setLocation(frame.getX()+200, frame.getY()+300);
		mb.setVisible(true);

		try {
			if (searchStr.equals("*")) {
				searchStr = ".*";
			}
			if (casesens) {
				flags = 0;
			} else {
				flags = Pattern.CASE_INSENSITIVE;
			}
			flags |= Pattern.DOTALL;
			
			pattern = Pattern.compile(searchStr, flags);
		} catch (Exception e) {
			pattern = null;
		}
		return(pattern);
	}

	// ActionListener interface

	public void actionPerformed(ActionEvent ev)
	{
		Object	source;

		// Pop down the window when the button is clicked.
		// System.out.println("event: " + ev);

		source = ev.getSource();

		if (source == findButton || source == text) {
			this.setVisible(false);
			this.dispose();
			searchStr = text.getText();
			return;
		}

		if (source == canButton) {
			this.setVisible(false);
			this.dispose();
			return;
		}
	}

	// ItemListener interface

	public void itemStateChanged(ItemEvent ev)
	{
		casesens = cb_case.isSelected();
	}




}

