package lsedit;

import java.awt.Rectangle;
import java.util.*;



public class FlipLayoutVertically extends LandscapeLayouter  implements ToolBarEventHandler 
{
	public FlipLayoutVertically(LandscapeViewerCore ls) 
	{
		super(ls);
	}

	public String getMenuLabel() 
	{
		return "Flip layout vertically";
	}

	public String doLayout(Diagram dg) 
	{
		EntityInstance pe = dg.getDrawRoot();
		Enumeration en;
		EntityInstance ce;

		for (en = pe.getChildren(); en.hasMoreElements();) {
			ce = (EntityInstance) en.nextElement();
			ce.setyRelLocal(1.0 - ce.yRelLocal() - ce.heightRelLocal());
		}
		return "Layout flipped vertically";
	}

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram	dg;
		String	rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			dg.redrawDiagram();
			m_ls.doFeedback(rmsg);
	}	}

}

