package lsedit;

import java.awt.Rectangle;
import java.util.*;



public class GridGroupHorizontally extends LandscapeLayouter  implements ToolBarEventHandler 
{
	public GridGroupHorizontally(LandscapeViewerCore ls) 
	{
		super(ls);
	}

	public String getMenuLabel() 
	{
		return "Layout group horizontally";
	}

	public String doLayout(Diagram dg) 
	{
		Vector		cset;
		double		scaleX;
		double		startX, x, y, height, width;
		double		gap;
		int			num;
		Enumeration	en;
		EntityInstance ke, ce;   

		cset = dg.getGroup();
		if (cset == null) {
			beep();
			return "No group selected";
		}
		ke = dg.getKeyEntity();
		if (ke == null) {
			beep();
			return "No key entitity";
		}

		num    = 0;
		width  = 0;
		for (en = cset.elements(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			width += ce.widthRelLocal();
			++num;
		}

		if (num == 0) {
			return "Empty group";
		}

		y      = ke.yRelLocal();
		height = ke.heightRelLocal();
		gap    = (width/(num*10.0));	// Presume the gap is 0.1 of the average width
		width += gap*(num-1);			
		startX = ke.xRelLocal();

		if (width + startX > 0.95) {
			startX = 0.95 - width;
			if (startX < 0.05) {
				startX = 0.05;
			}
			ke.setxRelLocal(startX);
		}

		if (width + startX > 0.95) {
			scaleX = 0.95/(width+startX);
			gap   *= scaleX;
			ke.setwidthRelLocal(ke.widthRelLocal()*scaleX);
		} else {
			scaleX = 1.0;
		}

		x = startX + ke.widthRelLocal(); 
		for (en = cset.elements(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			if (ce != ke) {
				x += gap;
				ce.setxRelLocal(x);
				ce.setyRelLocal(y);
				ce.setheightRelLocal(height);
				if (scaleX != 1.0) {
					ce.setwidthRelLocal(ce.widthRelLocal() * scaleX);
				}
				x += ce.widthRelLocal();
		}	}

		return "Laid out group to grid horizontally";
	}

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram	dg;
		String	rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			m_ls.doFeedback(rmsg);
			dg.redrawDiagram();
	}	}

}

