package lsedit;

import java.awt.Rectangle;
import java.util.*;



public class GridGroupVertically extends LandscapeLayouter  implements ToolBarEventHandler {

	public GridGroupVertically(LandscapeViewerCore ls)
	{
		super(ls);
	}

	public String getMenuLabel() 
	{
		return "Layout group vertically";
	}

	public String doLayout(Diagram dg) 
	{
		Vector		cset;
		double		scaleY;
		double		startY, x, y, height, width;
		double		gap;
		int			num;
		Enumeration	en;
		EntityInstance ke, ce;   

		cset = dg.getGroup();
		if (cset == null) {
			beep();
			return "No group selected";
		}
		ke = dg.getKeyEntity();
		if (ke == null) {
			beep();
			return "No key entitity";
		}

		num    = 0;
		height = 0;
		for (en = cset.elements(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			height += ce.heightRelLocal();
			++num;
		}

		if (num == 0) {
			return "Empty group";
		}

		x      = ke.xRelLocal();
		width  = ke.widthRelLocal();
		gap    = (height/(num*10.0));	// Presume the gap is 0.1 of the average height
		height += gap*(num-1);			
		startY = ke.yRelLocal();

		if (height + startY > 0.95) {
			startY = 0.95 - height;
			if (startY < 0.05) {
				startY = 0.05;
			}
			ke.setyRelLocal(startY);
		}

		if (height + startY > 0.95) {
			scaleY = 0.95/(height+startY);
			gap   *= scaleY;
			ke.setheightRelLocal(ke.heightRelLocal()*scaleY);
		} else {
			scaleY = 1.0;
		}

		y = startY + ke.heightRelLocal(); 
		for (en = cset.elements(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			if (ce != ke) {
				y += gap;
				ce.setyRelLocal(y);
				ce.setxRelLocal(x);
				ce.setwidthRelLocal(width);
				if (scaleY != 1.0) {
					ce.setheightRelLocal(ce.heightRelLocal() * scaleY);
				}
				y += ce.heightRelLocal();
		}	}

		return "Laid out group to grid vertically";
	}

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram	dg;
		String	rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			m_ls.doFeedback(rmsg);
			dg.redrawDiagram();
	}	}
}