package lsedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

/* This handler is responsible for moving things about on the screen
   when dragged.
 */

public class GroupModeHandler extends LandscapeModeHandler
{

	// A small JComponent so that the whole handler doesn't need to be one
	// This object just draws the outline of the thing(s) being moved

	protected class DrawOutline extends JComponent
	{
		private GroupModeHandler	m_handler;

		public DrawOutline(GroupModeHandler handler)
		{
			super();
			m_handler = handler;
			setForeground(Color.BLACK);
		}

		public void paintComponent(Graphics g)
		{
			super.paintComponent(g);

			Rectangle rect, shift;

			rect  = m_handler.getRect();
			shift = m_handler.getShift();

			if (rect != null) {
				g.drawRect(rect.x, rect.y, rect.width, rect.height);
			}
			if (shift != null) {

				Enumeration		en;
				EntityInstance	e;
				int			x, y, width, height;
				int			dx, dy;
				Rectangle		grpLayout;

				grpLayout = m_handler.getGrpLayout();

				dx = shift.x - grpLayout.x;
				dy = shift.y - grpLayout.y; 

				for (en = m_handler.getGroupList().elements(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement(); 
					g.drawRect(e.getDiagramX()+dx, e.getDiagramY()+dy, e.getWidth(), e.getHeight());
	}	}	}	}

	protected static final int NONE				= 0;
	protected static final int GROUPING			= 1;
	protected static final int SINGLE_MOVE		= 2;

	protected DrawOutline	m_drawOutline;				// The outline drawn
	protected Vector		m_groupList = null;			// List of entities
	protected Rectangle		m_grpLayout;
	protected int			m_curX, m_curY;
	protected Rectangle		m_shift = null;

	protected int m_groupMode = NONE;

	protected double m_dx, m_dy;

	protected LandscapeModeHandler parent = null;

	private	  boolean seen_motion;
	private	  Rectangle	m_rect;

	protected void setShift(int x, int y, int width, int height)
	{
		if (m_shift == null) {
			m_shift        = new Rectangle(x, y, width, height);
			m_drawOutline.setBounds(m_dg.getBounds());
			m_drawOutline.setVisible(true);
			m_dg.add(m_drawOutline /* JLayeredPane.PALETTE_LAYER */ , 0);
		} else {
			m_shift.setBounds(x, y, width, height);
			m_drawOutline.repaint();
		}
	}

	protected void clearShift()
	{
		if (m_shift != null) {
			m_shift = null;
			m_rect  = null;
			m_drawOutline.setVisible(false);
			m_dg.remove(m_drawOutline);
	}	}

	// Group entities

	protected EntityInstance findOverlap(Rectangle lyt) 
	{
		double dx = lyt.x - m_grpLayout.x;
		double dy = lyt.y - m_grpLayout.y;

		EntityInstance e = m_dg.getKeyEntity();

		Rectangle elyt = e.getDiagramBounds();

		elyt.x += dx;
		elyt.y += dy;

		EntityInstance oe = m_dg.intersects(lyt);

		if (oe != null && !m_groupList.contains(oe)) {
			return oe;
		}

		Enumeration en = m_groupList.elements();

		while (en.hasMoreElements()) {
			e = (EntityInstance) en.nextElement();

			elyt = e.getDiagramBounds();

			elyt.x += dx;
			elyt.y += dy;

			oe = m_dg.intersects(lyt);

			if (oe != null && !m_groupList.contains(oe)) {
				return oe;
			}
		}
		return null;
	}

	protected void moveGroup(EntityInstance container, double dx, double dy) 
	{
		EntityInstance e = (EntityInstance) m_groupList.firstElement();
		boolean changeParent = (e.getContainedBy() != container);

		int width  = 0;
		int height = 0;

		Enumeration en;

		if (changeParent) {
			int num = container.numChildren();

			if (num == 0) {
				Rectangle plyt = e.getContainedBy().getDiagramBounds();
				Rectangle nplyt = container.getDiagramBounds();

				double xs = ((double) nplyt.width)/((double) plyt.width);
				double ys = ((double) nplyt.height)/((double) plyt.height);

				Rectangle lyt = e.getDiagramBounds();

				width  = (int) (lyt.width  * xs);
				height = (int) (lyt.height * ys);
//				System.out.println("moveGroup width=" + width + " height=" + height + " lyt=" + lyt + " xs=" + xs + " ys=" + ys);
			}
			else {
				for (en = container.getChildren(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();

					Rectangle elyt = e.getDiagramBounds();

					width  += elyt.width;
					height += elyt.height;
				} 
				width  /= num;
				height /= num;
			}
		}

		for (en = m_groupList.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();

			Rectangle elyt = e.getDiagramBounds();

			elyt.x += dx;
			elyt.y += dy;
			
//			System.out.println("Moving to " + elyt + " under " + container + " at " + container.getDiagramX() + ", " + container.getDiagramY());

			if (changeParent) {
				elyt.width  = width;
				elyt.height = height;
			}

			m_ls.moveEntityContainment(container, e);
			e.setDiagramBounds(elyt);
//			System.out.println("MoveGroup " + e.m_label + " " + e.getBounds() + e.getParent());
		}

		if (changeParent) {
			m_dg.prepostorder();
		}

		for (en = m_groupList.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.validateEdges();
		}
	}

	protected void moveGroup(EntityInstance container) 
	{
		double dx = m_shift.x - m_grpLayout.x;
		double dy = m_shift.y - m_grpLayout.y;

//		System.out.println("m_shift    =" + m_shift + "\nm_grpLayout=" + m_grpLayout + " dx=" + dx + " dy=" + dy);
		moveGroup(container, dx, dy);
	}

	protected void setAsKeyEntity(EntityInstance e) 
	{
		m_dg.setKeyEntity(e);
	}

	protected void selectEntity(EntityInstance e) 
	{
		m_dg.setPreserveEntityMarks(EntityInstance.GROUP_MARK | EntityInstance.GROUPKEY_MARK);
		m_dg.setPreserveRelationMarks(0);

		if (e.getGroupFlag()) {
			// Already a member of a group

			if (e != m_dg.getKeyEntity()) {
				setAsKeyEntity(e);
			}
		} else {
			EntityInstance old_ke = m_dg.getKeyEntity();

			if (old_ke != null) {
				boolean ret;

				ret = m_dg.clearFlags();
				m_dg.setKeyEntity(e);
				if (ret) {
					m_ls.repaintDg();
				}
			} else {
				setAsKeyEntity(e);
			}
		}
		show_groupList();
	}

	protected void toggleMembership(EntityInstance e) 
	{
		if (e.getGroupFlag()) {
			if (e == m_dg.getKeyEntity()) {
				Vector grp = m_dg.getGroup();

				if (grp.size() == 1) {
					m_dg.clearFlags();
					e.repaint();
				} else {
					e.clearGroupFlag();
					grp = m_dg.getGroup();

					EntityInstance nke = (EntityInstance) grp.firstElement();

					setAsKeyEntity(nke);
				}
			} else {
				e.clearGroupFlag();
				e.repaint();
			}
		} else {
			Vector grp = m_dg.getGroup();

			if (grp != null) {
				// See if this is in same container as others

				EntityInstance fe = (EntityInstance) grp.firstElement();

				if (fe.getContainedBy() != e.getContainedBy()) {
					selectEntity(e);
					return;
				}
			}
			setAsKeyEntity(e);
		}

		show_groupList();
	}

	protected boolean groupingStart(MouseEvent ev, int x, int y) 
	{
		m_curX = x;
		m_curY = y;
		clearShift();
		return true;
	}

	protected void groupingMotion(MouseEvent ev, Object thing, int x, int y) 
	{
		if (thing instanceof EntityInstance) {
			int shiftX, shiftY, shiftWidth, shiftHeight;
			int	nx, ny;

			// Constrain it to container

			nx = x;
			ny = y;

			Rectangle lyt = ((EntityInstance) thing).getDiagramBounds();

			if (nx < lyt.x+LandscapeViewerCore.GAP) {
				nx = lyt.x+LandscapeViewerCore.GAP;
			} else if (nx > lyt.x+lyt.width-LandscapeViewerCore.GAP) {
				nx = lyt.x+lyt.width-LandscapeViewerCore.GAP;
			}

			if (ny < lyt.y+LandscapeViewerCore.GAP) {
				ny = lyt.y+LandscapeViewerCore.GAP;
			} else if (ny > lyt.y+lyt.height-LandscapeViewerCore.GAP) {
				ny = lyt.y+lyt.height-LandscapeViewerCore.GAP;
			}

			// Calculate new Rectangle rectangle

			if (nx > m_curX) {
				shiftX     = m_curX;
				shiftWidth = nx-m_curX;
			}
			else {
				shiftX     = nx;
				shiftWidth = m_curX-nx;
			}

			if (ny > m_curY) {
				shiftY      = m_curY;
				shiftHeight = y-m_curY;
			} else {
				shiftY      = y;
				shiftHeight = m_curY-y;
			}

			setShift(shiftX, shiftY, shiftWidth, shiftHeight);
			// Draw a box
			m_rect = m_shift;
			m_drawOutline.repaint();
	}	}

	protected void groupingEnd(MouseEvent ev) 
	{
		// Flag all entities intersecting group box as being part of a group

		Vector gl = m_dg.setGroupRegion(m_shift);

		if (gl != null) {
			show_groupList();
			m_dg.setKeyEntity((EntityInstance) gl.firstElement());
			m_rect = null;
		} else {
			m_rect = m_shift;
		}
		m_drawOutline.repaint();
	}

	protected boolean moveGroupStart(MouseEvent ev, int x, int y) 
	{
		m_groupList = m_dg.getGroup();

		seen_motion = false;

		if (m_groupList == null) {
			return false;
		}

		EntityInstance pe = ((EntityInstance) m_groupList.firstElement()).getContainedBy();

		if (pe == null) {
			return false;
		}

		m_grpLayout = m_dg.getGroupBoundingBox();
		setShift(m_grpLayout.x, m_grpLayout.y, m_grpLayout.width, m_grpLayout.height);
		m_dx	  = x - m_shift.x;
		m_dy	  = y - m_shift.y;

		if (m_groupList.size() == 1) {
			m_ls.doFeedback("Moving entity: (" + m_shift.x + ", " + m_shift.y + ")");
		}
		else {
			m_ls.doFeedback("Moving group (key): (" + m_shift.x + ", " + m_shift.y + ")");
		}
		return true;
	}

	protected void moveGroupMotion(MouseEvent ev, int x, int y) 
	{
		// Make sure we don't moved out of the root

		if (!seen_motion) {
			EntityInstance pe = ((EntityInstance) m_groupList.firstElement()).getContainedBy();
			seen_motion = true;
		}

		Rectangle lyt = m_dg.getDrawRoot().getDiagramBounds();

		int grid = m_dg.getGrid();

		double nx = (Math.round(x-m_dx)/grid)*grid;
		double ny = (Math.round(y-m_dy)/grid)*grid;

		if (nx < lyt.x+LandscapeViewerCore.GAP) {
			nx = lyt.x+LandscapeViewerCore.GAP;
		}

		if (ny < lyt.y+LandscapeViewerCore.GAP) {
			ny = lyt.y+LandscapeViewerCore.GAP;
		}

		if (nx+m_shift.width > lyt.x+lyt.width-2*LandscapeViewerCore.GAP) {
			nx = lyt.x+lyt.width-m_shift.width-2*LandscapeViewerCore.GAP;
		}
		if (ny+m_shift.height > lyt.y+lyt.height-2*LandscapeViewerCore.GAP) {
			ny = lyt.y+lyt.height-m_shift.height-2*LandscapeViewerCore.GAP;
		}

		m_shift.x = (int) nx;
		m_shift.y = (int) ny;

		if (m_groupList.size() == 1) {
			m_ls.doFeedback("Moving entity: (" + Math.round(nx) + ", " + Math.round(ny) + ")");
		} else {
			m_ls.doFeedback("Moving group (key): (" + Math.round(nx) + ", " + Math.round(ny) + ")");
		}
		m_drawOutline.repaint();
	}

	protected void moveGroupEnd(MouseEvent ev) 
	{
		m_ls.clearFeedback();

		if (!seen_motion) {
			clearShift();
			return;
		}

		EntityInstance ke = m_dg.getKeyEntity();
		
		double dx = m_shift.x - m_grpLayout.x;
		double dy = m_shift.y - m_grpLayout.y;

		Rectangle klyt = ke.getDiagramBounds();

		klyt.x += dx;
		klyt.y += dy;

		EntityInstance container = m_dg.containing(klyt);

		if (container == null) {
			m_ls.error("Failed to find container");
			clearShift();
			return;
		}

		boolean changeParent = (container != ke.getContainedBy());
		
		if (changeParent && container.getContainedBy() == null /* Dont move into $ROOT */) {
			m_ls.error("Can't move into $ROOT");
			clearShift();
			return;
		}

		if (m_groupList.contains(container)) {
			container = container.getContainedBy();
		}

		moveGroup(container);

		if (changeParent) {
			m_dg.setContainElision(container, true);
			m_ls.doFeedback("Group move into: " + container.getLabel());
		}

		clearShift();
	}

	//
	// Public methods
	//

	public GroupModeHandler(LandscapeModeHandler parent) 
	{
		this.parent   = parent;
		m_drawOutline = new DrawOutline(this);
	}

	public void select(Diagram dg) 
	{
		if (m_dg != dg) {
			clearShift();
			super.select(dg);
	}	}

	public Rectangle getRect()
	{
		return(m_rect);
	}

	public Rectangle getShift()
	{
		return(m_shift);
	}

	public Rectangle getGrpLayout()
	{
		return(m_grpLayout);
	}

	public Vector getGroupList()
	{
		return(m_groupList);
	}

	public void halt() 
	{
		m_groupMode = NONE;
	}

	public void show_groupList() 
	{
		Vector grp = m_dg.getGroup();

		if (grp != null) {
			SortVector.byString(grp);
			m_ls.showResults("GROUP:", grp, false);
		}
		else {
			m_ls.error("No entities selected");
		}
	}

	public void groupAll() 
	{
		boolean ret;

		EntityInstance ke = m_dg.getKeyEntity();
		EntityInstance ge = ke;
		Enumeration en;
		EntityInstance ce;

		if (ke == null) {
			ke = m_dg.getDrawRoot();
			ge = ke;
		}

		ret = m_dg.clearFlags();

		if (!ge.isOpen()) {
			ge = ge.getContainedBy();
		}

		for (en = ge.getChildren(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			ce.setGroupFlag();
		}

		Vector grp = m_dg.getGroup();

		if (grp != null) {
			if (!grp.contains(ke))
				ke = (EntityInstance) grp.firstElement();

			m_dg.setKeyEntity(ke);
			m_dg.setPreserveEntityMarks(EntityInstance.GROUP_MARK|EntityInstance.GROUPKEY_MARK);
			m_dg.setPreserveRelationMarks(0);

			if (ret) {
				m_ls.redrawDg();
			}
			show_groupList();
		} else {
			m_ls.error("No entities selected");
		}
	}

	public void moveGroup(int key) 
	{
		m_groupList = m_dg.getGroup();

		if (m_groupList == null)
			return;

		EntityInstance pe = m_dg.getKeyEntity().getContainedBy();

		double dx = 0;
		double dy = 0;

		switch(key) {
		case Do.MOVE_GROUP_UP:
			dx = 0;
			dy = -1;
			break;

		case Do.MOVE_GROUP_DOWN:
			dx = 0;
			dy = 1;
			break;

		case Do.MOVE_GROUP_RIGHT:
			dx = 1;
			dy = 0;
			break;

		case Do.MOVE_GROUP_LEFT:
			dx = -1;
			dy = 0;
			break;
		}

		moveGroup(pe, dx, dy);
	}

	public boolean entityPressed(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("GroupModeHandler mousedown e=" + e + " x=" + x + " y=" + y);

		if (ev.isShiftDown()) {
			if (ev.isAltDown()) {
				m_groupMode = GROUPING;
				return groupingStart(ev, x, y);
			} else if (ev.isMetaDown()) {
				if (e != m_dg.getDrawRoot()) {
					setAsKeyEntity(e);
				}
			} else {
				if (e != m_dg.getDrawRoot()) {
					toggleMembership(e);
			}	}
		} else { 
			if (e != m_dg.getDrawRoot() && !e.isClientOrSupplier()) {
				selectEntity(e);
				m_ls.setCursor(Cursor.MOVE_CURSOR);
				m_groupMode = SINGLE_MOVE;

				return moveGroupStart(ev, x, y);
			}

			// Otherwise it is a selection event

			selectEntity(e);
			m_groupMode = NONE;
			return true;
		}

		m_groupMode = NONE;
		return false;
	}

	public boolean entityDragged(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("GroupModeHandler.entityDragged()" + ((m_groupMode == GROUPING) ? "GROUPING" : "SINGLE_MOVE") );
		switch(m_groupMode)	{
		case GROUPING:
			groupingMotion(ev, e, x, y);
			break;

		case SINGLE_MOVE:
			moveGroupMotion(ev, x, y);
			break;
		}
		return true;
	}

	public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) 
	{
		switch(m_groupMode)
		{
		case GROUPING:
			groupingEnd(ev);
			break;

		case SINGLE_MOVE:
			moveGroupEnd(ev);
			break;

		default:
			return;
		}

		m_ls.setCursor(Cursor.DEFAULT_CURSOR);
		m_groupMode = NONE;
	}

	public boolean relationPressed(MouseEvent ev, RelationInstance ri, int x, int y)
	{
		ri.setGroupAndHighlightFlag();
		return false;
	}
}
