package lsedit;

import java.awt.Rectangle;
import java.util.*;
import java.awt.event.*;

// Base class for layout classes accessed by Landscape Editor
//
// For a layouter to be available in the Landscape Editor, an instance entry
// must appear in the layouterList array in class LayouterManager.java

abstract public class LandscapeLayouter implements ToolBarEventHandler
{
	protected LandscapeViewerCore m_ls;

	protected void beep() 
	{
		System.out.print("\007");
		System.out.flush();
	}	 

	// --------------
	// Public methods
	// --------------

	public LandscapeLayouter(LandscapeViewerCore ls) 
	{
		m_ls = ls;
	}

	// -----------------------
	// Abstract public methods
	// -----------------------

	// Called by system to obtain menu entry label for this layout routine

	abstract String getMenuLabel();

	// Called by the system when a layout is requested
	// Needs to be supplied by layout classes which derive from this
	// base class.
	//
	// Returns a status/error message string.

	abstract public String doLayout(Diagram dg);

	// ToolBarEventHandler

	public void actionPerformed(ActionEvent ev)
	{
	}

	public void showInfo(String msg)
	{
	}
}

